/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.spells;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.paleimitations.schoolsofmagic.common.MagicElement;
import com.paleimitations.schoolsofmagic.common.MagicSchool;
import com.paleimitations.schoolsofmagic.common.data.capabilities.magic_data.IMagicData;
import com.paleimitations.schoolsofmagic.common.data.capabilities.magic_data.MagicDataProvider;
import com.paleimitations.schoolsofmagic.common.registries.MagicElementRegistry;
import com.paleimitations.schoolsofmagic.common.registries.MagicSchoolRegistry;
import com.paleimitations.schoolsofmagic.common.spells.events.SpellEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.eventbus.api.Event;

public class Spell
implements INBTSerializable<CompoundNBT> {
    private ResourceLocation resourceLocation;
    public int currentSpellChargeLevel;
    public int lastSpellChargeLevel;
    public int remainingUses;
    public int maxUses;
    public int minSpellChargeLevel;
    public int minSpellLevel;
    public int[] minSchoolLevels = new int[MagicSchoolRegistry.SCHOOLS.size()];
    public int[] minElementLevels = new int[MagicElementRegistry.ELEMENTS.size()];
    public boolean[] schools = new boolean[MagicSchoolRegistry.SCHOOLS.size()];
    public boolean[] elements = new boolean[MagicElementRegistry.ELEMENTS.size()];
    public List<ItemStack> materialComponents;

    public Spell(ResourceLocation resourceLocationIn, int minSpellChargeLevelIn, int minSpellLevelIn, Map<MagicSchool, Integer> minSchoolLevelsIn, Map<MagicElement, Integer> minElementLevelsIn, List<MagicSchool> schoolsIn, List<MagicElement> elementsIn, List<ItemStack> materialComponentsIn) {
        int i;
        this.resourceLocation = resourceLocationIn;
        this.minSpellChargeLevel = minSpellChargeLevelIn;
        this.currentSpellChargeLevel = minSpellChargeLevelIn;
        this.lastSpellChargeLevel = minSpellChargeLevelIn;
        this.maxUses = this.getUsesPerCharge(this.lastSpellChargeLevel);
        this.remainingUses = 0;
        this.minSpellLevel = minSpellLevelIn;
        for (MagicSchool school : minSchoolLevelsIn.keySet()) {
            this.minSchoolLevels[school.getId()] = minSchoolLevelsIn.get(school);
        }
        for (MagicElement element : minElementLevelsIn.keySet()) {
            this.minElementLevels[element.getId()] = minElementLevelsIn.get(element);
        }
        for (i = 0; i < MagicSchoolRegistry.SCHOOLS.size(); ++i) {
            this.schools[i] = schoolsIn.contains(MagicSchoolRegistry.getSchoolFromId(i));
        }
        for (i = 0; i < MagicElementRegistry.ELEMENTS.size(); ++i) {
            this.elements[i] = elementsIn.contains(MagicElementRegistry.getElementFromId(i));
        }
        this.materialComponents = materialComponentsIn == null ? Lists.newArrayList() : materialComponentsIn;
    }

    public Spell(CompoundNBT nbt) {
        this.deserializeNBT(nbt);
    }

    public Spell() {
        this(new ResourceLocation("schoolsofmagic", "none"), 0, 0, Spell.generateSchoolMap(new Map.Entry[0]), Spell.generateElementMap(new Map.Entry[0]), Lists.newArrayList(), Lists.newArrayList(), Lists.newArrayList());
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public static Map<MagicSchool, Integer> generateSchoolMap(Map.Entry<MagicSchool, Integer> ... entries) {
        HashMap map = Maps.newHashMap();
        for (MagicSchool school : MagicSchoolRegistry.SCHOOLS) {
            map.put(school, 0);
        }
        for (Map.Entry<MagicSchool, Integer> entry : entries) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public static Map<MagicElement, Integer> generateElementMap(Map.Entry<MagicElement, Integer> ... entries) {
        HashMap map = Maps.newHashMap();
        for (MagicElement element : MagicElementRegistry.ELEMENTS) {
            map.put(element, 0);
        }
        for (Map.Entry<MagicElement, Integer> entry : entries) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public List<MagicSchool> getSchools() {
        ArrayList schoolList = Lists.newArrayList();
        for (int i = 0; i < MagicSchoolRegistry.SCHOOLS.size(); ++i) {
            if (!this.schools[i]) continue;
            schoolList.add(MagicSchoolRegistry.getSchoolFromId(i));
        }
        return schoolList;
    }

    public List<MagicElement> getElements() {
        ArrayList elementList = Lists.newArrayList();
        for (int i = 0; i < MagicElementRegistry.ELEMENTS.size(); ++i) {
            if (!this.elements[i]) continue;
            elementList.add(MagicElementRegistry.getElementFromId(i));
        }
        return elementList;
    }

    public String getName() {
        return this.resourceLocation.func_110623_a();
    }

    public ResourceLocation getSpellIcon() {
        return new ResourceLocation(this.resourceLocation.func_110624_b(), "textures/gui/spell_icons/" + this.getName() + ".png");
    }

    public IMagicData getMagicData(PlayerEntity player) {
        return (IMagicData)player.getCapability(MagicDataProvider.MAGIC_DATA_CAPABILITY, null).orElseThrow(IllegalStateException::new);
    }

    public int getUsesPerCharge(int chargeLevel) {
        return 0;
    }

    public boolean canCast(PlayerEntity player) {
        IMagicData data = this.getMagicData(player);
        boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)new SpellEvent.Cast(this));
        if (this.isDisabled() || cancelled) {
            return false;
        }
        if (player.func_184812_l_()) {
            return true;
        }
        if (this.remainingUses > 0 || data.hasChargeLevel(this.currentSpellChargeLevel)) {
            int i;
            for (i = 0; i < MagicElementRegistry.ELEMENTS.size(); ++i) {
                if (data.getElementLevel(MagicElementRegistry.getElementFromId(i)) >= this.minElementLevels[i]) continue;
                if (!player.func_130014_f_().field_72995_K) {
                    player.func_145747_a((ITextComponent)new StringTextComponent("You aren't high enough level to use this spell."), Util.field_240973_b_);
                }
                return false;
            }
            for (i = 0; i < MagicSchoolRegistry.SCHOOLS.size(); ++i) {
                if (data.getSchoolLevel(MagicSchoolRegistry.getSchoolFromId(i)) >= this.minSchoolLevels[i]) continue;
                if (!player.func_130014_f_().field_72995_K) {
                    player.func_145747_a((ITextComponent)new StringTextComponent("You aren't high enough level to use this spell."), Util.field_240973_b_);
                }
                return false;
            }
            if (!this.materialComponents.isEmpty()) {
                for (ItemStack stack : this.materialComponents) {
                    if (player.field_71071_by.func_70431_c(stack)) continue;
                    if (!player.func_130014_f_().field_72995_K) {
                        player.func_145747_a((ITextComponent)new StringTextComponent("You're missing a material component."), Util.field_240973_b_);
                    }
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean castSpell(PlayerEntity player) {
        if (this.canCast(player)) {
            IMagicData data = this.getMagicData(player);
            if (!this.materialComponents.isEmpty()) {
                SpellEvent.MaterialCost costEvent = new SpellEvent.MaterialCost(this);
                MinecraftForge.EVENT_BUS.post((Event)costEvent);
                Random rand = new Random();
                block0: for (ItemStack stack : this.materialComponents) {
                    for (ItemStack inventoryStack : player.field_71071_by.field_70462_a) {
                        if (!stack.func_77969_a(inventoryStack) || inventoryStack.func_77984_f() && inventoryStack.func_77952_i() + stack.func_190916_E() >= inventoryStack.func_77958_k()) continue;
                        if (!(rand.nextFloat() >= costEvent.getDiscountChance())) continue block0;
                        if (inventoryStack.func_77984_f()) {
                            inventoryStack.func_196085_b(inventoryStack.func_77952_i() + stack.func_190916_E());
                            continue block0;
                        }
                        inventoryStack.func_190918_g(stack.func_190916_E());
                        continue block0;
                    }
                }
            }
            if (this.remainingUses == 0) {
                if (!player.func_184812_l_() || data.hasChargeLevel(this.currentSpellChargeLevel)) {
                    data.useCharge(this.currentSpellChargeLevel, this.getElements(), this.getSchools(), IMagicData.EnumMagicTool.SPELL);
                }
                this.maxUses = this.remainingUses = this.getUsesPerCharge(this.currentSpellChargeLevel);
                this.lastSpellChargeLevel = this.currentSpellChargeLevel;
            } else {
                --this.remainingUses;
            }
            return true;
        }
        return false;
    }

    public boolean isDisabled() {
        return false;
    }

    public ActionResultType interactLivingEntity(ItemStack stack, PlayerEntity player, LivingEntity living, Hand hand) {
        return ActionResultType.PASS;
    }

    public void releaseUsing(ItemStack stack, World world, LivingEntity living, int count) {
    }

    public void inventoryTick(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
    }

    public void onUsingTick(ItemStack stack, LivingEntity living, int count) {
    }

    public ActionResult<ItemStack> use(World world, PlayerEntity player, Hand hand, ItemStack stack) {
        return ActionResult.func_226250_c_((Object)stack);
    }

    public boolean useOnRelease() {
        return false;
    }

    public void onUseTick(World world, LivingEntity living, ItemStack stack, int count) {
    }

    public ActionResultType useOn(ItemUseContext context) {
        return ActionResultType.PASS;
    }

    public boolean onPlayerSwing(ItemStack stack, PlayerEntity player) {
        return false;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity living, LivingEntity attacker) {
        return false;
    }

    public boolean mineBlock(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity living) {
        return false;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, PlayerEntity player) {
        return false;
    }

    public UseAction getAction() {
        return UseAction.NONE;
    }

    public int getUseLength() {
        return 0;
    }

    public int[] getMinimumSchoolLevels() {
        return this.minSchoolLevels;
    }

    public int[] getMinimumElementLevels() {
        return this.minElementLevels;
    }

    public List<ItemStack> getMaterialComponents() {
        return this.materialComponents;
    }

    public CompoundNBT serializeNBT() {
        int i;
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("resourceLocation", this.resourceLocation.toString());
        nbt.func_74768_a("remainingUses", this.remainingUses);
        nbt.func_74768_a("maxUses", this.maxUses);
        nbt.func_74768_a("minSpellChargeLevel", this.minSpellChargeLevel);
        nbt.func_74768_a("currentSpellChargeLevel", this.currentSpellChargeLevel);
        nbt.func_74768_a("lastSpellChargeLevel", this.lastSpellChargeLevel);
        nbt.func_74768_a("minSpellLevel", this.minSpellLevel);
        nbt.func_74783_a("minSchoolLevels", this.minSchoolLevels);
        nbt.func_74783_a("minElementLevels", this.minElementLevels);
        for (i = 0; i < MagicSchoolRegistry.SCHOOLS.size(); ++i) {
            nbt.func_74757_a("school" + i, this.schools[i]);
        }
        for (i = 0; i < MagicElementRegistry.ELEMENTS.size(); ++i) {
            nbt.func_74757_a("element" + i, this.elements[i]);
        }
        nbt.func_74768_a("materialComponents_size", this.materialComponents.size());
        int m = 0;
        for (ItemStack stack : this.materialComponents) {
            nbt.func_218657_a("materialComponent" + m, (INBT)stack.serializeNBT());
            ++m;
        }
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        int i;
        this.resourceLocation = new ResourceLocation(nbt.func_74779_i("resourceLocation"));
        this.remainingUses = nbt.func_74762_e("remainingUses");
        this.maxUses = nbt.func_74762_e("maxUses");
        this.minSpellChargeLevel = nbt.func_74762_e("minSpellChargeLevel");
        this.currentSpellChargeLevel = nbt.func_74762_e("currentSpellChargeLevel");
        this.lastSpellChargeLevel = nbt.func_74762_e("lastSpellChargeLevel");
        this.minSpellLevel = nbt.func_74762_e("minSpellLevel");
        this.minSchoolLevels = nbt.func_74759_k("minSchoolLevels");
        this.minElementLevels = nbt.func_74759_k("minElementLevels");
        for (i = 0; i < MagicSchoolRegistry.SCHOOLS.size(); ++i) {
            this.schools[i] = nbt.func_74767_n("school" + i);
        }
        for (i = 0; i < MagicElementRegistry.ELEMENTS.size(); ++i) {
            this.elements[i] = nbt.func_74767_n("element" + i);
        }
        ArrayList materialComponentsIn = Lists.newArrayList();
        for (int i2 = 0; i2 < nbt.func_74762_e("materialComponents_size"); ++i2) {
            materialComponentsIn.add(ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("materialComponent" + i2)));
        }
        this.materialComponents = materialComponentsIn;
    }

    static enum SpellType {

    }
}

