/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.spells.spells;

import com.google.common.collect.Lists;
import com.paleimitations.schoolsofmagic.common.MagicElement;
import com.paleimitations.schoolsofmagic.common.MagicSchool;
import com.paleimitations.schoolsofmagic.common.registries.MagicElementRegistry;
import com.paleimitations.schoolsofmagic.common.registries.MagicSchoolRegistry;
import com.paleimitations.schoolsofmagic.common.registries.SoundRegistry;
import com.paleimitations.schoolsofmagic.common.spells.Spell;
import com.paleimitations.schoolsofmagic.common.spells.events.SpellEvent;
import com.paleimitations.schoolsofmagic.common.spells.modifiers.IHasAdjustableElements;
import com.paleimitations.schoolsofmagic.common.spells.modifiers.IHasMultiUses;
import com.paleimitations.schoolsofmagic.common.spells.modifiers.IHasPower;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.SmallFireballEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class BlazeSpell
extends Spell
implements IHasPower,
IHasMultiUses,
IHasAdjustableElements {
    public BlazeSpell() {
        super(new ResourceLocation("schoolsofmagic", "blaze"), 0, 0, BlazeSpell.generateSchoolMap(new Map.Entry[0]), BlazeSpell.generateElementMap(new Map.Entry[0]), Lists.newArrayList((Object[])new MagicSchool[]{MagicSchoolRegistry.EVOCATION}), Lists.newArrayList((Object[])new MagicElement[]{MagicElementRegistry.PYROMANCY}), Lists.newArrayList());
    }

    public BlazeSpell(CompoundNBT nbt) {
        this.deserializeNBT(nbt);
    }

    @Override
    public int getUsesPerCharge(int chargeLevel) {
        int chargeUses = 3;
        switch (chargeLevel) {
            case 1: {
                chargeUses = 5;
                break;
            }
            case 2: {
                chargeUses = 7;
                break;
            }
            case 3: {
                chargeUses = 9;
                break;
            }
            case 4: {
                chargeUses = 11;
                break;
            }
            case 5: {
                chargeUses = 13;
                break;
            }
            case 6: {
                chargeUses = 15;
                break;
            }
            case 7: {
                chargeUses = 17;
                break;
            }
            case 8: {
                chargeUses = 20;
            }
        }
        SpellEvent.UsesPerCharge event = new SpellEvent.UsesPerCharge(this, chargeLevel, chargeUses);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getUses();
    }

    @Override
    public int getMaxUses(int chargeLevel) {
        return this.getUsesPerCharge(chargeLevel);
    }

    @Override
    public int getUses() {
        return this.remainingUses;
    }

    @Override
    public ActionResult<ItemStack> use(World world, PlayerEntity player, Hand hand, ItemStack stack) {
        if (this.castSpell(player)) {
            Vector3d vec = player.func_70040_Z();
            SpellEvent.Power event = new SpellEvent.Power(this);
            MinecraftForge.EVENT_BUS.post((Event)event);
            double vX = vec.field_72450_a * (double)event.getMultiplier();
            double vY = vec.field_72448_b * (double)event.getMultiplier();
            double vZ = vec.field_72449_c * (double)event.getMultiplier();
            SmallFireballEntity fireball = new SmallFireballEntity(world, player.func_226277_ct_(), player.func_226278_cu_() + (double)player.func_70047_e(), player.func_226281_cx_(), vX, vY, vZ);
            player.field_70170_p.func_184148_a(player, player.func_213303_ch().field_72450_a, player.func_213303_ch().field_72448_b, player.func_213303_ch().field_72449_c, SoundRegistry.BLAZE, SoundCategory.PLAYERS, 1.0f, player.func_70681_au().nextFloat() * 0.4f + 0.8f);
            fireball.func_212361_a((Entity)player);
            if (!world.field_72995_K) {
                world.func_217376_c((Entity)fireball);
            }
            return ActionResult.func_226248_a_((Object)stack);
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    @Override
    public boolean isAcceptableElement(MagicElement element) {
        return element == MagicElementRegistry.CHAOTICS || element == MagicElementRegistry.INFERNALITY;
    }
}

