/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.spells.spells;

import com.google.common.collect.Lists;
import com.paleimitations.schoolsofmagic.common.MagicElement;
import com.paleimitations.schoolsofmagic.common.MagicSchool;
import com.paleimitations.schoolsofmagic.common.registries.MagicElementRegistry;
import com.paleimitations.schoolsofmagic.common.registries.MagicSchoolRegistry;
import com.paleimitations.schoolsofmagic.common.spells.Spell;
import com.paleimitations.schoolsofmagic.common.spells.events.SpellEvent;
import com.paleimitations.schoolsofmagic.common.spells.modifiers.IHasAdjustableElements;
import com.paleimitations.schoolsofmagic.common.spells.modifiers.IHasArea;
import com.paleimitations.schoolsofmagic.common.spells.modifiers.IHasPower;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BoneMealItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class GrowthSpell
extends Spell
implements IHasPower,
IHasArea,
IHasAdjustableElements {
    public GrowthSpell() {
        super(new ResourceLocation("schoolsofmagic", "growth"), 1, 0, GrowthSpell.generateSchoolMap(new Map.Entry[0]), GrowthSpell.generateElementMap(new Map.Entry[0]), Lists.newArrayList((Object[])new MagicSchool[]{MagicSchoolRegistry.ABJURATION}), Lists.newArrayList((Object[])new MagicElement[]{MagicElementRegistry.ANIMANCY}), Lists.newArrayList());
    }

    public GrowthSpell(CompoundNBT nbt) {
        this.deserializeNBT(nbt);
    }

    @Override
    public ActionResultType useOn(ItemUseContext context) {
        IGrowable growable;
        BlockPos pos = context.func_195995_a();
        BlockState state = context.func_195991_k().func_180495_p(pos);
        SpellEvent.Power power = new SpellEvent.Power(this);
        MinecraftForge.EVENT_BUS.post((Event)power);
        SpellEvent.Area area = new SpellEvent.Area(this);
        area.setAddition((float)this.currentSpellChargeLevel / 2.0f);
        MinecraftForge.EVENT_BUS.post((Event)area);
        if (state.func_177230_c() instanceof IGrowable && (growable = (IGrowable)state.func_177230_c()).func_176473_a((IBlockReader)context.func_195991_k(), pos, state, context.func_195991_k().field_72995_K) && this.castSpell(context.func_195999_j())) {
            int radius = Math.round(area.getAddition());
            for (int i = 0; i <= Math.round(power.getAddition()); ++i) {
                for (BlockPos adPos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-radius, 0, -radius), (BlockPos)pos.func_177982_a(radius, 0, radius))) {
                    BoneMealItem.applyBonemeal((ItemStack)new ItemStack((IItemProvider)Items.field_196106_bc), (World)context.func_195991_k(), (BlockPos)adPos, (PlayerEntity)context.func_195999_j());
                }
            }
            return ActionResultType.SUCCESS;
        }
        return super.useOn(context);
    }

    @Override
    public boolean isAcceptableElement(MagicElement element) {
        return element == MagicElementRegistry.HYDROMANCY;
    }
}

