/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.spells.spells;

import com.google.common.collect.Lists;
import com.paleimitations.schoolsofmagic.common.MagicElement;
import com.paleimitations.schoolsofmagic.common.MagicSchool;
import com.paleimitations.schoolsofmagic.common.registries.MagicElementRegistry;
import com.paleimitations.schoolsofmagic.common.registries.MagicSchoolRegistry;
import com.paleimitations.schoolsofmagic.common.registries.SoundRegistry;
import com.paleimitations.schoolsofmagic.common.spells.Spell;
import com.paleimitations.schoolsofmagic.common.spells.events.SpellEvent;
import com.paleimitations.schoolsofmagic.common.spells.modifiers.IHasAdjustableElements;
import com.paleimitations.schoolsofmagic.common.spells.modifiers.IHasDuration;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class InvisibilitySpell
extends Spell
implements IHasDuration,
IHasAdjustableElements {
    private int maxDuration = 400;
    private int duration = 0;

    public InvisibilitySpell() {
        super(new ResourceLocation("schoolsofmagic", "invisibility"), 2, 0, InvisibilitySpell.generateSchoolMap(new Map.Entry[0]), InvisibilitySpell.generateElementMap(new Map.Entry[0]), Lists.newArrayList((Object[])new MagicSchool[]{MagicSchoolRegistry.ILLUSION}), Lists.newArrayList((Object[])new MagicElement[]{MagicElementRegistry.UMBRAMANCY}), Lists.newArrayList());
    }

    public InvisibilitySpell(CompoundNBT nbt) {
        this.deserializeNBT(nbt);
    }

    @Override
    public ActionResult<ItemStack> use(World world, PlayerEntity player, Hand hand, ItemStack stack) {
        player.func_184598_c(hand);
        return ActionResult.func_226248_a_((Object)stack);
    }

    @Override
    public ActionResultType interactLivingEntity(ItemStack stack, PlayerEntity player, LivingEntity living, Hand hand) {
        if (this.castSpell(player) && !living.func_70644_a(Effects.field_76441_p)) {
            SpellEvent.Duration event = new SpellEvent.Duration(this);
            event.setMultiplier(1.0f + 0.5f * (float)(this.currentSpellChargeLevel - this.minSpellChargeLevel));
            MinecraftForge.EVENT_BUS.post((Event)event);
            living.func_195064_c(new EffectInstance(Effects.field_76441_p, Math.round(400.0f * event.getMultiplier())));
            player.func_184185_a(SoundRegistry.INVISIBILITY, 0.5f, player.func_70681_au().nextFloat() * 0.4f + 0.8f);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    public void inventoryTick(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        PlayerEntity player;
        if (entity instanceof PlayerEntity && (player = (PlayerEntity)entity).func_70644_a(Effects.field_76441_p)) {
            EffectInstance inst = player.func_70660_b(Effects.field_76441_p);
            this.duration = Math.min(inst.func_76459_b(), this.maxDuration);
        }
    }

    @Override
    public int getUseLength() {
        return 45;
    }

    @Override
    public void releaseUsing(ItemStack stack, World world, LivingEntity living, int count) {
        if (living instanceof PlayerEntity && this.castSpell((PlayerEntity)living) && !living.func_70644_a(Effects.field_76441_p)) {
            PlayerEntity player = (PlayerEntity)living;
            SpellEvent.Duration event = new SpellEvent.Duration(this);
            event.setMultiplier(1.0f + 0.5f * (float)(this.currentSpellChargeLevel - this.minSpellChargeLevel));
            MinecraftForge.EVENT_BUS.post((Event)event);
            this.duration = this.maxDuration = Math.round(400.0f * event.getMultiplier());
            player.func_195064_c(new EffectInstance(Effects.field_76441_p, this.maxDuration));
            player.func_184185_a(SoundRegistry.INVISIBILITY, 0.5f, player.func_70681_au().nextFloat() * 0.4f + 0.8f);
        }
    }

    @Override
    public int getDefaultDuration(int chargeLevel) {
        return this.maxDuration;
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = super.serializeNBT();
        nbt.func_74768_a("duration", this.duration);
        nbt.func_74768_a("maxDuration", this.maxDuration);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        this.maxDuration = nbt.func_74762_e("maxDuration");
        this.duration = nbt.func_74762_e("duration");
    }

    @Override
    public boolean isAcceptableElement(MagicElement element) {
        return element == MagicElementRegistry.HIEROMANCY;
    }
}

