/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.spells.spells;

import com.google.common.collect.Lists;
import com.paleimitations.schoolsofmagic.common.MagicElement;
import com.paleimitations.schoolsofmagic.common.MagicSchool;
import com.paleimitations.schoolsofmagic.common.data.Utils;
import com.paleimitations.schoolsofmagic.common.registries.MagicElementRegistry;
import com.paleimitations.schoolsofmagic.common.registries.MagicSchoolRegistry;
import com.paleimitations.schoolsofmagic.common.spells.Spell;
import com.paleimitations.schoolsofmagic.common.spells.events.SpellEvent;
import com.paleimitations.schoolsofmagic.common.spells.modifiers.IHasMultiUses;
import com.paleimitations.schoolsofmagic.common.spells.modifiers.IHasPower;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ShulkerBulletEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ShulkerBulletSpell
extends Spell
implements IHasPower,
IHasMultiUses {
    public ShulkerBulletSpell() {
        super(new ResourceLocation("schoolsofmagic", "shulker_bullet"), 1, 0, ShulkerBulletSpell.generateSchoolMap(new Map.Entry[0]), ShulkerBulletSpell.generateElementMap(new Map.Entry[0]), Lists.newArrayList((Object[])new MagicSchool[]{MagicSchoolRegistry.EVOCATION}), Lists.newArrayList((Object[])new MagicElement[]{MagicElementRegistry.CHAOTICS}), Lists.newArrayList());
    }

    public ShulkerBulletSpell(CompoundNBT nbt) {
        this.deserializeNBT(nbt);
    }

    @Override
    public ActionResult<ItemStack> use(World world, PlayerEntity player, Hand hand, ItemStack stack) {
        ItemStack itemstack = player.func_184586_b(hand);
        SpellEvent.Power event = new SpellEvent.Power(this);
        MinecraftForge.EVENT_BUS.post((Event)event);
        LivingEntity base = Utils.getEntityOnVec(world, player, 10.0f + 4.0f * event.getMultiplier());
        if (base != null && this.castSpell(player)) {
            ShulkerBulletEntity shulkerBullet = new ShulkerBulletEntity(world, (LivingEntity)player, (Entity)base, player.func_174811_aO().func_176740_k());
            if (!world.field_72995_K) {
                world.func_217376_c((Entity)shulkerBullet);
            }
            player.func_184185_a(SoundEvents.field_187789_eW, 1.0f, 1.0f);
            return ActionResult.func_226248_a_((Object)itemstack);
        }
        return ActionResult.func_226250_c_((Object)itemstack);
    }

    @Override
    public int getUsesPerCharge(int chargeLevel) {
        SpellEvent.UsesPerCharge event = new SpellEvent.UsesPerCharge(this, chargeLevel, 1 + (chargeLevel - this.minSpellChargeLevel) * 2);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getUses();
    }

    @Override
    public int getMaxUses(int chargeLevel) {
        return this.maxUses;
    }

    @Override
    public int getUses() {
        return this.remainingUses;
    }
}

