/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.spells.spells;

import com.google.common.collect.Lists;
import com.paleimitations.schoolsofmagic.common.MagicElement;
import com.paleimitations.schoolsofmagic.common.MagicSchool;
import com.paleimitations.schoolsofmagic.common.registries.MagicElementRegistry;
import com.paleimitations.schoolsofmagic.common.registries.MagicSchoolRegistry;
import com.paleimitations.schoolsofmagic.common.spells.Spell;
import com.paleimitations.schoolsofmagic.common.spells.events.SpellEvent;
import com.paleimitations.schoolsofmagic.common.spells.modifiers.IHasAdjustableElements;
import com.paleimitations.schoolsofmagic.common.spells.modifiers.IHasMultiUses;
import com.paleimitations.schoolsofmagic.common.spells.modifiers.IHasPower;
import java.util.Map;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ZephyrSpell
extends Spell
implements IHasMultiUses,
IHasPower,
IHasAdjustableElements {
    public ZephyrSpell() {
        super(new ResourceLocation("schoolsofmagic", "zephyr"), 1, 0, ZephyrSpell.generateSchoolMap(new Map.Entry[0]), ZephyrSpell.generateElementMap(new Map.Entry[0]), Lists.newArrayList((Object[])new MagicSchool[]{MagicSchoolRegistry.CONJURATION}), Lists.newArrayList((Object[])new MagicElement[]{MagicElementRegistry.AEROMANCY}), Lists.newArrayList());
    }

    public ZephyrSpell(CompoundNBT nbt) {
        this.deserializeNBT(nbt);
    }

    @Override
    public int getUsesPerCharge(int chargeLevel) {
        SpellEvent.UsesPerCharge event = new SpellEvent.UsesPerCharge(this, chargeLevel, 200 + (chargeLevel - this.minSpellChargeLevel) * 200);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getUses();
    }

    @Override
    public int getMaxUses(int chargeLevel) {
        return this.maxUses;
    }

    @Override
    public int getUses() {
        return this.remainingUses;
    }

    @Override
    public ActionResult<ItemStack> use(World world, PlayerEntity player, Hand hand, ItemStack stack) {
        player.func_184598_c(hand);
        return ActionResult.func_226248_a_((Object)stack);
    }

    @Override
    public int getUseLength() {
        return this.remainingUses == 0 ? this.maxUses : this.remainingUses;
    }

    @Override
    public void onUseTick(World world, LivingEntity living, ItemStack stack, int count) {
        if (living instanceof PlayerEntity && !living.func_204231_K() && this.castSpell((PlayerEntity)living)) {
            PlayerEntity player = (PlayerEntity)living;
            Vector3d vec = player.func_70040_Z();
            SpellEvent.Power event = new SpellEvent.Power(this);
            event.setMultiplier(1.0f + 0.05f * (float)this.currentSpellChargeLevel);
            MinecraftForge.EVENT_BUS.post((Event)event);
            double vX = vec.field_72450_a * 0.75 * (double)event.getMultiplier();
            double vY = vec.field_72448_b * 0.75 * (double)event.getMultiplier();
            double vZ = vec.field_72449_c * 0.75 * (double)event.getMultiplier();
            player.func_213293_j(vX, vY, vZ);
            if (vY > 0.45) {
                player.field_70143_R = 0.0f;
            }
        }
    }

    @Override
    public boolean isAcceptableElement(MagicElement element) {
        return element == MagicElementRegistry.HIEROMANCY;
    }
}

