/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.tileentities;

import com.paleimitations.schoolsofmagic.common.containers.MortarContainer;
import com.paleimitations.schoolsofmagic.common.crafting.MortarRecipe;
import com.paleimitations.schoolsofmagic.common.network.ClientTileEntityPacket;
import com.paleimitations.schoolsofmagic.common.network.PacketHandler;
import com.paleimitations.schoolsofmagic.common.registries.RecipeRegistry;
import com.paleimitations.schoolsofmagic.common.registries.TileEntityRegistry;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;

public class MortarTileEntity
extends LockableTileEntity
implements ITickableTileEntity {
    private NonNullList<ItemStack> items = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    private MortarRecipe recipe;
    private int crush = 0;
    private int maxCrush = 0;
    public final IIntArray dataAccess = new IIntArray(){

        public int func_221476_a(int id) {
            switch (id) {
                case 0: {
                    return MortarTileEntity.this.crush;
                }
                case 1: {
                    return MortarTileEntity.this.maxCrush;
                }
            }
            return 0;
        }

        public void func_221477_a(int id, int value) {
            switch (id) {
                case 0: {
                    MortarTileEntity.this.crush = value;
                    break;
                }
                case 1: {
                    MortarTileEntity.this.maxCrush = value;
                }
            }
            MortarTileEntity.this.sendServerUpdate();
        }

        public int func_221478_a() {
            return 2;
        }
    };

    public MortarTileEntity() {
        super((TileEntityType)TileEntityRegistry.MORTAR_TILE_ENTITY.get());
    }

    private void sendServerUpdate() {
        if (this.func_145831_w().field_72995_K) {
            PacketHandler.INSTANCE.sendToServer(new ClientTileEntityPacket(this.field_174879_c, this.func_189515_b(new CompoundNBT())));
        }
    }

    public MortarRecipe getRecipe() {
        IRecipe irecipe = this.field_145850_b.func_199532_z().func_215371_a(RecipeRegistry.MORTAR_TYPE, (IInventory)this, this.field_145850_b).orElse(null);
        return irecipe instanceof MortarRecipe ? (MortarRecipe)irecipe : null;
    }

    public boolean hasRecipe() {
        return this.getRecipe() != null;
    }

    public int getCrush() {
        return this.crush;
    }

    public void setCrush(int crush) {
        this.crush = crush;
    }

    public void func_73660_a() {
        if (this.recipe != this.getRecipe()) {
            this.recipe = this.getRecipe();
            this.crush = 0;
            this.maxCrush = this.recipe != null ? this.recipe.getCrush() : 0;
            this.func_70296_d();
        }
        if (this.crush >= this.maxCrush && this.recipe != null) {
            this.crush = 0;
            this.func_70299_a(0, this.recipe.func_77572_b((IInventory)this));
            this.func_70299_a(1, this.recipe.assembleSecondary((IInventory)this));
            this.func_70296_d();
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.items);
        this.crush = nbt.func_74762_e("crush");
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        ItemStackHelper.func_191282_a((CompoundNBT)nbt, this.items);
        nbt.func_74768_a("crush", this.crush);
        return nbt;
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        return slot >= 0 && slot < this.items.size() ? (ItemStack)this.items.get(slot) : ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int slot, int count) {
        return ItemStackHelper.func_188382_a(this.items, (int)slot, (int)count);
    }

    public ItemStack func_70304_b(int slot) {
        return ItemStackHelper.func_188383_a(this.items, (int)slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (slot >= 0 && slot < this.items.size()) {
            this.items.set(slot, (Object)stack);
        }
    }

    public void func_70296_d() {
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
            this.func_145836_u();
            this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
            if (!this.func_195044_w().isAir((IBlockReader)this.field_145850_b, this.field_174879_c)) {
                this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
            }
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return !(player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) > 64.0);
    }

    public void func_174888_l() {
        this.items.clear();
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.schoolsofmagic.mortar");
    }

    protected Container func_213906_a(int containerID, PlayerInventory playerInv) {
        return new MortarContainer(containerID, playerInv, (IInventory)this, this.dataAccess);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 13, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT tag = pkt.func_148857_g();
        this.func_230337_a_(this.func_195044_w(), tag);
    }
}

