/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.tileentities;

import com.paleimitations.schoolsofmagic.common.blocks.PodiumBlock;
import com.paleimitations.schoolsofmagic.common.data.Utils;
import com.paleimitations.schoolsofmagic.common.data.capabilities.book_data.BookData;
import com.paleimitations.schoolsofmagic.common.data.capabilities.book_data.BookDataProvider;
import com.paleimitations.schoolsofmagic.common.items.BookBaseItem;
import com.paleimitations.schoolsofmagic.common.registries.SoundRegistry;
import com.paleimitations.schoolsofmagic.common.registries.TileEntityRegistry;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.IBlockReader;

public class PodiumTileEntity
extends TileEntity
implements IInventory,
ITickableTileEntity {
    private ItemStack item = ItemStack.field_190927_a;
    public BookState bookState = BookState.CLOSED;
    public int prevPage;
    public int prevSubPage;
    public int animationTick;

    public PodiumTileEntity() {
        super((TileEntityType)TileEntityRegistry.PODIUM_TILE_ENTITY.get());
    }

    public void func_70296_d() {
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
            this.func_145836_u();
            this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
            if (!this.func_195044_w().isAir((IBlockReader)this.field_145850_b, this.field_174879_c)) {
                this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
            }
        }
    }

    public int func_70302_i_() {
        return 1;
    }

    public boolean func_191420_l() {
        return this.item.func_190926_b();
    }

    public ItemStack func_70301_a(int slot) {
        return slot == 0 ? this.item : ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int slot, int count) {
        if (slot == 0) {
            this.func_70296_d();
            return this.item.func_77979_a(count);
        }
        return ItemStack.field_190927_a;
    }

    public void update() {
        if (this.hasBook() && BookDataProvider.getBook(this.field_145850_b, this.item) != null) {
            int subpage;
            BookData data = BookDataProvider.getBook(this.field_145850_b, this.item);
            CompoundNBT nbt = this.item.func_196082_o();
            int page = nbt.func_74764_b("page") ? nbt.func_74762_e("page") : 0;
            int n = subpage = nbt.func_74764_b("subpage") ? nbt.func_74762_e("subpage") : 0;
            if (!nbt.func_74764_b("page") || !nbt.func_74764_b("subpage")) {
                nbt.func_74768_a("page", page);
                nbt.func_74768_a("subpage", page);
                this.item.func_77982_d(nbt);
            }
            if (this.bookState.getAnimationLength() > 0) {
                ++this.animationTick;
                if (this.animationTick >= this.bookState.getAnimationLength()) {
                    this.animationTick = 0;
                    if (this.bookState == BookState.CLOSE_BOOK) {
                        this.bookState = BookState.CLOSED;
                    } else {
                        if (this.bookState != BookState.OPEN_BOOK) {
                            this.prevPage = page;
                            this.prevSubPage = subpage;
                        }
                        this.bookState = BookState.OPEN;
                    }
                }
            }
            float xD = 0.5f;
            float zD = 0.5f;
            Direction facing = (Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)PodiumBlock.HORIZONTAL_FACING);
            if (facing == Direction.NORTH) {
                float facingAngle = 0.0f;
                xD = 1.0f;
            } else if (facing == Direction.SOUTH) {
                float facingAngle = 180.0f;
                xD = 0.0f;
            } else if (facing == Direction.EAST) {
                float facingAngle = -90.0f;
                zD = 1.0f;
            } else {
                float facingAngle = 90.0f;
                zD = 0.0f;
            }
            PlayerEntity player = this.field_145850_b.func_217366_a((double)((float)this.field_174879_c.func_177958_n() + xD), (double)this.field_174879_c.func_177956_o(), (double)((float)this.field_174879_c.func_177952_p() + zD), 30.0, false);
            if (!(this.bookState != BookState.OPEN || player != null && this.shouldBeOpen(player, (float)this.field_174879_c.func_177958_n() + xD, this.field_174879_c.func_177956_o(), (float)this.field_174879_c.func_177952_p() + zD))) {
                this.bookState = BookState.CLOSE_BOOK;
                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundRegistry.BOOK_CLOSE, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.animationTick = 0;
            }
            if (this.bookState == BookState.CLOSED && player != null && this.shouldBeOpen(player, (float)this.field_174879_c.func_177958_n() + xD, this.field_174879_c.func_177956_o(), (float)this.field_174879_c.func_177952_p() + zD)) {
                this.bookState = BookState.OPEN_BOOK;
                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundRegistry.BOOK_OPEN, SoundCategory.BLOCKS, 0.8f, 1.0f);
                this.animationTick = 0;
            }
            if (this.bookState == BookState.OPEN && (this.prevPage < page || this.prevSubPage < subpage && this.prevPage == page)) {
                this.bookState = BookState.TURN_PAGE_FORWARD;
                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundRegistry.PAGE_FLIP, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.animationTick = 0;
            } else if (this.bookState == BookState.OPEN && (this.prevPage > page || this.prevSubPage > subpage && this.prevPage == page)) {
                this.bookState = BookState.TURN_PAGE_BACK;
                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundRegistry.PAGE_FLIP, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.animationTick = 0;
            }
        }
    }

    private boolean shouldBeOpen(PlayerEntity player, double x, double y, double z) {
        return Utils.getDistanceDouble(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), x, y, z) < 5.0;
    }

    public ItemStack func_70304_b(int slot) {
        if (slot == 0) {
            ItemStack itemstack = this.item;
            this.item = ItemStack.field_190927_a;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (slot == 0) {
            this.item = stack;
            this.func_70296_d();
        }
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) > 64.0 ? false : !this.getItem().func_190926_b();
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot == 0 && this.getItem().func_190926_b();
    }

    public ItemStack getItem() {
        return this.item;
    }

    public boolean hasBook() {
        Item item = this.item.func_77973_b();
        return item instanceof BookBaseItem;
    }

    public void setItem(ItemStack stack) {
        this.item = stack;
        this.func_70296_d();
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.item = nbt.func_150297_b("Item", 10) ? ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("Item")) : ItemStack.field_190927_a;
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        if (!this.getItem().func_190926_b()) {
            nbt.func_218657_a("Item", (INBT)this.getItem().func_77955_b(new CompoundNBT()));
        }
        return nbt;
    }

    public void func_174888_l() {
        this.setItem(ItemStack.field_190927_a);
        this.func_70296_d();
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 13, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT tag = pkt.func_148857_g();
        this.func_230337_a_(this.func_195044_w(), tag);
    }

    public void func_73660_a() {
        this.update();
    }

    public static enum BookState {
        OPEN_BOOK(30),
        OPEN(0),
        TURN_PAGE_FORWARD(12),
        TURN_PAGE_BACK(12),
        CLOSE_BOOK(30),
        CLOSED(0);

        private final int animationLength;

        private BookState(int animationLength) {
            this.animationLength = animationLength;
        }

        public int getAnimationLength() {
            return this.animationLength;
        }
    }
}

