/*
 * Decompiled with CFR 0.152.
 */
package com.paleimitations.schoolsofmagic.common.tileentities;

import com.paleimitations.schoolsofmagic.common.TeaBrewResult;
import com.paleimitations.schoolsofmagic.common.containers.TeapotContainer;
import com.paleimitations.schoolsofmagic.common.data.TeaUtils;
import com.paleimitations.schoolsofmagic.common.network.ClientTileEntityPacket;
import com.paleimitations.schoolsofmagic.common.network.PacketHandler;
import com.paleimitations.schoolsofmagic.common.registries.ItemRegistry;
import com.paleimitations.schoolsofmagic.common.registries.TeaIngredientRegistry;
import com.paleimitations.schoolsofmagic.common.registries.TileEntityRegistry;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.AbstractFurnaceBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.MagmaBlock;
import net.minecraft.block.TorchBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BucketItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MilkBucketItem;
import net.minecraft.item.PotionItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.Tags;

public class TeapotTileEntity
extends LockableTileEntity
implements ITickableTileEntity {
    private NonNullList<ItemStack> items = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    private LiquidType liquidType = LiquidType.EMPTY;
    private int liquidLevel = 3;
    private TeaBrewResult brew = null;
    private int countdown = 100;
    public final IIntArray dataAccess = new IIntArray(){

        public int func_221476_a(int id) {
            switch (id) {
                case 0: {
                    return TeapotTileEntity.this.heated() ? 1 : 0;
                }
                case 1: {
                    return TeapotTileEntity.this.liquidLevel;
                }
                case 2: {
                    if (TeapotTileEntity.this.brew != null) {
                        return TeapotTileEntity.this.brew.getColor();
                    }
                    return TeapotTileEntity.this.liquidType == LiquidType.WATER ? 6854629 : Color.WHITE.getRGB();
                }
                case 3: {
                    return TeapotTileEntity.this.countdown;
                }
            }
            return 0;
        }

        public void func_221477_a(int id, int value) {
        }

        public int func_221478_a() {
            return 4;
        }
    };

    public TeapotTileEntity() {
        super((TileEntityType)TileEntityRegistry.TEAPOT_TILE_ENTITY.get());
    }

    private void sendServerUpdate() {
        if (this.func_145831_w().field_72995_K) {
            PacketHandler.INSTANCE.sendToServer(new ClientTileEntityPacket(this.field_174879_c, this.func_189515_b(new CompoundNBT())));
        }
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.schoolsofmagic.teapot");
    }

    protected Container func_213906_a(int containerID, PlayerInventory playerInv) {
        return new TeapotContainer(containerID, playerInv, (IInventory)this, this.dataAccess);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        if (nbt.func_74764_b("brew")) {
            this.brew = new TeaBrewResult(nbt.func_74775_l("brew"));
        }
        this.liquidType = LiquidType.values()[nbt.func_74762_e("liquidType")];
        this.liquidLevel = nbt.func_74762_e("liquidLevel");
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.items);
        super.func_230337_a_(state, nbt);
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        ItemStackHelper.func_191282_a((CompoundNBT)nbt, this.items);
        if (this.brew != null) {
            nbt.func_218657_a("brew", (INBT)this.brew.serialize());
        }
        nbt.func_74768_a("liquidLevel", this.liquidLevel);
        nbt.func_74768_a("liquidType", this.liquidType.ordinal());
        return nbt;
    }

    public int func_70302_i_() {
        return 5;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        return slot >= 0 && slot < this.items.size() ? (ItemStack)this.items.get(slot) : ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int slot, int count) {
        return ItemStackHelper.func_188382_a(this.items, (int)slot, (int)count);
    }

    public ItemStack func_70304_b(int slot) {
        return ItemStackHelper.func_188383_a(this.items, (int)slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (slot >= 0 && slot < this.items.size()) {
            this.items.set(slot, (Object)stack);
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return !(player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) > 64.0);
    }

    public void func_174888_l() {
        this.items.clear();
    }

    public void func_73660_a() {
        ItemStack input = (ItemStack)this.items.get(3);
        ItemStack output = (ItemStack)this.items.get(4);
        if (this.liquidType == LiquidType.EMPTY || this.liquidType == LiquidType.WATER) {
            if (this.liquidLevel == 0 && input.func_77973_b() instanceof BucketItem && ((BucketItem)input.func_77973_b()).getFluid() == Fluids.field_204546_a) {
                boolean proceed;
                boolean bl = proceed = !input.hasContainerItem();
                if (input.hasContainerItem()) {
                    ItemStack containerItem = input.getContainerItem();
                    if (output.func_190926_b()) {
                        proceed = true;
                        this.func_70299_a(4, containerItem);
                    } else if (this.equals(output, containerItem, false) && output.func_190916_E() < output.func_77973_b().func_77639_j()) {
                        proceed = true;
                        output.func_190917_f(1);
                    }
                }
                if (proceed) {
                    input.func_190918_g(1);
                    this.liquidLevel = 3;
                    this.liquidType = LiquidType.WATER;
                    this.func_70296_d();
                }
            } else if (this.liquidLevel == 0 && (input.func_77973_b() instanceof BucketItem && Tags.Fluids.MILK.func_230235_a_((Object)((BucketItem)input.func_77973_b()).getFluid()) || input.func_77973_b() instanceof MilkBucketItem)) {
                boolean proceed;
                boolean bl = proceed = !input.hasContainerItem();
                if (input.hasContainerItem()) {
                    ItemStack containerItem = input.getContainerItem();
                    if (output.func_190926_b()) {
                        this.func_70299_a(4, containerItem);
                        proceed = true;
                    } else if (this.equals(output, containerItem, false) && output.func_190916_E() < output.func_77973_b().func_77639_j()) {
                        output.func_190917_f(1);
                        proceed = true;
                    }
                }
                if (proceed) {
                    input.func_190918_g(1);
                    this.liquidLevel = 3;
                    this.liquidType = LiquidType.MILK;
                    this.func_70296_d();
                }
            } else if (this.liquidLevel < 3 && input.func_77973_b() instanceof PotionItem && PotionUtils.func_185191_c((ItemStack)input) == Potions.field_185230_b) {
                boolean proceed = false;
                ItemStack containerItem = new ItemStack((IItemProvider)Items.field_151069_bo);
                if (output.func_190926_b()) {
                    this.func_70299_a(4, containerItem);
                    proceed = true;
                } else if (this.equals(output, containerItem, false) && output.func_190916_E() < output.func_77973_b().func_77639_j()) {
                    output.func_190917_f(1);
                    proceed = true;
                }
                if (proceed) {
                    input.func_190918_g(1);
                    ++this.liquidLevel;
                    this.liquidType = LiquidType.WATER;
                    this.func_70296_d();
                }
            }
        } else if (this.liquidType == LiquidType.TEA && this.liquidLevel > 0 && this.brew != null && ItemRegistry.TEACUP_ENTRIES.containsKey(input.func_77973_b())) {
            ItemStack newTea = new ItemStack((IItemProvider)ItemRegistry.TEACUP_ENTRIES.get(input.func_77973_b()));
            TeaUtils.setTea(newTea, this.brew);
            boolean proceed = false;
            if (output.func_190926_b()) {
                this.func_70299_a(4, newTea);
                proceed = true;
            } else if (this.equals(output, newTea, false) && output.func_190916_E() < output.func_77973_b().func_77639_j()) {
                output.func_190917_f(1);
                proceed = true;
            }
            if (proceed) {
                input.func_190918_g(1);
                --this.liquidLevel;
                this.func_70296_d();
            }
        }
        if (this.heated() && (this.liquidType == LiquidType.MILK || this.liquidType == LiquidType.WATER) && this.liquidLevel > 0) {
            TeaIngredientRegistry.TeaIngredient ingred1 = TeaIngredientRegistry.getIngredient((ItemStack)this.items.get(0));
            TeaIngredientRegistry.TeaIngredient ingred2 = TeaIngredientRegistry.getIngredient((ItemStack)this.items.get(1));
            TeaIngredientRegistry.TeaIngredient ingred3 = TeaIngredientRegistry.getIngredient((ItemStack)this.items.get(2));
            TeaBrewResult test = new TeaBrewResult(ingred1 != null ? ingred1.tea : null, ingred2 != null ? ingred2.tea : null, ingred3 != null ? ingred3.tea : null, this.liquidType == LiquidType.MILK);
            if (test.successful) {
                --this.countdown;
                if (this.countdown == 0) {
                    this.liquidType = LiquidType.TEA;
                    this.brew = test;
                    this.items.set(0, (Object)ItemStack.field_190927_a);
                    this.items.set(1, (Object)ItemStack.field_190927_a);
                    this.items.set(2, (Object)ItemStack.field_190927_a);
                    this.func_70296_d();
                }
            } else {
                this.countdown = 100;
            }
        } else {
            this.countdown = 100;
        }
        if (this.liquidLevel == 0) {
            this.liquidType = LiquidType.EMPTY;
            this.brew = null;
            this.func_70296_d();
        }
    }

    public void func_70296_d() {
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
            this.func_145836_u();
            this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
            if (!this.func_195044_w().isAir((IBlockReader)this.field_145850_b, this.field_174879_c)) {
                this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
            }
        }
    }

    public boolean equals(ItemStack stack, ItemStack other, boolean limitTags) {
        if (stack.func_190926_b()) {
            return other.func_190926_b();
        }
        return !other.func_190926_b() && stack.func_77973_b() == other.func_77973_b() && (limitTags ? stack.areShareTagsEqual(other) : ItemStack.func_77970_a((ItemStack)stack, (ItemStack)other));
    }

    public boolean heated() {
        return this.isHeatSource(this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(1))) || this.isHeatSource(this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(2)));
    }

    public boolean isHeatSource(BlockState state) {
        return state.func_177230_c() instanceof AbstractFurnaceBlock && (Boolean)state.func_177229_b((Property)AbstractFurnaceBlock.field_220091_b) != false || state.func_177230_c() instanceof CampfireBlock && (Boolean)state.func_177229_b((Property)CampfireBlock.field_220101_b) != false || state.func_177230_c() instanceof AbstractFireBlock || state.func_177230_c() instanceof TorchBlock || state.func_177230_c() instanceof MagmaBlock || state.func_185904_a() == Material.field_151587_i;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 13, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT tag = pkt.func_148857_g();
        this.func_230337_a_(this.func_195044_w(), tag);
    }

    static enum LiquidType {
        EMPTY,
        WATER,
        MILK,
        TEA;

    }
}

