/*
 * Decompiled with CFR 0.152.
 */
package me.lizardofoz.searchlight.block;

import me.lizardofoz.searchlight.SearchlightMod;
import me.lizardofoz.searchlight.block.SearchlightLightSourceBlock;
import me.lizardofoz.searchlight.util.MutableVector3d;
import me.lizardofoz.searchlight.util.MutableVector3i;
import me.lizardofoz.searchlight.util.SearchlightUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2802;
import net.minecraft.class_3558;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchlightBlockEntity
extends class_2586 {
    @Nullable
    private class_2338 lightSourcePos;

    public SearchlightBlockEntity() {
        super(SearchlightMod.getSearchlightBlockEntityType());
    }

    public class_2487 method_11007(class_2487 tag) {
        super.method_11007(tag);
        if (this.lightSourcePos != null) {
            tag.method_10569("light_source_x", this.lightSourcePos.method_10263());
            tag.method_10569("light_source_y", this.lightSourcePos.method_10264());
            tag.method_10569("light_source_z", this.lightSourcePos.method_10260());
        }
        return tag;
    }

    public class_2487 toClientTag(@NotNull class_2487 tag) {
        return this.method_11007(tag);
    }

    public void method_11014(class_2680 state, class_2487 tag) {
        super.method_11014(state, tag);
        this.fromClientTag(tag);
    }

    public void fromClientTag(@NotNull class_2487 tag) {
        this.lightSourcePos = tag.method_10545("light_source_x") && tag.method_10545("light_source_y") && tag.method_10545("light_source_z") ? new class_2338(tag.method_10550("light_source_x"), tag.method_10550("light_source_y"), tag.method_10550("light_source_z")) : null;
    }

    public class_2487 method_16887() {
        return this.method_11007(super.method_16887());
    }

    @Environment(value=EnvType.CLIENT)
    public double method_11006() {
        return SearchlightUtil.displayBeams() ? 256.0 : super.method_11006();
    }

    @NotNull
    public class_243 getBeamDirection() {
        if (this.lightSourcePos == null) {
            return SearchlightUtil.directionToBeamVector(SearchlightUtil.getDirection(this.method_11010()));
        }
        class_2338 delta = this.lightSourcePos.method_10059((class_2382)this.method_11016());
        return new class_243((double)delta.method_10263(), (double)delta.method_10264(), (double)delta.method_10260()).method_1029();
    }

    public boolean deleteLightSource() {
        class_2338 oldLightSourcePos = this.lightSourcePos;
        this.setLightSourcePos(null);
        if (oldLightSourcePos != null && SearchlightUtil.getBlockStateForceLoad(this.field_11863, oldLightSourcePos).method_26204() instanceof SearchlightLightSourceBlock) {
            return SearchlightUtil.setBlockStateForceLoad(this.field_11863, oldLightSourcePos, class_2246.field_10124.method_9564());
        }
        return false;
    }

    public boolean raycastAndPlaceLightSource(@NotNull class_243 beamDirection) {
        class_2338 newLightPos = this.calculateLightSourcePosition(beamDirection = beamDirection.method_1029());
        return newLightPos != null && this.placeLightSource(newLightPos);
    }

    public boolean placeLightSource(@Nullable class_2338 newLightPos) {
        this.deleteLightSource();
        if (newLightPos == null) {
            this.setLightSourcePos(null);
            return false;
        }
        class_2680 oldBlockState = SearchlightUtil.getBlockStateForceLoad(this.field_11863, newLightPos);
        if (!SearchlightUtil.setBlockStateForceLoad(this.field_11863, newLightPos, SearchlightMod.getLightSourceBlock().method_9564())) {
            return false;
        }
        if (!SearchlightUtil.castBlockEntity(this.field_11863.method_8321(newLightPos), newLightPos, lightBlockEntity -> {
            lightBlockEntity.searchlightBlockPos = this.method_11016();
            this.setLightSourcePos(newLightPos);
        })) {
            SearchlightUtil.setBlockStateForceLoad(this.field_11863, newLightPos, oldBlockState);
            this.setLightSourcePos(null);
            return false;
        }
        return true;
    }

    @Nullable
    public class_2338 calculateLightSourcePosition(@NotNull class_243 beamDirection) {
        beamDirection = beamDirection.method_1029();
        class_2802 chunkManager = this.field_11863.method_8398();
        MutableVector3d currentPosVecD = new MutableVector3d((double)this.method_11016().method_10263() + 0.5, (double)this.method_11016().method_10264() + 0.5, (double)this.method_11016().method_10260() + 0.5);
        MutableVector3i currentPosVecI = new MutableVector3i(currentPosVecD.x, currentPosVecD.y, currentPosVecD.z);
        MutableVector3i prevPosVecI = new MutableVector3i(0, 0, 0);
        MutableVector3i currentChunkVec = new MutableVector3i(0, 0, 0);
        MutableVector3i prevChunkVec = new MutableVector3i(0, 0, 0);
        class_2338 lastValidBlockPos = null;
        while (true) {
            prevPosVecI.set(currentPosVecI);
            currentPosVecD.add(beamDirection);
            currentPosVecI.set(currentPosVecD);
            if (prevPosVecI.areSame(currentPosVecI)) continue;
            if (class_1937.method_8476((int)currentPosVecI.y)) {
                return null;
            }
            prevChunkVec.set(prevPosVecI.x >> 4, 0, prevPosVecI.z >> 4);
            currentChunkVec.set(currentPosVecI.x >> 4, 0, currentPosVecI.z >> 4);
            if (!prevChunkVec.areSame(currentChunkVec) && !chunkManager.method_12123(currentPosVecI.x >> 4, currentPosVecI.z >> 4)) {
                return null;
            }
            class_2338 currentBlockPos = new class_2338(currentPosVecI.x, currentPosVecI.y, currentPosVecI.z);
            class_2338 prevBlockPos = new class_2338(prevPosVecI.x, prevPosVecI.y, prevPosVecI.z);
            class_2680 currentBlockState = SearchlightUtil.getBlockStateForceLoad(this.field_11863, currentBlockPos);
            class_2680 prevBlockState = SearchlightUtil.getBlockStateForceLoad(this.field_11863, prevBlockPos);
            if (class_3558.method_20049((class_1922)this.field_11863, (class_2680)prevBlockState, (class_2338)prevBlockPos, (class_2680)currentBlockState, (class_2338)currentBlockPos, (class_2350)class_2350.method_10142((double)beamDirection.field_1352, (double)beamDirection.field_1351, (double)beamDirection.field_1350), (int)currentBlockState.method_26193((class_1922)this.field_11863, currentBlockPos)) >= this.field_11863.method_8315() || !this.field_11863.method_8316(currentBlockPos).method_15769()) {
                return SearchlightUtil.moveAwayFromSurfaces(this.field_11863, lastValidBlockPos);
            }
            if (!currentBlockState.method_26215() && !currentBlockPos.equals((Object)this.lightSourcePos)) continue;
            lastValidBlockPos = currentBlockPos;
        }
    }

    protected void setLightSourcePos(@Nullable class_2338 lightSourcePos) {
        this.lightSourcePos = lightSourcePos;
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            SearchlightMod.getBlockEntitySynchronizer().accept(this);
        }
    }

    @Nullable
    public class_2338 getLightSourcePos() {
        return this.lightSourcePos;
    }
}

