/*
 * Decompiled with CFR 0.152.
 */
package me.lizardofoz.searchlight.block;

import me.lizardofoz.searchlight.block.SearchlightBlockEntity;
import me.lizardofoz.searchlight.util.SearchlightUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1059;
import net.minecraft.class_1160;
import net.minecraft.class_1921;
import net.minecraft.class_2341;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2738;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4730;
import net.minecraft.class_630;
import net.minecraft.class_765;
import net.minecraft.class_822;
import net.minecraft.class_824;
import net.minecraft.class_827;

@Environment(value=EnvType.CLIENT)
public class SearchlightBlockRenderer
extends class_827<SearchlightBlockEntity> {
    protected static final class_4730 SEARCHLIGHT_BODY_TEXTURE = new class_4730(class_1059.field_5275, new class_2960("searchlight", "block/searchlight"));
    protected static final class_2960 SEARCHLIGHT_BEAM = new class_2960("searchlight", "textures/block/searchlight_beam.png");
    protected static final int MAX_LIGHT = class_765.method_23687((int)15, (int)15);
    protected static final int MAX_OVERLAY = class_4608.method_23625((int)15, (int)15);
    protected static final class_1160 CEILING_PIVOT = new class_1160(8.0f, 10.0f, 8.0f);
    protected static final class_1160 FLOOR_PIVOT = new class_1160(8.0f, 6.0f, 8.0f);
    protected static final class_1160 NORTH_PIVOT = new class_1160(8.0f, 8.0f, 12.0f);
    protected static final class_1160 SOUTH_PIVOT = new class_1160(8.0f, 8.0f, 4.0f);
    protected static final class_1160 WEST_PIVOT = new class_1160(12.0f, 8.0f, 8.0f);
    protected static final class_1160 EAST_PIVOT = new class_1160(4.0f, 8.0f, 8.0f);
    protected final class_630 onWallBody = new class_630(32, 32, 0, 0);
    protected final class_630 onWallLightFace = new class_630(32, 32, 0, 23);
    protected final class_630 onFloorBody = new class_630(32, 32, 0, 0);
    protected final class_630 ofFloorLightFace = new class_630(32, 32, 0, 23);

    public SearchlightBlockRenderer(class_824 dispatcher) {
        super(dispatcher);
        this.onWallBody.method_2844(-3.0f, -6.0f, -3.0f, 6.0f, 7.0f, 6.0f);
        class_630 wallFrontPart = new class_630(32, 32, 0, 13);
        wallFrontPart.method_2844(4.0f, 4.0f, 4.0f, 8.0f, 2.0f, 8.0f);
        wallFrontPart.method_2851(-8.0f, -12.0f, -8.0f);
        this.onWallBody.method_2845(wallFrontPart);
        this.onWallLightFace.method_2844(-4.0f, -8.0f, -4.0f, 8.0f, 1.0f, 8.0f);
        this.onFloorBody.method_2844(-3.0f, -4.0f, -3.0f, 6.0f, 7.0f, 6.0f);
        class_630 floorFrontPart = new class_630(32, 32, 0, 13);
        floorFrontPart.method_2844(4.0f, 4.0f, 4.0f, 8.0f, 2.0f, 8.0f);
        floorFrontPart.method_2851(-8.0f, -10.0f, -8.0f);
        this.onFloorBody.method_2845(floorFrontPart);
        this.ofFloorLightFace.method_2844(-4.0f, -6.0f, -4.0f, 8.0f, 1.0f, 8.0f);
    }

    public boolean rendersOutsideBoundingBox(SearchlightBlockEntity beaconBlockEntity) {
        return true;
    }

    public void render(SearchlightBlockEntity blockEntity, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, int overlay) {
        class_1160 pivot = this.getModelPivot(blockEntity);
        class_243 direction = blockEntity.getBeamDirection();
        class_4588 vertexConsumer = SEARCHLIGHT_BODY_TEXTURE.method_24145(vertexConsumerProvider, class_1921::method_23578);
        boolean isOnWall = blockEntity.method_11010().method_11654((class_2769)class_2341.field_11007) == class_2738.field_12471;
        class_630 body = isOnWall ? this.onWallBody : this.onFloorBody;
        class_630 lightFace = isOnWall ? this.onWallLightFace : this.ofFloorLightFace;
        body.method_2851(pivot.method_4943(), pivot.method_4945(), pivot.method_4947());
        body.field_3675 = (float)class_3532.method_15349((double)direction.field_1352, (double)direction.field_1350);
        body.field_3654 = (float)(class_3532.method_15349((double)Math.sqrt(direction.field_1350 * direction.field_1350 + direction.field_1352 * direction.field_1352), (double)direction.field_1351) + Math.PI);
        body.method_22698(matrixStack, vertexConsumer, light, overlay);
        lightFace.method_2851(pivot.method_4943(), pivot.method_4945(), pivot.method_4947());
        lightFace.field_3675 = body.field_3675;
        lightFace.field_3654 = body.field_3654;
        lightFace.method_22698(matrixStack, vertexConsumer, MAX_LIGHT, MAX_OVERLAY);
        if (SearchlightUtil.displayBeams() && blockEntity.getLightSourcePos() != null) {
            int distance = (int)Math.sqrt(blockEntity.getLightSourcePos().method_10262((class_2382)blockEntity.method_11016())) + 1;
            this.drawBeam(pivot, body.field_3675, body.field_3654, distance, matrixStack, vertexConsumerProvider);
        }
    }

    protected void drawBeam(class_1160 pivot, float yaw, float pitch, int distance, class_4587 matrixStack, class_4597 vertexConsumerProvider) {
        matrixStack.method_22903();
        matrixStack.method_22904((double)(pivot.method_4943() / 16.0f), (double)(pivot.method_4945() / 16.0f), (double)(pivot.method_4947() / 16.0f));
        matrixStack.method_22907(class_1160.field_20705.method_23626(yaw));
        matrixStack.method_22907(class_1160.field_20703.method_23626((float)(Math.PI + (double)pitch)));
        matrixStack.method_22904(-0.5, 0.35, -0.5);
        class_822.method_3545((class_4587)matrixStack, (class_4597)vertexConsumerProvider, (class_2960)SEARCHLIGHT_BEAM, (float)0.0f, (float)1.0f, (long)0L, (int)0, (int)distance, (float[])new float[]{1.0f, 1.0f, 1.0f}, (float)0.0f, (float)0.25f);
        matrixStack.method_22909();
    }

    protected class_1160 getModelPivot(SearchlightBlockEntity blockEntity) {
        class_2350 direction = SearchlightUtil.getDirection(blockEntity.method_11010());
        if (direction == class_2350.field_11036) {
            return FLOOR_PIVOT;
        }
        if (direction == class_2350.field_11033) {
            return CEILING_PIVOT;
        }
        if (direction == class_2350.field_11034) {
            return EAST_PIVOT;
        }
        if (direction == class_2350.field_11039) {
            return WEST_PIVOT;
        }
        if (direction == class_2350.field_11035) {
            return SOUTH_PIVOT;
        }
        return NORTH_PIVOT;
    }
}

