/*
 * Decompiled with CFR 0.152.
 */
package me.lizardofoz.searchlight.util;

import java.util.function.Consumer;
import me.lizardofoz.searchlight.SearchlightMod;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2341;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SearchlightUtil {
    private SearchlightUtil() {
    }

    public static <T extends class_2586> boolean castBlockEntity(@Nullable class_2586 blockEntity, @NotNull class_2338 blockPos, @NotNull Consumer<T> result) {
        if (blockEntity == null) {
            try {
                throw new IllegalStateException();
            }
            catch (Exception e) {
                SearchlightMod.LOGGER.error("Attempted to cast a null blockEntity at " + blockPos, (Throwable)e);
                return false;
            }
        }
        if (!blockEntity.method_11002()) {
            try {
                throw new IllegalStateException();
            }
            catch (Exception e) {
                SearchlightMod.LOGGER.error(String.format("Attempted to use a blockEntity '%s' (%s) at %s with world==null.", blockEntity.method_11007(new class_2487()), blockEntity.getClass(), blockPos), (Throwable)e);
                return false;
            }
        }
        try {
            result.accept(blockEntity);
            return true;
        }
        catch (ClassCastException ex) {
            SearchlightMod.LOGGER.error(String.format("Attempted to cast '%s' (%s) at %s but failed", blockEntity.method_11007(new class_2487()), blockEntity.getClass(), blockPos), (Throwable)ex);
            return false;
        }
    }

    @NotNull
    public static class_2680 getBlockStateForceLoad(@NotNull class_1937 world, @NotNull class_2338 blockPos) {
        return world.method_8320(blockPos);
    }

    @NotNull
    public static class_2680 getBlockStateIfLoaded(class_1937 world, class_2338 blockPos) {
        if (class_1937.method_8518((class_2338)blockPos)) {
            return class_2246.field_10243.method_9564();
        }
        class_1922 chunk = world.method_22338(blockPos.method_10263() >> 4, blockPos.method_10260() >> 4);
        if (chunk == null) {
            return class_2246.field_10243.method_9564();
        }
        return chunk.method_8320(blockPos);
    }

    public static boolean setBlockStateForceLoad(class_1937 world, class_2338 blockPos, class_2680 blockState) {
        return world.method_8501(blockPos, blockState);
    }

    public static class_2350 getDirection(class_2680 state) {
        class_2738 face = (class_2738)state.method_11654((class_2769)class_2341.field_11007);
        if (face == class_2738.field_12473) {
            return class_2350.field_11033;
        }
        if (face == class_2738.field_12475) {
            return class_2350.field_11036;
        }
        return (class_2350)state.method_11654((class_2769)class_2341.field_11177);
    }

    @NotNull
    public static class_243 directionToBeamVector(@NotNull class_2350 direction) {
        class_2382 vector = direction.method_10163();
        return new class_243((double)vector.method_10263(), (double)vector.method_10264(), (double)vector.method_10260()).method_1029();
    }

    public static class_2338 moveAwayFromSurfaces(class_1937 world, class_2338 blockPos) {
        if (blockPos == null) {
            return null;
        }
        class_2338 resultPos = blockPos;
        if (!world.method_8320(resultPos.method_10069(-1, 0, 0)).method_26215() && world.method_8320(resultPos.method_10069(1, 0, 0)).method_26215()) {
            resultPos = resultPos.method_10069(1, 0, 0);
        } else if (!world.method_8320(resultPos.method_10069(1, 0, 0)).method_26215() && world.method_8320(resultPos.method_10069(-1, 0, 0)).method_26215()) {
            resultPos = resultPos.method_10069(-1, 0, 0);
        }
        if (!world.method_8320(resultPos.method_10069(0, -1, 0)).method_26215() && world.method_8320(resultPos.method_10069(0, 1, 0)).method_26215()) {
            resultPos = resultPos.method_10069(0, 1, 0);
        } else if (!world.method_8320(resultPos.method_10069(0, 1, 0)).method_26215() && world.method_8320(resultPos.method_10069(0, -1, 0)).method_26215()) {
            resultPos = resultPos.method_10069(0, -1, 0);
        }
        if (!world.method_8320(resultPos.method_10069(0, 0, -1)).method_26215() && world.method_8320(resultPos.method_10069(0, 0, 1)).method_26215()) {
            resultPos = resultPos.method_10069(0, 0, 1);
        } else if (!world.method_8320(resultPos.method_10069(0, 0, 1)).method_26215() && world.method_8320(resultPos.method_10069(0, 0, -1)).method_26215()) {
            resultPos = resultPos.method_10069(0, 0, -1);
        }
        return resultPos;
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean displayBeams() {
        class_746 player = class_310.method_1551().field_1724;
        return player != null && player.method_24518(SearchlightMod.getSearchlightItem());
    }
}

