/*
 * Decompiled with CFR 0.152.
 */
package me.lizardofoz.searchlight;

import java.util.function.Supplier;
import me.lizardofoz.searchlight.block.SearchlightBlockEntity;
import me.lizardofoz.searchlight.util.SearchlightUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.jetbrains.annotations.NotNull;

final class PacketStuff {
    private static final String PROTOCOL_VERSION = "1.0";
    private static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("searchlight", "packets"), () -> "1.0", "1.0"::equals, "1.0"::equals);

    private PacketStuff() {
    }

    public static void initialize() {
        INSTANCE.registerMessage(0, UpdateSearchlightS2CPacket.class, UpdateSearchlightS2CPacket::write, UpdateSearchlightS2CPacket::new, UpdateSearchlightS2CPacket::consume);
    }

    public static void sendUpdateRequestToClient(SearchlightBlockEntity blockEntity) {
        INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> (Chunk)blockEntity.func_145831_w().func_217349_x(blockEntity.func_174877_v())), (Object)new UpdateSearchlightS2CPacket(blockEntity));
    }

    private static class UpdateSearchlightS2CPacket {
        public final CompoundNBT compoundTag;

        public UpdateSearchlightS2CPacket(@NotNull SearchlightBlockEntity blockEntity) {
            this.compoundTag = blockEntity.toClientTag(new CompoundNBT());
        }

        public UpdateSearchlightS2CPacket(PacketBuffer buf) {
            this.compoundTag = buf.func_150793_b();
        }

        public void write(PacketBuffer buf) {
            buf.func_150786_a(this.compoundTag);
        }

        public void consume(Supplier<NetworkEvent.Context> supplier) {
            supplier.get().enqueueWork(this::syncBlock);
            supplier.get().setPacketHandled(true);
        }

        @OnlyIn(value=Dist.CLIENT)
        private void syncBlock() {
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            if (world == null) {
                return;
            }
            BlockPos blockPos = new BlockPos(this.compoundTag.func_74762_e("x"), this.compoundTag.func_74762_e("y"), this.compoundTag.func_74762_e("z"));
            SearchlightUtil.castBlockEntity(world.func_175625_s(blockPos), blockPos, blockEntity -> blockEntity.fromClientTag(this.compoundTag));
        }
    }
}

