/*
 * Decompiled with CFR 0.152.
 */
package me.lizardofoz.searchlight.block;

import me.lizardofoz.searchlight.SearchlightMod;
import me.lizardofoz.searchlight.block.SearchlightBlockEntity;
import me.lizardofoz.searchlight.util.SearchlightUtil;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchlightBlock
extends HorizontalFaceBlock
implements ITileEntityProvider {
    protected static final VoxelShape CEILING_SHAPE = Block.func_208617_a((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    protected static final VoxelShape FLOOR_SHAPE = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);
    protected static final VoxelShape NORTH_SHAPE = Block.func_208617_a((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)16.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.func_208617_a((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)13.0);
    protected static final VoxelShape WEST_SHAPE = Block.func_208617_a((double)3.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0);
    protected static final VoxelShape EAST_SHAPE = Block.func_208617_a((double)0.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);

    public SearchlightBlock(@NotNull AbstractBlock.Properties settings) {
        super(settings);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((Property)field_196366_M, (Comparable)AttachFace.WALL));
    }

    public TileEntity func_196283_a_(IBlockReader blockView) {
        return SearchlightMod.getBlockEntityConstructor().get();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D, field_196366_M});
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        Direction direction = SearchlightUtil.getDirection(state);
        if (direction == Direction.UP) {
            return FLOOR_SHAPE;
        }
        if (direction == Direction.DOWN) {
            return CEILING_SHAPE;
        }
        if (direction == Direction.EAST) {
            return EAST_SHAPE;
        }
        if (direction == Direction.WEST) {
            return WEST_SHAPE;
        }
        if (direction == Direction.SOUTH) {
            return SOUTH_SHAPE;
        }
        return NORTH_SHAPE;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.func_180633_a(world, pos, state, placer, itemStack);
        if (world != null && !world.field_72995_K) {
            this.updateSearchLight(world, pos, state, placer);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (player == null || world == null) {
            return ActionResultType.FAIL;
        }
        if (!world.field_72995_K && this.updateSearchLight(world, pos, state, (LivingEntity)player)) {
            world.func_184133_a(null, pos, SoundEvents.field_232777_jh_, SoundCategory.BLOCKS, 1.0f, 0.4f);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean moved) {
        if (!world.field_72995_K) {
            SearchlightUtil.castBlockEntity(world.func_175625_s(pos), pos, SearchlightBlockEntity::deleteLightSource);
        }
        super.func_196243_a(state, world, pos, newState, moved);
    }

    protected boolean updateSearchLight(@NotNull World world, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer) {
        boolean[] result = new boolean[1];
        SearchlightUtil.castBlockEntity(world.func_175625_s(pos), pos, blockEntity -> {
            result[0] = blockEntity.raycastAndPlaceLightSource(placer != null ? placer.func_70040_Z().func_186678_a(-1.0) : SearchlightUtil.directionToBeamVector(SearchlightUtil.getDirection(state)));
        });
        return result[0];
    }
}

