/*
 * Decompiled with CFR 0.152.
 */
package me.lizardofoz.searchlight.block;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import me.lizardofoz.searchlight.block.SearchlightBlockEntity;
import me.lizardofoz.searchlight.util.SearchlightUtil;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.BeaconTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SearchlightBlockRenderer
extends TileEntityRenderer<SearchlightBlockEntity> {
    protected static final RenderMaterial SEARCHLIGHT_BODY_TEXTURE = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("searchlight", "block/searchlight"));
    protected static final ResourceLocation SEARCHLIGHT_BEAM = new ResourceLocation("searchlight", "textures/block/searchlight_beam.png");
    protected static final int MAX_LIGHT = LightTexture.func_228451_a_((int)15, (int)15);
    protected static final int MAX_OVERLAY = OverlayTexture.func_229201_a_((int)15, (int)15);
    protected static final Vector3f CEILING_PIVOT = new Vector3f(8.0f, 10.0f, 8.0f);
    protected static final Vector3f FLOOR_PIVOT = new Vector3f(8.0f, 6.0f, 8.0f);
    protected static final Vector3f NORTH_PIVOT = new Vector3f(8.0f, 8.0f, 12.0f);
    protected static final Vector3f SOUTH_PIVOT = new Vector3f(8.0f, 8.0f, 4.0f);
    protected static final Vector3f WEST_PIVOT = new Vector3f(12.0f, 8.0f, 8.0f);
    protected static final Vector3f EAST_PIVOT = new Vector3f(4.0f, 8.0f, 8.0f);
    protected final ModelRenderer onWallBody = new ModelRenderer(32, 32, 0, 0);
    protected final ModelRenderer onWallLightFace = new ModelRenderer(32, 32, 0, 23);
    protected final ModelRenderer onFloorBody = new ModelRenderer(32, 32, 0, 0);
    protected final ModelRenderer ofFloorLightFace = new ModelRenderer(32, 32, 0, 23);

    public SearchlightBlockRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
        this.onWallBody.func_228300_a_(-3.0f, -6.0f, -3.0f, 6.0f, 7.0f, 6.0f);
        ModelRenderer wallFrontPart = new ModelRenderer(32, 32, 0, 13);
        wallFrontPart.func_228300_a_(4.0f, 4.0f, 4.0f, 8.0f, 2.0f, 8.0f);
        wallFrontPart.func_78793_a(-8.0f, -12.0f, -8.0f);
        this.onWallBody.func_78792_a(wallFrontPart);
        this.onWallLightFace.func_228300_a_(-4.0f, -8.0f, -4.0f, 8.0f, 1.0f, 8.0f);
        this.onFloorBody.func_228300_a_(-3.0f, -4.0f, -3.0f, 6.0f, 7.0f, 6.0f);
        ModelRenderer floorFrontPart = new ModelRenderer(32, 32, 0, 13);
        floorFrontPart.func_228300_a_(4.0f, 4.0f, 4.0f, 8.0f, 2.0f, 8.0f);
        floorFrontPart.func_78793_a(-8.0f, -10.0f, -8.0f);
        this.onFloorBody.func_78792_a(floorFrontPart);
        this.ofFloorLightFace.func_228300_a_(-4.0f, -6.0f, -4.0f, 8.0f, 1.0f, 8.0f);
    }

    public boolean rendersOutsideBoundingBox(SearchlightBlockEntity beaconBlockEntity) {
        return true;
    }

    public void render(SearchlightBlockEntity blockEntity, float tickDelta, MatrixStack matrixStack, IRenderTypeBuffer vertexConsumerProvider, int light, int overlay) {
        Vector3f pivot = this.getModelPivot(blockEntity);
        Vector3d direction = blockEntity.getBeamDirection();
        IVertexBuilder vertexConsumer = SEARCHLIGHT_BODY_TEXTURE.func_229311_a_(vertexConsumerProvider, RenderType::func_228640_c_);
        boolean isOnWall = blockEntity.func_195044_w().func_177229_b((Property)HorizontalFaceBlock.field_196366_M) == AttachFace.WALL;
        ModelRenderer body = isOnWall ? this.onWallBody : this.onFloorBody;
        ModelRenderer lightFace = isOnWall ? this.onWallLightFace : this.ofFloorLightFace;
        body.func_78793_a(pivot.func_195899_a(), pivot.func_195900_b(), pivot.func_195902_c());
        body.field_78796_g = (float)MathHelper.func_181159_b((double)direction.field_72450_a, (double)direction.field_72449_c);
        body.field_78795_f = (float)(MathHelper.func_181159_b((double)Math.sqrt(direction.field_72449_c * direction.field_72449_c + direction.field_72450_a * direction.field_72450_a), (double)direction.field_72448_b) + Math.PI);
        body.func_228308_a_(matrixStack, vertexConsumer, light, overlay);
        lightFace.func_78793_a(pivot.func_195899_a(), pivot.func_195900_b(), pivot.func_195902_c());
        lightFace.field_78796_g = body.field_78796_g;
        lightFace.field_78795_f = body.field_78795_f;
        lightFace.func_228308_a_(matrixStack, vertexConsumer, MAX_LIGHT, MAX_OVERLAY);
        if (SearchlightUtil.displayBeams() && blockEntity.getLightSourcePos() != null) {
            int distance = (int)Math.sqrt(blockEntity.getLightSourcePos().func_177951_i((Vector3i)blockEntity.func_174877_v())) + 1;
            this.drawBeam(pivot, body.field_78796_g, body.field_78795_f, distance, matrixStack, vertexConsumerProvider);
        }
    }

    protected void drawBeam(Vector3f pivot, float yaw, float pitch, int distance, MatrixStack matrixStack, IRenderTypeBuffer vertexConsumerProvider) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)(pivot.func_195899_a() / 16.0f), (double)(pivot.func_195900_b() / 16.0f), (double)(pivot.func_195902_c() / 16.0f));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(yaw));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_((float)(Math.PI + (double)pitch)));
        matrixStack.func_227861_a_(-0.5, 0.35, -0.5);
        BeaconTileEntityRenderer.func_228842_a_((MatrixStack)matrixStack, (IRenderTypeBuffer)vertexConsumerProvider, (ResourceLocation)SEARCHLIGHT_BEAM, (float)0.0f, (float)1.0f, (long)0L, (int)0, (int)distance, (float[])new float[]{1.0f, 1.0f, 1.0f}, (float)0.0f, (float)0.25f);
        matrixStack.func_227865_b_();
    }

    protected Vector3f getModelPivot(SearchlightBlockEntity blockEntity) {
        Direction direction = SearchlightUtil.getDirection(blockEntity.func_195044_w());
        if (direction == Direction.UP) {
            return FLOOR_PIVOT;
        }
        if (direction == Direction.DOWN) {
            return CEILING_PIVOT;
        }
        if (direction == Direction.EAST) {
            return EAST_PIVOT;
        }
        if (direction == Direction.WEST) {
            return WEST_PIVOT;
        }
        if (direction == Direction.SOUTH) {
            return SOUTH_PIVOT;
        }
        return NORTH_PIVOT;
    }
}

