/*
 * Decompiled with CFR 0.152.
 */
package me.lizardofoz.searchlight.util;

import java.util.function.Consumer;
import me.lizardofoz.searchlight.SearchlightMod;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SearchlightUtil {
    private SearchlightUtil() {
    }

    public static <T extends TileEntity> boolean castBlockEntity(@Nullable TileEntity blockEntity, @NotNull BlockPos blockPos, @NotNull Consumer<T> result) {
        if (blockEntity == null) {
            try {
                throw new IllegalStateException();
            }
            catch (Exception e) {
                SearchlightMod.LOGGER.error("Attempted to cast a null blockEntity at " + blockPos, (Throwable)e);
                return false;
            }
        }
        if (!blockEntity.func_145830_o()) {
            try {
                throw new IllegalStateException();
            }
            catch (Exception e) {
                SearchlightMod.LOGGER.error(String.format("Attempted to use a blockEntity '%s' (%s) at %s with world==null.", blockEntity.func_189515_b(new CompoundNBT()), blockEntity.getClass(), blockPos), (Throwable)e);
                return false;
            }
        }
        try {
            result.accept(blockEntity);
            return true;
        }
        catch (ClassCastException ex) {
            SearchlightMod.LOGGER.error(String.format("Attempted to cast '%s' (%s) at %s but failed", blockEntity.func_189515_b(new CompoundNBT()), blockEntity.getClass(), blockPos), (Throwable)ex);
            return false;
        }
    }

    @NotNull
    public static BlockState getBlockStateForceLoad(@NotNull World world, @NotNull BlockPos blockPos) {
        return world.func_180495_p(blockPos);
    }

    @NotNull
    public static BlockState getBlockStateIfLoaded(World world, BlockPos blockPos) {
        if (World.func_189509_E((BlockPos)blockPos)) {
            return Blocks.field_201940_ji.func_176223_P();
        }
        IBlockReader chunk = world.func_225522_c_(blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4);
        if (chunk == null) {
            return Blocks.field_201940_ji.func_176223_P();
        }
        return chunk.func_180495_p(blockPos);
    }

    public static boolean setBlockStateForceLoad(World world, BlockPos blockPos, BlockState blockState) {
        return world.func_175656_a(blockPos, blockState);
    }

    public static Direction getDirection(BlockState state) {
        AttachFace face = (AttachFace)state.func_177229_b((Property)HorizontalFaceBlock.field_196366_M);
        if (face == AttachFace.CEILING) {
            return Direction.DOWN;
        }
        if (face == AttachFace.FLOOR) {
            return Direction.UP;
        }
        return (Direction)state.func_177229_b((Property)HorizontalFaceBlock.field_185512_D);
    }

    @NotNull
    public static Vector3d directionToBeamVector(@NotNull Direction direction) {
        Vector3i vector = direction.func_176730_m();
        return new Vector3d((double)vector.func_177958_n(), (double)vector.func_177956_o(), (double)vector.func_177952_p()).func_72432_b();
    }

    public static BlockPos moveAwayFromSurfaces(World world, BlockPos blockPos) {
        if (blockPos == null) {
            return null;
        }
        BlockPos resultPos = blockPos;
        if (!world.func_180495_p(resultPos.func_177982_a(-1, 0, 0)).func_196958_f() && world.func_180495_p(resultPos.func_177982_a(1, 0, 0)).func_196958_f()) {
            resultPos = resultPos.func_177982_a(1, 0, 0);
        } else if (!world.func_180495_p(resultPos.func_177982_a(1, 0, 0)).func_196958_f() && world.func_180495_p(resultPos.func_177982_a(-1, 0, 0)).func_196958_f()) {
            resultPos = resultPos.func_177982_a(-1, 0, 0);
        }
        if (!world.func_180495_p(resultPos.func_177982_a(0, -1, 0)).func_196958_f() && world.func_180495_p(resultPos.func_177982_a(0, 1, 0)).func_196958_f()) {
            resultPos = resultPos.func_177982_a(0, 1, 0);
        } else if (!world.func_180495_p(resultPos.func_177982_a(0, 1, 0)).func_196958_f() && world.func_180495_p(resultPos.func_177982_a(0, -1, 0)).func_196958_f()) {
            resultPos = resultPos.func_177982_a(0, -1, 0);
        }
        if (!world.func_180495_p(resultPos.func_177982_a(0, 0, -1)).func_196958_f() && world.func_180495_p(resultPos.func_177982_a(0, 0, 1)).func_196958_f()) {
            resultPos = resultPos.func_177982_a(0, 0, 1);
        } else if (!world.func_180495_p(resultPos.func_177982_a(0, 0, 1)).func_196958_f() && world.func_180495_p(resultPos.func_177982_a(0, 0, -1)).func_196958_f()) {
            resultPos = resultPos.func_177982_a(0, 0, -1);
        }
        return resultPos;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean displayBeams() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        return player != null && player.func_233631_a_(SearchlightMod.getSearchlightItem());
    }
}

