/*
 * Decompiled with CFR 0.152.
 */
package me.lizardofoz.searchlight;

import java.util.function.Supplier;
import me.lizardofoz.searchlight.block.SearchlightBlockEntity;
import me.lizardofoz.searchlight.util.SearchlightUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.fmllegacy.network.NetworkRegistry;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import net.minecraftforge.fmllegacy.network.simple.SimpleChannel;
import org.jetbrains.annotations.NotNull;

final class PacketStuff {
    private static final String PROTOCOL_VERSION = "1.1";
    private static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("searchlight", "packets"), () -> "1.1", "1.1"::equals, "1.1"::equals);

    private PacketStuff() {
    }

    public static void initialize() {
        INSTANCE.registerMessage(0, UpdateSearchlightS2CPacket.class, UpdateSearchlightS2CPacket::write, UpdateSearchlightS2CPacket::new, UpdateSearchlightS2CPacket::consume);
    }

    public static void sendUpdateRequestToClient(SearchlightBlockEntity blockEntity) {
        INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> (LevelChunk)blockEntity.m_58904_().m_46865_(blockEntity.m_58899_())), (Object)new UpdateSearchlightS2CPacket(blockEntity));
    }

    private static class UpdateSearchlightS2CPacket {
        public final CompoundTag compoundTag;

        public UpdateSearchlightS2CPacket(@NotNull SearchlightBlockEntity blockEntity) {
            this.compoundTag = blockEntity.toClientTag(new CompoundTag());
        }

        public UpdateSearchlightS2CPacket(FriendlyByteBuf buf) {
            this.compoundTag = buf.m_130260_();
        }

        public void write(FriendlyByteBuf buf) {
            buf.m_130079_(this.compoundTag);
        }

        public void consume(Supplier<NetworkEvent.Context> supplier) {
            supplier.get().enqueueWork(this::syncBlock);
            supplier.get().setPacketHandled(true);
        }

        @OnlyIn(value=Dist.CLIENT)
        private void syncBlock() {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            if (world == null) {
                return;
            }
            BlockPos blockPos = new BlockPos(this.compoundTag.m_128451_("x"), this.compoundTag.m_128451_("y"), this.compoundTag.m_128451_("z"));
            SearchlightUtil.castBlockEntity(world.m_7702_(blockPos), blockPos, blockEntity -> blockEntity.fromClientTag(this.compoundTag));
        }
    }
}

