/*
 * Decompiled with CFR 0.152.
 */
package me.lizardofoz.searchlight;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import me.lizardofoz.searchlight.PacketStuff;
import me.lizardofoz.searchlight.SearchlightMod;
import me.lizardofoz.searchlight.block.SearchlightBlock;
import me.lizardofoz.searchlight.block.SearchlightBlockEntity;
import me.lizardofoz.searchlight.block.SearchlightBlockRenderer;
import me.lizardofoz.searchlight.block.SearchlightLightSourceBlock;
import me.lizardofoz.searchlight.block.SearchlightLightSourceBlockEntity;
import me.lizardofoz.searchlight.block.WallLightBlock;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(value="searchlight")
public final class SearchlightModForge
extends SearchlightMod {
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"searchlight");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"searchlight");
    private static final DeferredRegister<BlockEntityType<?>> TILE_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITIES, (String)"searchlight");

    public SearchlightModForge() {
        PacketStuff.initialize();
        BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        TILE_ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        creativeItemGroup = new CreativeModeTab("searchlight"){

            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)SearchlightMod.searchlightBlock);
            }
        };
        blockEntitySynchronizer = PacketStuff::sendUpdateRequestToClient;
        blockEntityConstructor = SearchlightBlockEntity::new;
        this.registerSearchlightBlock();
        this.registerSearchlightLightSourceBlock();
        this.registerWallLightBlocks();
    }

    private void registerSearchlightBlock() {
        searchlightBlock = new SearchlightBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76398_).m_60918_(SoundType.f_56743_).m_60978_(1.0f).m_60955_());
        searchlightItem = new BlockItem(searchlightBlock, new Item.Properties().m_41491_(creativeItemGroup));
        searchlightBlockEntityType = BlockEntityType.Builder.m_155273_((blockPos, blockState) -> (SearchlightBlockEntity)((Object)((Object)blockEntityConstructor.apply(blockPos, blockState))), (Block[])new Block[]{searchlightBlock}).m_58966_(null);
        BLOCKS.register("searchlight", () -> searchlightBlock);
        ITEMS.register("searchlight", () -> searchlightItem);
        TILE_ENTITIES.register("searchlight_entity", () -> searchlightBlockEntityType);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            BlockEntityRenderers.m_173590_((BlockEntityType)searchlightBlockEntityType, SearchlightBlockRenderer::new);
        }
    }

    private void registerSearchlightLightSourceBlock() {
        lightSourceBlock = new SearchlightLightSourceBlock(BlockBehaviour.Properties.m_60939_((Material)new Material.Builder(MaterialColor.f_76398_).m_76356_().m_76353_().m_76359_()).m_60918_(SoundType.f_56736_).m_60978_(3600000.8f).m_60993_().m_60955_().m_60953_(state -> 15));
        lightSourceBlockEntityType = BlockEntityType.Builder.m_155273_(SearchlightLightSourceBlockEntity::new, (Block[])new Block[]{lightSourceBlock}).m_58966_(null);
        BLOCKS.register("searchlight_lightsource", () -> lightSourceBlock);
        TILE_ENTITIES.register("searchlight_lightsource_entity", () -> lightSourceBlockEntityType);
    }

    private void registerWallLightBlocks() {
        HashMap<Block, Item> wallLights = new HashMap<Block, Item>();
        this.registerWallLight("iron", wallLights);
        this.registerWallLight("copper", wallLights);
        this.registerWallLight("prismarine", wallLights);
        for (DyeColor color : DyeColor.values()) {
            this.registerWallLight(color.m_41065_(), wallLights);
        }
        wallLightBlocks = ImmutableMap.copyOf(wallLights);
    }

    private void registerWallLight(String postfix, Map<Block, Item> wallLightMap) {
        WallLightBlock block = new WallLightBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60978_(0.5f).m_60953_(state -> 14).m_60918_(SoundType.f_56742_).m_60955_().m_60910_());
        BlockItem item = new BlockItem((Block)block, new Item.Properties().m_41491_(creativeItemGroup));
        BLOCKS.register("wall_light_" + postfix, () -> SearchlightModForge.lambda$registerWallLight$8((Block)block));
        ITEMS.register("wall_light_" + postfix, () -> SearchlightModForge.lambda$registerWallLight$9((Item)item));
        wallLightMap.put((Block)block, (Item)item);
    }

    private static /* synthetic */ Item lambda$registerWallLight$9(Item item) {
        return item;
    }

    private static /* synthetic */ Block lambda$registerWallLight$8(Block block) {
        return block;
    }
}

