/*
 * Decompiled with CFR 0.152.
 */
package me.lizardofoz.searchlight.block;

import me.lizardofoz.searchlight.SearchlightMod;
import me.lizardofoz.searchlight.block.SearchlightBlockEntity;
import me.lizardofoz.searchlight.util.SearchlightUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchlightBlock
extends FaceAttachedHorizontalDirectionalBlock
implements EntityBlock {
    protected static final VoxelShape CEILING_SHAPE = Block.m_49796_((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    protected static final VoxelShape FLOOR_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);
    protected static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)16.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)13.0);
    protected static final VoxelShape WEST_SHAPE = Block.m_49796_((double)3.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0);
    protected static final VoxelShape EAST_SHAPE = Block.m_49796_((double)0.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);

    public SearchlightBlock(@NotNull BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)f_53179_, (Comparable)AttachFace.WALL));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState blockState) {
        return SearchlightMod.getBlockEntityConstructor().apply(pos, blockState);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, f_53179_});
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = SearchlightUtil.getDirection(state);
        if (direction == Direction.UP) {
            return FLOOR_SHAPE;
        }
        if (direction == Direction.DOWN) {
            return CEILING_SHAPE;
        }
        if (direction == Direction.EAST) {
            return EAST_SHAPE;
        }
        if (direction == Direction.WEST) {
            return WEST_SHAPE;
        }
        if (direction == Direction.SOUTH) {
            return SOUTH_SHAPE;
        }
        return NORTH_SHAPE;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.m_6402_(world, pos, state, placer, itemStack);
        if (world != null && !world.f_46443_ && !this.updateSearchLight(world, pos, state, placer)) {
            this.updateSearchLight(world, pos, state, null);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player == null || world == null) {
            return InteractionResult.FAIL;
        }
        if (!world.f_46443_ && this.updateSearchLight(world, pos, state, (LivingEntity)player)) {
            world.m_5594_(null, pos, SoundEvents.f_12200_, SoundSource.BLOCKS, 1.0f, 0.4f);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!world.f_46443_) {
            SearchlightUtil.castBlockEntity(world.m_7702_(pos), pos, SearchlightBlockEntity::deleteLightSource);
        }
        super.m_6810_(state, world, pos, newState, moved);
    }

    protected boolean updateSearchLight(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer) {
        boolean[] result = new boolean[1];
        SearchlightUtil.castBlockEntity(world.m_7702_(pos), pos, blockEntity -> {
            result[0] = blockEntity.raycastAndPlaceLightSource(placer != null ? placer.m_20154_().m_82490_(-1.0) : SearchlightUtil.directionToBeamVector(SearchlightUtil.getDirection(state)));
        });
        return result[0];
    }
}

