/*
 * Decompiled with CFR 0.152.
 */
package me.lizardofoz.searchlight.block;

import me.lizardofoz.searchlight.SearchlightMod;
import me.lizardofoz.searchlight.block.SearchlightLightSourceBlock;
import me.lizardofoz.searchlight.util.MutableVector3d;
import me.lizardofoz.searchlight.util.SearchlightUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.lighting.LayerLightEngine;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchlightBlockEntity
extends BlockEntity {
    @Nullable
    private BlockPos lightSourcePos;

    public SearchlightBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(SearchlightMod.getSearchlightBlockEntityType(), blockPos, blockState);
    }

    public CompoundTag m_6945_(CompoundTag tag) {
        super.m_6945_(tag);
        if (this.lightSourcePos != null) {
            tag.m_128405_("light_source_x", this.lightSourcePos.m_123341_());
            tag.m_128405_("light_source_y", this.lightSourcePos.m_123342_());
            tag.m_128405_("light_source_z", this.lightSourcePos.m_123343_());
        }
        return tag;
    }

    public CompoundTag toClientTag(@NotNull CompoundTag tag) {
        return this.m_6945_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.fromClientTag(tag);
    }

    public void fromClientTag(@NotNull CompoundTag tag) {
        this.lightSourcePos = tag.m_128441_("light_source_x") && tag.m_128441_("light_source_y") && tag.m_128441_("light_source_z") ? new BlockPos(tag.m_128451_("light_source_x"), tag.m_128451_("light_source_y"), tag.m_128451_("light_source_z")) : null;
    }

    public CompoundTag m_5995_() {
        return this.m_6945_(super.m_5995_());
    }

    @NotNull
    public Vec3 getBeamDirection() {
        if (this.lightSourcePos == null) {
            return SearchlightUtil.directionToBeamVector(SearchlightUtil.getDirection(this.m_58900_()));
        }
        BlockPos delta = this.lightSourcePos.m_141950_((Vec3i)this.m_58899_());
        return new Vec3((double)delta.m_123341_(), (double)delta.m_123342_(), (double)delta.m_123343_()).m_82541_();
    }

    public boolean deleteLightSource() {
        BlockPos oldLightSourcePos = this.lightSourcePos;
        this.setLightSourcePos(null);
        if (oldLightSourcePos != null && SearchlightUtil.getBlockStateForceLoad(this.f_58857_, oldLightSourcePos).m_60734_() instanceof SearchlightLightSourceBlock) {
            return SearchlightUtil.setBlockStateForceLoad(this.f_58857_, oldLightSourcePos, Blocks.f_50016_.m_49966_());
        }
        return false;
    }

    public boolean raycastAndPlaceLightSource(@NotNull Vec3 beamDirection) {
        BlockPos newLightPos = this.calculateLightSourcePosition(beamDirection = beamDirection.m_82541_());
        return newLightPos != null && this.placeLightSource(newLightPos);
    }

    public boolean placeLightSource(@Nullable BlockPos newLightPos) {
        this.deleteLightSource();
        if (newLightPos == null) {
            this.setLightSourcePos(null);
            return false;
        }
        BlockState oldBlockState = SearchlightUtil.getBlockStateForceLoad(this.f_58857_, newLightPos);
        if (!SearchlightUtil.setBlockStateForceLoad(this.f_58857_, newLightPos, SearchlightMod.getLightSourceBlock().m_49966_())) {
            return false;
        }
        if (!SearchlightUtil.castBlockEntity(this.f_58857_.m_7702_(newLightPos), newLightPos, lightBlockEntity -> {
            lightBlockEntity.searchlightBlockPos = this.m_58899_();
            this.setLightSourcePos(newLightPos);
        })) {
            SearchlightUtil.setBlockStateForceLoad(this.f_58857_, newLightPos, oldBlockState);
            this.setLightSourcePos(null);
            return false;
        }
        return true;
    }

    @Nullable
    public BlockPos calculateLightSourcePosition(@NotNull Vec3 beamDirection) {
        beamDirection = beamDirection.m_82541_();
        ChunkSource chunkManager = this.f_58857_.m_7726_();
        MutableVector3d currentBlockPosD = new MutableVector3d((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5);
        BlockPos.MutableBlockPos currentBlockPos = new BlockPos.MutableBlockPos(currentBlockPosD.x, currentBlockPosD.y, currentBlockPosD.z);
        BlockPos.MutableBlockPos prevBlockPos = new BlockPos.MutableBlockPos(0, 0, 0);
        BlockPos.MutableBlockPos currentChunkPos = new BlockPos.MutableBlockPos(0, 0, 0);
        BlockPos.MutableBlockPos prevChunkPos = new BlockPos.MutableBlockPos(0, 0, 0);
        BlockPos lastValidBlockPos = null;
        while (true) {
            prevBlockPos.m_122190_((Vec3i)currentBlockPos);
            currentBlockPosD.add(beamDirection);
            currentBlockPos.m_122169_(currentBlockPosD.x, currentBlockPosD.y, currentBlockPosD.z);
            if (prevBlockPos.equals((Object)currentBlockPos)) continue;
            if (!this.f_58857_.m_46739_((BlockPos)currentBlockPos)) {
                return null;
            }
            prevChunkPos.m_122178_(prevBlockPos.m_123341_() >> 4, 0, prevBlockPos.m_123343_() >> 4);
            currentChunkPos.m_122178_(currentBlockPos.m_123341_() >> 4, 0, currentBlockPos.m_123343_() >> 4);
            if (!prevChunkPos.equals((Object)currentChunkPos) && !chunkManager.m_5563_(currentChunkPos.m_123341_(), currentChunkPos.m_123343_())) {
                return null;
            }
            BlockState currentBlockState = SearchlightUtil.getBlockStateForceLoad(this.f_58857_, (BlockPos)currentBlockPos);
            BlockState prevBlockState = SearchlightUtil.getBlockStateForceLoad(this.f_58857_, (BlockPos)prevBlockPos);
            if (LayerLightEngine.m_75667_((BlockGetter)this.f_58857_, (BlockState)prevBlockState, (BlockPos)prevBlockPos, (BlockState)currentBlockState, (BlockPos)currentBlockPos, (Direction)Direction.m_122366_((double)beamDirection.f_82479_, (double)beamDirection.f_82480_, (double)beamDirection.f_82481_), (int)currentBlockState.m_60739_((BlockGetter)this.f_58857_, (BlockPos)currentBlockPos)) >= this.f_58857_.m_7469_() || !this.f_58857_.m_6425_((BlockPos)currentBlockPos).m_76178_()) {
                return SearchlightUtil.moveAwayFromSurfaces(this.f_58857_, lastValidBlockPos);
            }
            if (!currentBlockState.m_60795_() && !currentBlockPos.equals((Object)this.lightSourcePos)) continue;
            lastValidBlockPos = currentBlockPos.m_7949_();
        }
    }

    protected void setLightSourcePos(@Nullable BlockPos lightSourcePos) {
        this.lightSourcePos = lightSourcePos;
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            SearchlightMod.getBlockEntitySynchronizer().accept(this);
        }
    }

    @Nullable
    public BlockPos getLightSourcePos() {
        return this.lightSourcePos;
    }
}

