/*
 * Decompiled with CFR 0.152.
 */
package me.lizardofoz.searchlight.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import me.lizardofoz.searchlight.block.SearchlightBlockEntity;
import me.lizardofoz.searchlight.util.SearchlightUtil;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SearchlightBlockRenderer
implements BlockEntityRenderer<SearchlightBlockEntity> {
    protected static final ResourceLocation SEARCHLIGHT_BODY_TEXTURE = new ResourceLocation("searchlight", "textures/block/searchlight.png");
    protected static final ResourceLocation SEARCHLIGHT_BEAM = new ResourceLocation("searchlight", "textures/block/searchlight_beam.png");
    protected static final int MAX_LIGHT = LightTexture.m_109885_((int)15, (int)15);
    protected static final int NO_LIGHT = LightTexture.m_109885_((int)0, (int)0);
    protected static final int MAX_OVERLAY = OverlayTexture.m_118093_((int)15, (int)15);
    protected static final Vector3f CEILING_PIVOT = new Vector3f(8.0f, 10.0f, 8.0f);
    protected static final Vector3f FLOOR_PIVOT = new Vector3f(8.0f, 6.0f, 8.0f);
    protected static final Vector3f NORTH_PIVOT = new Vector3f(8.0f, 8.0f, 12.0f);
    protected static final Vector3f SOUTH_PIVOT = new Vector3f(8.0f, 8.0f, 4.0f);
    protected static final Vector3f WEST_PIVOT = new Vector3f(12.0f, 8.0f, 8.0f);
    protected static final Vector3f EAST_PIVOT = new Vector3f(4.0f, 8.0f, 8.0f);
    protected final ModelPart onWallBody;
    protected final ModelPart onWallLightFace;
    protected final ModelPart onFloorBody;
    protected final ModelPart onFloorLightFace;

    public SearchlightBlockRenderer(BlockEntityRendererProvider.Context context) {
        PartDefinition root = new MeshDefinition().m_171576_();
        root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.0f, -6.0f, -3.0f, 6.0f, 7.0f, 6.0f), PartPose.f_171404_);
        root.m_171599_("front", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171481_(4.0f, 4.0f, 4.0f, 8.0f, 2.0f, 8.0f), PartPose.m_171419_((float)-8.0f, (float)-12.0f, (float)-8.0f));
        this.onWallBody = root.m_171583_(32, 32);
        this.onWallLightFace = new MeshDefinition().m_171576_().m_171599_("face", CubeListBuilder.m_171558_().m_171514_(0, 23).m_171481_(-4.0f, -8.0f, -4.0f, 8.0f, 1.0f, 8.0f), PartPose.f_171404_).m_171583_(32, 32);
        root = new MeshDefinition().m_171576_();
        root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.0f, -4.0f, -3.0f, 6.0f, 7.0f, 6.0f), PartPose.f_171404_);
        root.m_171599_("front", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171481_(4.0f, 4.0f, 4.0f, 8.0f, 2.0f, 8.0f), PartPose.m_171419_((float)-8.0f, (float)-10.0f, (float)-8.0f));
        this.onFloorBody = root.m_171583_(32, 32);
        this.onFloorLightFace = new MeshDefinition().m_171576_().m_171599_("face", CubeListBuilder.m_171558_().m_171514_(0, 23).m_171481_(-4.0f, -6.0f, -4.0f, 8.0f, 1.0f, 8.0f), PartPose.f_171404_).m_171583_(32, 32);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int m_142163_() {
        return SearchlightUtil.displayBeams() ? 256 : super.m_142163_();
    }

    public boolean rendersOutsideBoundingBox(SearchlightBlockEntity beaconBlockEntity) {
        return true;
    }

    public void render(SearchlightBlockEntity blockEntity, float tickDelta, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int light, int overlay) {
        Vector3f pivot = this.getModelPivot(blockEntity);
        Vec3 direction = blockEntity.getBeamDirection();
        VertexConsumer vertexConsumer = vertexConsumerProvider.m_6299_(RenderType.m_110443_((ResourceLocation)SEARCHLIGHT_BODY_TEXTURE, (boolean)true));
        boolean isOnWall = blockEntity.m_58900_().m_61143_((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_) == AttachFace.WALL;
        ModelPart body = isOnWall ? this.onWallBody : this.onFloorBody;
        ModelPart lightFace = isOnWall ? this.onWallLightFace : this.onFloorLightFace;
        body.m_104227_(pivot.m_122239_(), pivot.m_122260_(), pivot.m_122269_());
        body.f_104204_ = (float)Mth.m_14136_((double)direction.f_82479_, (double)direction.f_82481_);
        body.f_104203_ = (float)(Mth.m_14136_((double)Math.sqrt(direction.f_82481_ * direction.f_82481_ + direction.f_82479_ * direction.f_82479_), (double)direction.f_82480_) + Math.PI);
        body.m_104301_(matrixStack, vertexConsumer, light, overlay);
        lightFace.m_104227_(pivot.m_122239_(), pivot.m_122260_(), pivot.m_122269_());
        lightFace.f_104204_ = body.f_104204_;
        lightFace.f_104203_ = body.f_104203_;
        lightFace.m_104301_(matrixStack, vertexConsumer, blockEntity.getLightSourcePos() != null ? MAX_LIGHT : NO_LIGHT, MAX_OVERLAY);
        if (SearchlightUtil.displayBeams() && blockEntity.getLightSourcePos() != null) {
            int distance = (int)Math.sqrt(blockEntity.getLightSourcePos().m_123331_((Vec3i)blockEntity.m_58899_())) + 1;
            this.drawBeam(pivot, body.f_104204_, body.f_104203_, distance, matrixStack, vertexConsumerProvider);
        }
    }

    protected void drawBeam(Vector3f pivot, float yaw, float pitch, int distance, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider) {
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)(pivot.m_122239_() / 16.0f), (double)(pivot.m_122260_() / 16.0f), (double)(pivot.m_122269_() / 16.0f));
        matrixStack.m_85845_(Vector3f.f_122225_.m_122270_(yaw));
        matrixStack.m_85845_(Vector3f.f_122223_.m_122270_((float)(Math.PI + (double)pitch)));
        matrixStack.m_85837_(-0.5, 0.35, -0.5);
        BeaconRenderer.m_112184_((PoseStack)matrixStack, (MultiBufferSource)vertexConsumerProvider, (ResourceLocation)SEARCHLIGHT_BEAM, (float)0.0f, (float)1.0f, (long)0L, (int)0, (int)distance, (float[])new float[]{1.0f, 1.0f, 1.0f}, (float)0.0f, (float)0.25f);
        matrixStack.m_85849_();
    }

    protected Vector3f getModelPivot(SearchlightBlockEntity blockEntity) {
        Direction direction = SearchlightUtil.getDirection(blockEntity.m_58900_());
        if (direction == Direction.UP) {
            return FLOOR_PIVOT;
        }
        if (direction == Direction.DOWN) {
            return CEILING_PIVOT;
        }
        if (direction == Direction.EAST) {
            return EAST_PIVOT;
        }
        if (direction == Direction.WEST) {
            return WEST_PIVOT;
        }
        if (direction == Direction.SOUTH) {
            return SOUTH_PIVOT;
        }
        return NORTH_PIVOT;
    }
}

