/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.sg.m_generators.m_turbine;

import com.google.gson.JsonObject;
import com.valkyrieofnight.sg.SGMod;
import com.valkyrieofnight.sg.m_generators.SGenerators;
import com.valkyrieofnight.sg.m_generators.m_turbine.features.TBlocks;
import com.valkyrieofnight.sg.m_generators.m_turbine.features.TurbineJei;
import com.valkyrieofnight.sg.m_generators.registry.SingleFluidEntry;
import com.valkyrieofnight.sg.m_generators.registry.SingleFluidJsonRegistry;
import com.valkyrieofnight.sg.m_generators.registry.SingleFluidRegistry;
import com.valkyrieofnight.vliblegacy.lib.module.IFeature;
import com.valkyrieofnight.vliblegacy.lib.module.VLModule;
import java.io.File;
import java.util.ArrayList;
import java.util.function.BooleanSupplier;
import net.minecraftforge.common.crafting.IConditionFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class GTurbine
extends VLModule {
    private static GTurbine instance;
    protected SingleFluidJsonRegistry TURBINE_JSON_SIMPLE;
    protected ArrayList<SingleFluidEntry> defaults = new ArrayList();
    public static SingleFluidRegistry TURBINE_REG_SIMPLE;

    public static GTurbine getInstance() {
        if (instance == null) {
            instance = new GTurbine();
        }
        return instance;
    }

    public GTurbine() {
        super("turbine", (VLModule)SGenerators.getInstance());
    }

    protected void initModule() {
        this.TURBINE_JSON_SIMPLE = new SingleFluidJsonRegistry(SGMod.GSON, new File("config/" + this.getLocation() + "fuels.json"));
        TURBINE_REG_SIMPLE = new SingleFluidRegistry();
    }

    protected void addFeatures() {
        this.addFeature((IFeature)TBlocks.getInstance());
        this.addFeature((IFeature)TurbineJei.getInstance());
    }

    protected boolean enabledByDefault() {
        return true;
    }

    protected void preInitCommon(FMLPreInitializationEvent event) {
    }

    protected void initCommon(FMLInitializationEvent event) {
    }

    protected void postInitCommon(FMLPostInitializationEvent event) {
        if (this.TURBINE_JSON_SIMPLE.doesFileExsist()) {
            this.TURBINE_JSON_SIMPLE.loadRegistryFromJson();
        }
        this.defaults.add(new SingleFluidEntry("steam", 2));
        this.defaults.add(new SingleFluidEntry("ic2steam", 2));
        this.defaults.add(new SingleFluidEntry("ic2superheated_steam", 4));
        if (!this.TURBINE_JSON_SIMPLE.doesFileExsist()) {
            this.TURBINE_JSON_SIMPLE.addAll(this.defaults);
            this.TURBINE_JSON_SIMPLE.saveRegistryToJson();
        }
        ArrayList entries = this.TURBINE_JSON_SIMPLE.getData();
        for (SingleFluidEntry sfe : entries) {
            if (sfe.getFluid() == null) continue;
            TURBINE_REG_SIMPLE.register(sfe.getFluid(), sfe.getEnergy());
        }
    }

    public static class CraftTurbineGens
    implements IConditionFactory {
        public BooleanSupplier parse(JsonContext context, JsonObject json) {
            return new BooleanSupplier(){

                @Override
                public boolean getAsBoolean() {
                    return GTurbine.getInstance().isEnabledAndParent();
                }
            };
        }
    }
}

