/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.sg.m_generators.registry;

import com.valkyrieofnight.sg.m_generators.registry.SingleFluidEntry;
import com.valkyrieofnight.sg.m_generators.registry.SingleFluidJsonRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraftforge.fluids.Fluid;

public class SingleFluidRegistry {
    public HashMap<Fluid, Integer> consumables = new HashMap();

    public void register(Fluid fluid, int energy) {
        if (fluid != null) {
            this.consumables.put(fluid, energy);
        }
    }

    public void registerAll(Map<Fluid, Integer> all) {
        for (Fluid f : all.keySet()) {
            this.register(f, all.get(f));
        }
    }

    public boolean isValidConsumable(Fluid fluid) {
        if (fluid == null) {
            return false;
        }
        for (Fluid f : this.consumables.keySet()) {
            if (f != fluid) continue;
            return true;
        }
        return false;
    }

    public int getEnergyValue(Fluid f) {
        if (f == null) {
            return 0;
        }
        if (this.isValidConsumable(f)) {
            for (Fluid f2 : this.consumables.keySet()) {
                if (f2 != f) continue;
                return this.consumables.get(f);
            }
        }
        return 0;
    }

    public void forEach(BiConsumer<Fluid, Integer> action) {
        this.consumables.forEach(action);
    }

    public void loadFromJsonRegistry(SingleFluidJsonRegistry reg) {
        ArrayList entries = reg.getData();
        for (SingleFluidEntry singleFluidEntry : entries) {
        }
    }
}

