/*
 * Decompiled with CFR 0.152.
 */
package com.dhanantry.scapeandrunparasites.blocks;

import com.dhanantry.scapeandrunparasites.entity.SRPAttributes;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.events.ParasiteEvent;
import com.dhanantry.scapeandrunparasites.init.SRPBlocks;
import com.dhanantry.scapeandrunparasites.init.SRPSounds;
import com.dhanantry.scapeandrunparasites.render.particle.ParticleSpawner;
import com.dhanantry.scapeandrunparasites.render.particle.SRPEnumParticle;
import com.dhanantry.scapeandrunparasites.util.SRPConfig;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockInfested
extends Block {
    public static final PropertyInteger STAGE = PropertyInteger.func_177719_a((String)"stage", (int)0, (int)3);
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");

    public BlockInfested(String name) {
        super(Material.field_151583_m);
        this.setRegistryName(name);
        this.func_149663_c("srparasites." + name);
        this.func_149711_c(0.4f);
        this.func_149672_a(new SoundType(1.0f, 0.5f, SRPSounds.BLOCKINFEST_BREAK, SRPSounds.BLOCKINFEST_STEP, SRPSounds.BLOCKINFEST_PLACE, SRPSounds.BLOCKINFEST_HIT, SoundEvents.field_187876_fn));
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.func_175697_a(pos, 3)) {
            return;
        }
        if (this.func_176201_c(state) >= 10) {
            if (rand.nextDouble() <= 0.005 && !worldIn.func_184145_b(pos, state.func_177230_c())) {
                this.func_180650_b(worldIn, pos, state, rand);
            }
            return;
        }
        worldIn.func_175654_a(pos, state.func_177230_c(), ParasiteEvent.getTimer(this.func_176201_c(state)), 5);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            int meta = this.func_176201_c(state);
            if (meta >= 10) {
                if (rand.nextDouble() <= 0.0075 && meta >= 12) {
                    if (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150350_a) {
                        worldIn.func_175656_a(pos.func_177984_a(), SRPBlocks.InfestGrass.func_176223_P());
                    }
                    return;
                }
                meta -= 10;
            }
            if (worldIn.func_175724_o(pos.func_177984_a()) > (float)(SRPAttributes.rsBlockLightLevel / 15) && meta != 0) {
                return;
            }
            if (worldIn.func_175642_b(EnumSkyBlock.BLOCK, pos.func_177984_a()) > SRPAttributes.rsBlockLightLevel && meta != 0) {
                return;
            }
            int newmeta = meta + 10;
            Block current = state.func_177230_c();
            if (ParasiteEvent.canInfest(worldIn, pos, pos.func_177978_c(), state, meta)) {
                worldIn.func_175656_a(pos.func_177978_c(), state);
            }
            if (ParasiteEvent.canInfest(worldIn, pos, pos.func_177968_d(), state, meta)) {
                worldIn.func_175656_a(pos.func_177968_d(), state);
            }
            if (ParasiteEvent.canInfest(worldIn, pos, pos.func_177974_f(), state, meta)) {
                worldIn.func_175656_a(pos.func_177974_f(), state);
            }
            if (ParasiteEvent.canInfest(worldIn, pos, pos.func_177976_e(), state, meta)) {
                worldIn.func_175656_a(pos.func_177976_e(), state);
            }
            if (ParasiteEvent.canInfest(worldIn, pos, pos.func_177984_a(), state, meta)) {
                worldIn.func_175656_a(pos.func_177984_a(), state);
            }
            if ((meta > 1 || meta == 0) && ParasiteEvent.canInfest(worldIn, pos, pos.func_177977_b(), state, meta)) {
                worldIn.func_175656_a(pos.func_177977_b(), state);
            }
            if (meta == 0) {
                worldIn.func_175656_a(pos, SRPBlocks.optional.func_176223_P());
                if (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150350_a || worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == SRPBlocks.InfestGrass) {
                    worldIn.func_175656_a(pos.func_177984_a(), SRPBlocks.InfestRemain.func_176223_P());
                }
            } else if (meta < 10) {
                worldIn.func_175656_a(pos, this.func_176203_a(newmeta));
            }
        }
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        if (!worldIn.field_72995_K) {
            if (entityIn.field_70173_aa % 20 != 0) {
                return;
            }
            if (!(entityIn instanceof EntityParasiteBase) && entityIn instanceof EntityLivingBase) {
                ParasiteEvent.damageEntity(worldIn, pos, entityIn, this.func_176201_c(worldIn.func_180495_p(pos)));
                if (entityIn.field_70173_aa % 400 == 0) {
                    Random rand;
                    if (entityIn instanceof EntityPlayer) {
                        EntityPlayer in = (EntityPlayer)entityIn;
                        if (in.field_71075_bZ.field_75102_a) {
                            return;
                        }
                    }
                    if ((rand = new Random()).nextInt(4) == 0) {
                        ParasiteEvent.spawnTurrets((EntityLivingBase)entityIn, 4, (byte)2);
                    } else {
                        ParasiteEvent.spawnTurrets((EntityLivingBase)entityIn, 10, (byte)1);
                    }
                }
            }
        }
        super.func_176199_a(worldIn, pos, entityIn);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STAGE, ACTIVE});
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        if (((Boolean)state.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
            meta += 10;
        }
        return meta + (Integer)state.func_177229_b((IProperty)STAGE);
    }

    public IBlockState func_176203_a(int meta) {
        if (meta >= 10) {
            int meta2 = meta - 10;
            return this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(meta2 & 3)).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(true));
        }
        return this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(meta & 3)).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    public int func_149738_a(World worldIn) {
        return 20;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        rand = new Random();
        if (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() != Blocks.field_150350_a && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() != SRPBlocks.InfestGrass) {
            return;
        }
        int stage = this.func_176201_c(stateIn);
        if (stage == 12 || stage == 2) {
            if (rand.nextDouble() <= (double)SRPConfig.rsBlockParticleS) {
                double d0 = (double)pos.func_177958_n() + rand.nextDouble();
                double d1 = (double)pos.func_177956_o() + 2.5;
                double d2 = (double)pos.func_177952_p() + rand.nextDouble();
                ParticleSpawner.spawnParticle(SRPEnumParticle.SPORE, d0, d1, d2, 0.0, 0.0, 0.0, 0, 0, 0);
                return;
            }
        } else if (stage == 13 || stage == 3) {
            double d2;
            double d1;
            double d0;
            if (rand.nextDouble() <= (double)SRPConfig.rsBlockParticleF) {
                d0 = (double)pos.func_177958_n() + rand.nextDouble();
                d1 = (double)pos.func_177956_o() + 1.5;
                d2 = (double)pos.func_177952_p() + rand.nextDouble();
                int g = 200;
                if (rand.nextInt(3) == 0) {
                    g += 50;
                }
                ParticleSpawner.spawnParticle(SRPEnumParticle.FOG, d0, d1, d2, 0.0, 1.0E-4, 0.0, 0, g, 0);
            }
            if (rand.nextDouble() <= (double)SRPConfig.rsBlockParticleS) {
                d0 = (double)pos.func_177958_n() + rand.nextDouble();
                d1 = (double)pos.func_177956_o() + 2.5;
                d2 = (double)pos.func_177952_p() + rand.nextDouble();
                ParticleSpawner.spawnParticle(SRPEnumParticle.SPORE, d0, d1, d2, 0.0, 0.0, 0.0, 0, 0, 0);
            }
        }
    }
}

