/*
 * Decompiled with CFR 0.152.
 */
package com.dhanantry.scapeandrunparasites.init;

import com.dhanantry.scapeandrunparasites.entity.ai.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.entity.monster.adapted.EntityBanoAdapted;
import com.dhanantry.scapeandrunparasites.entity.monster.adapted.EntityCanraAdapted;
import com.dhanantry.scapeandrunparasites.entity.monster.adapted.EntityEmanaAdapted;
import com.dhanantry.scapeandrunparasites.entity.monster.adapted.EntityHullAdapted;
import com.dhanantry.scapeandrunparasites.entity.monster.adapted.EntityNoglaAdapted;
import com.dhanantry.scapeandrunparasites.entity.monster.adapted.EntityShycoAdapted;
import com.dhanantry.scapeandrunparasites.entity.monster.ancient.EntityOronco;
import com.dhanantry.scapeandrunparasites.entity.monster.ancient.EntityTerla;
import com.dhanantry.scapeandrunparasites.entity.monster.inborn.EntityAnged;
import com.dhanantry.scapeandrunparasites.entity.monster.inborn.EntityButhol;
import com.dhanantry.scapeandrunparasites.entity.monster.inborn.EntityGanro;
import com.dhanantry.scapeandrunparasites.entity.monster.inborn.EntityLodo;
import com.dhanantry.scapeandrunparasites.entity.monster.inborn.EntityMudo;
import com.dhanantry.scapeandrunparasites.entity.monster.inborn.EntityRathol;
import com.dhanantry.scapeandrunparasites.entity.monster.inborn.EntityVenkrol;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityAlafha;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityDorpa;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfCow;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfHuman;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfPig;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfSheep;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfVillager;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfWolf;
import com.dhanantry.scapeandrunparasites.entity.monster.primitive.EntityBano;
import com.dhanantry.scapeandrunparasites.entity.monster.primitive.EntityCanra;
import com.dhanantry.scapeandrunparasites.entity.monster.primitive.EntityEmana;
import com.dhanantry.scapeandrunparasites.entity.monster.primitive.EntityHull;
import com.dhanantry.scapeandrunparasites.entity.monster.primitive.EntityNogla;
import com.dhanantry.scapeandrunparasites.entity.monster.primitive.EntityShyco;
import com.dhanantry.scapeandrunparasites.util.SRPConfig;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SRPSpawning {
    public static void init() {
        if (SRPConfig.allowMobs) {
            for (Biome biome : Biome.field_185377_q) {
                SRPSpawning.addSpawn(0, EntityShyco.class, 1, 1, biome, SRPConfig.shycoSpawnRate, SRPConfig.shycoEnabled);
                SRPSpawning.addSpawn(0, EntityShycoAdapted.class, 1, 1, biome, SRPConfig.shycoASpawnRate, SRPConfig.shycoEnabled);
                SRPSpawning.addSpawn(0, EntityDorpa.class, 1, 1, biome, SRPConfig.dorpaSpawnRate, SRPConfig.dorpaEnabled);
                SRPSpawning.addSpawn(0, EntityRathol.class, 2, 2, biome, SRPConfig.ratholSpawnRate, SRPConfig.ratholEnabled);
                SRPSpawning.addSpawn(0, EntityEmana.class, 2, 3, biome, SRPConfig.emanaSpawnRate, SRPConfig.emanaEnabled);
                SRPSpawning.addSpawn(0, EntityEmanaAdapted.class, 2, 3, biome, SRPConfig.emanaASpawnRate, SRPConfig.emanaEnabled);
                SRPSpawning.addSpawn(0, EntityLodo.class, 2, 5, biome, SRPConfig.lodoSpawnRate, SRPConfig.lodoEnabled);
                SRPSpawning.addSpawn(0, EntityInfHuman.class, 3, 5, biome, SRPConfig.infhumanSpawnRate, SRPConfig.infhumanEnabled);
                SRPSpawning.addSpawn(0, EntityHull.class, 4, 6, biome, SRPConfig.hullSpawnRate, SRPConfig.hullEnabled);
                SRPSpawning.addSpawn(0, EntityHullAdapted.class, 4, 6, biome, SRPConfig.hullASpawnRate, SRPConfig.hullEnabled);
                SRPSpawning.addSpawn(0, EntityCanra.class, 1, 1, biome, SRPConfig.canraSpawnRate, SRPConfig.canraEnabled);
                SRPSpawning.addSpawn(0, EntityCanraAdapted.class, 1, 1, biome, SRPConfig.canraASpawnRate, SRPConfig.canraEnabled);
                SRPSpawning.addSpawn(0, EntityAlafha.class, 1, 1, biome, SRPConfig.alafhaSpawnRate, SRPConfig.alafhaEnabled);
                SRPSpawning.addSpawn(0, EntityNogla.class, 1, 2, biome, SRPConfig.noglaSpawnRate, SRPConfig.noglaEnabled);
                SRPSpawning.addSpawn(0, EntityNoglaAdapted.class, 1, 2, biome, SRPConfig.noglaASpawnRate, SRPConfig.noglaEnabled);
                SRPSpawning.addSpawn(0, EntityButhol.class, 1, 2, biome, SRPConfig.butholSpawnRate, SRPConfig.butholEnabled);
                SRPSpawning.addSpawn(0, EntityMudo.class, 3, 6, biome, SRPConfig.mudoSpawnRate, SRPConfig.mudoEnabled);
                SRPSpawning.addSpawn(0, EntityInfCow.class, 1, 3, biome, SRPConfig.infcowSpawnRate, SRPConfig.infcowEnabled);
                SRPSpawning.addSpawn(0, EntityInfSheep.class, 1, 3, biome, SRPConfig.infsheepSpawnRate, SRPConfig.infsheepEnabled);
                SRPSpawning.addSpawn(0, EntityInfWolf.class, 3, 6, biome, SRPConfig.infwolfSpawnRate, SRPConfig.infwolfEnabled);
                SRPSpawning.addSpawn(0, EntityInfPig.class, 3, 6, biome, SRPConfig.infpigSpawnRate, SRPConfig.infpigEnabled);
                SRPSpawning.addSpawn(0, EntityInfVillager.class, 3, 6, biome, SRPConfig.infvillagerSpawnRate, SRPConfig.infvillagerEnabled);
                SRPSpawning.addSpawn(0, EntityBano.class, 1, 1, biome, SRPConfig.zetmoSpawnRate, SRPConfig.zetmoEnabled);
                SRPSpawning.addSpawn(0, EntityBanoAdapted.class, 1, 1, biome, SRPConfig.zetmoASpawnRate, SRPConfig.zetmoEnabled);
                SRPSpawning.addSpawn(0, EntityGanro.class, 1, 1, biome, SRPConfig.ganroSpawnRate, SRPConfig.ganroEnabled);
                SRPSpawning.addSpawn(0, EntityAnged.class, 2, 2, biome, SRPConfig.angedSpawnRate, SRPConfig.angedEnabled);
                SRPSpawning.addSpawn(0, EntityOronco.class, 1, 1, biome, SRPConfig.oroncoSpawnRate, SRPConfig.oroncoEnabled);
                SRPSpawning.addSpawn(0, EntityTerla.class, 1, 1, biome, SRPConfig.terlaSpawnRate, SRPConfig.terlaEnabled);
                SRPSpawning.addSpawn(1, EntityVenkrol.class, 1, 1, biome, SRPConfig.venkrolSpawnrate, SRPConfig.rsEnabled);
            }
        }
    }

    public static void addSpawn(int type, Class<? extends EntityLiving> entityclassIn, int groupCountMin, int groupCountMax, Biome biome, int weight, boolean addSpawn) {
        if (weight > 0 && addSpawn && type == 0) {
            biome.func_76747_a(EnumCreatureType.MONSTER).add(new Biome.SpawnListEntry(entityclassIn, weight, groupCountMin, groupCountMax));
        } else if (weight > 0 && addSpawn && type == 1) {
            biome.func_76747_a(EnumCreatureType.CREATURE).add(new Biome.SpawnListEntry(entityclassIn, weight, groupCountMin, groupCountMax));
        }
    }

    @Mod.EventBusSubscriber(modid="srparasites")
    public static class DimensionHandler {
        @SubscribeEvent
        public static void onSpawn(LivingSpawnEvent.CheckSpawn event) {
            if (event.getEntity() instanceof EntityParasiteBase) {
                event.setResult(Event.Result.DEFAULT);
                for (int i : SRPConfig.blackListedDimensions) {
                    if (i != event.getWorld().field_73011_w.getDimension()) continue;
                    event.setResult(Event.Result.DENY);
                    break;
                }
            }
        }
    }
}

