/*
 * Decompiled with CFR 0.152.
 */
package net.thegrimsey.stoneholm;

import java.util.HashMap;
import java.util.HashSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.thegrimsey.stoneholm.SHConfig;
import net.thegrimsey.stoneholm.SHConfiguredStructures;
import net.thegrimsey.stoneholm.SHStructures;
import net.thegrimsey.stoneholm.processors.NoWaterProcessor;

@Mod(value="stoneholm")
public class Stoneholm {
    public static final String MODID = "stoneholm";
    public static final HashSet<Biome.BiomeCategory> SPAWNABLE_BIOME_CATEGORIES = Stream.of(Biome.BiomeCategory.FOREST, Biome.BiomeCategory.JUNGLE, Biome.BiomeCategory.DESERT, Biome.BiomeCategory.PLAINS, Biome.BiomeCategory.SAVANNA).collect(Collectors.toCollection(HashSet::new));
    public static SHConfig CONFIG;
    public static StructureProcessorType<NoWaterProcessor> NOWATER_PROCESSOR;

    public Stoneholm() {
        AutoConfig.register(SHConfig.class, JanksonConfigSerializer::new);
        CONFIG = (SHConfig)AutoConfig.getConfigHolder(SHConfig.class).getConfig();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        SHStructures.STRUCTURE_DEFERRED_REGISTER.register(modEventBus);
        modEventBus.addListener(this::setup);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(EventPriority.HIGH, this::biomeModification);
        if (Stoneholm.CONFIG.disableVanillaVillages) {
            forgeBus.addListener(EventPriority.NORMAL, this::removeVanillaVillages);
        }
    }

    void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            SHStructures.registerStructureFeatures();
            SHConfiguredStructures.registerConfiguredStructures();
            Registry.m_122965_((Registry)Registry.f_122891_, (ResourceLocation)new ResourceLocation(MODID, "nowater_processor"), NOWATER_PROCESSOR);
        });
    }

    void biomeModification(BiomeLoadingEvent event) {
        if (SPAWNABLE_BIOME_CATEGORIES.contains(event.getCategory())) {
            event.getGeneration().getStructures().add(() -> SHConfiguredStructures.CONFIGURED_UNDERGROUND_VILLAGE);
        }
    }

    void removeVanillaVillages(WorldEvent.Load event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            HashMap tempMap = new HashMap(serverLevel.m_7726_().f_8328_.m_62205_().m_64590_());
            tempMap.keySet().remove(StructureFeature.f_67028_);
            serverLevel.m_7726_().f_8328_.m_62205_().f_64582_ = tempMap;
        }
    }

    static {
        NOWATER_PROCESSOR = () -> NoWaterProcessor.CODEC;
    }
}

