/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.api;

import net.minecraft.item.Item;

public interface ICatchableMob {
    default public boolean canBeCaughtWithItem(Item item2) {
        switch (item2.getRegistryName().toString()) {
            case "supplementaries:jar": {
                return this.canBeCaughtWithJar();
            }
            case "supplementaries:tinted_jar": {
                return this.canBeCaughtWithTintedJar();
            }
            case "supplementaries:cage": {
                return this.canBeCaughtWithCage();
            }
        }
        return false;
    }

    public boolean canBeCaughtWithJar();

    public boolean canBeCaughtWithTintedJar();

    public boolean canBeCaughtWithCage();

    default public float getHitBoxWidthIncrement() {
        return 0.0f;
    }

    default public float getHitBoxHeightIncrement() {
        return 0.0f;
    }

    default public int getLightLevel() {
        return 0;
    }

    default public void tickInsideCageOrJar() {
    }

    default public AnimationCategory getAnimationCategory() {
        return AnimationCategory.DEFAULT;
    }

    public static enum AnimationCategory {
        DEFAULT,
        FISH,
        LAND,
        AIR,
        FLOATING;


        public boolean isFlying() {
            return this == AIR || this == FLOATING;
        }

        public boolean isLand() {
            return this == LAND;
        }

        public boolean isFloating() {
            return this == FLOATING;
        }

        public boolean isFish() {
            return this == FISH;
        }
    }
}

