/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block;

import java.util.Arrays;
import java.util.List;
import net.mehvahdjukaar.selene.fluids.SoftFluid;
import net.mehvahdjukaar.selene.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.supplementaries.block.util.IBellConnections;
import net.minecraft.block.BlockState;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.client.model.data.ModelProperty;

public class BlockProperties {
    public static final BooleanProperty EXTENDING = BooleanProperty.func_177716_a((String)"extending");
    public static final IntegerProperty HOUR = IntegerProperty.func_177719_a((String)"hour", (int)0, (int)23);
    public static final BooleanProperty TILE = BooleanProperty.func_177716_a((String)"tile");
    public static final IntegerProperty TILE_3 = IntegerProperty.func_177719_a((String)"tile_3", (int)0, (int)2);
    public static final BooleanProperty HAS_WATER = BooleanProperty.func_177716_a((String)"has_water");
    public static final BooleanProperty HAS_JAR = BooleanProperty.func_177716_a((String)"has_jar");
    public static final IntegerProperty RECEIVING = IntegerProperty.func_177719_a((String)"laser_receiving", (int)0, (int)15);
    public static final IntegerProperty LIGHT_LEVEL_0_15 = IntegerProperty.func_177719_a((String)"light_level", (int)0, (int)15);
    public static final BooleanProperty HAS_ITEM = BooleanProperty.func_177716_a((String)"has_item");
    public static final IntegerProperty EXTENSION = IntegerProperty.func_177719_a((String)"extension", (int)0, (int)2);
    public static final EnumProperty<RopeAttachment> ATTACHMENT = EnumProperty.func_177709_a((String)"attachment", RopeAttachment.class);
    public static final EnumProperty<RopeAttachment> CONNECTION_NORTH = EnumProperty.func_177709_a((String)"north_connection", RopeAttachment.class);
    public static final EnumProperty<RopeAttachment> CONNECTION_SOUTH = EnumProperty.func_177709_a((String)"south_connection", RopeAttachment.class);
    public static final EnumProperty<RopeAttachment> CONNECTION_EAST = EnumProperty.func_177709_a((String)"east_connection", RopeAttachment.class);
    public static final EnumProperty<RopeAttachment> CONNECTION_WEST = EnumProperty.func_177709_a((String)"west_connection", RopeAttachment.class);
    public static final BooleanProperty KNOT = BooleanProperty.func_177716_a((String)"knot");
    public static final BooleanProperty TIPPED = BooleanProperty.func_177716_a((String)"tipped");
    public static final IntegerProperty PANCAKES_1_8 = IntegerProperty.func_177719_a((String)"pancakes", (int)1, (int)8);
    public static final EnumProperty<Topping> TOPPING = EnumProperty.func_177709_a((String)"topping", Topping.class);
    public static final EnumProperty<Winding> WINDING = EnumProperty.func_177709_a((String)"winding", Winding.class);
    public static final BooleanProperty FLIPPED = BooleanProperty.func_177716_a((String)"flipped");
    public static final BooleanProperty AXIS_Y = BooleanProperty.func_177716_a((String)"axis_y");
    public static final BooleanProperty AXIS_X = BooleanProperty.func_177716_a((String)"axis_x");
    public static final BooleanProperty AXIS_Z = BooleanProperty.func_177716_a((String)"axis_z");
    public static final BooleanProperty FLOOR = BooleanProperty.func_177716_a((String)"floor");
    public static final BooleanProperty LAVALOGGED = BooleanProperty.func_177716_a((String)"lavalogged");
    public static final EnumProperty<RakeDirection> RAKE_DIRECTION = EnumProperty.func_177709_a((String)"shape", RakeDirection.class);
    public static final BooleanProperty HAS_BLOCK = BooleanProperty.func_177716_a((String)"has_block");
    public static final BooleanProperty ROTATING = BooleanProperty.func_177716_a((String)"rotating");
    public static final EnumProperty<PostType> POST_TYPE = EnumProperty.func_177709_a((String)"type", PostType.class);
    public static final EnumProperty<BellAttachment> BELL_ATTACHMENT = EnumProperty.func_177709_a((String)"attachment", BellAttachment.class);
    public static final EnumProperty<IBellConnections.BellConnection> BELL_CONNECTION = EnumProperty.func_177709_a((String)"connection", IBellConnections.BellConnection.class);
    public static final IntegerProperty HONEY_LEVEL_POT = IntegerProperty.func_177719_a((String)"honey_level", (int)0, (int)4);
    public static final IntegerProperty BURNING = IntegerProperty.func_177719_a((String)"burning", (int)0, (int)8);
    public static final ModelProperty<BlockState> MIMIC = new ModelProperty();
    public static final ModelProperty<Boolean> FANCY = new ModelProperty();
    public static final ModelProperty<Boolean> FRAMED = new ModelProperty();

    public static enum BellAttachment implements IStringSerializable
    {
        CEILING("ceiling"),
        SINGLE_WALL("single_block"),
        DOUBLE_WALL("double_block");

        private final String name;

        private BellAttachment(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }

    public static enum RakeDirection implements IStringSerializable
    {
        NORTH_SOUTH("north_south", Direction.NORTH, Direction.SOUTH),
        EAST_WEST("east_west", Direction.EAST, Direction.WEST),
        SOUTH_EAST("south_east", Direction.SOUTH, Direction.EAST),
        SOUTH_WEST("south_west", Direction.SOUTH, Direction.WEST),
        NORTH_WEST("north_west", Direction.NORTH, Direction.WEST),
        NORTH_EAST("north_east", Direction.NORTH, Direction.EAST);

        private final List<Direction> directions;
        private final String name;

        private RakeDirection(String name, Direction dir1, Direction dir2) {
            this.name = name;
            this.directions = Arrays.asList(dir1, dir2);
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public List<Direction> getDirections() {
            return this.directions;
        }

        public static RakeDirection fromDirections(List<Direction> directions) {
            for (RakeDirection shape : RakeDirection.values()) {
                if (!shape.getDirections().containsAll(directions)) continue;
                return shape;
            }
            return directions.get(0).func_176740_k() == Direction.Axis.Z ? NORTH_SOUTH : EAST_WEST;
        }
    }

    public static enum Winding implements IStringSerializable
    {
        NONE("none"),
        CHAIN("chain"),
        ROPE("rope");

        private final String name;

        private Winding(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }

    public static enum Topping implements IStringSerializable
    {
        NONE("none"),
        HONEY("honey"),
        SYRUP("syrup"),
        CHOCOLATE("chocolate");

        private final String name;

        private Topping(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static Topping fromFluid(SoftFluid s) {
            if (s == SoftFluidRegistry.HONEY) {
                return HONEY;
            }
            String name = s.getRegistryName().func_110623_a();
            if (name.equals("chocolate")) {
                return CHOCOLATE;
            }
            if (name.equals("syrup") || name.equals("maple_syrup")) {
                return SYRUP;
            }
            return NONE;
        }
    }

    public static enum PostType implements IStringSerializable
    {
        POST("post"),
        PALISADE("palisade"),
        WALL("wall"),
        BEAM("beam");

        private final String name;

        private PostType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum RopeAttachment implements IStringSerializable
    {
        NONE("none"),
        BLOCK("block"),
        KNOT("knot"),
        FENCE("fence");

        private final String name;

        private RopeAttachment(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public boolean isNone() {
            return this == NONE;
        }

        public boolean isBlock() {
            return this == BLOCK;
        }

        public boolean isKnot() {
            return this == KNOT;
        }
    }
}

