/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import java.util.Random;
import java.util.TreeMap;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.EntitySelectionContext;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class FeatherBlock
extends Block {
    protected static final VoxelShape COLLISION_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);
    private static final TreeMap<Float, VoxelShape> COLLISIONS = new TreeMap<Float, VoxelShape>(){
        {
            float y;
            float i = 0.0015f;
            this.put(Float.valueOf(y - i), VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)y, (double)1.0));
            for (y = (float)COLLISION_SHAPE.func_197758_c(Direction.Axis.Y); y < 1.0f; y += i) {
                this.put(Float.valueOf(y), VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)y, (double)1.0));
                i = (float)((double)i * 1.131);
            }
            this.put(Float.valueOf(1.0f), VoxelShapes.func_197868_b());
            this.put(Float.valueOf(0.0f), VoxelShapes.func_197868_b());
        }
    };
    private final VoxelShape COLLISION_CHECK_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.1, (double)16.0);

    public FeatherBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity2, float height) {
        if (!world.field_72995_K) {
            if (height > 2.0f) {
                world.func_184133_a(null, pos, SoundEvents.field_187548_af, SoundCategory.BLOCKS, 1.0f, 0.9f);
            }
        } else {
            int i = 0;
            while ((double)i < Math.min(6.0, (double)height * 0.8)) {
                Random random = world.func_201674_k();
                double dy = MathHelper.func_151237_a((double)(0.03 * (double)height / 7.0), (double)0.03, (double)0.055);
                world.func_195594_a((IParticleData)ModRegistry.FEATHER_PARTICLE.get(), entity2.func_226277_ct_() + this.r(random, 0.35), entity2.func_226278_cu_(), entity2.func_226281_cx_() + this.r(random, 0.35), this.r(random, 0.007), dy, this.r(random, 0.007));
                ++i;
            }
        }
    }

    public void func_176216_a(IBlockReader reader, Entity entity2) {
    }

    private boolean isColliding(Entity e, BlockPos pos) {
        if (e == null) {
            return false;
        }
        VoxelShape voxelshape = this.COLLISION_CHECK_SHAPE.func_197751_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        return VoxelShapes.func_197879_c((VoxelShape)voxelshape, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)e.func_174813_aQ()), (IBooleanFunction)IBooleanFunction.field_223238_i_);
    }

    public void func_196262_a(BlockState state, World level, BlockPos blockPos, Entity entity2) {
        if (level.field_72995_K && (!(entity2 instanceof LivingEntity) || ((LivingEntity)entity2).func_213339_cH().func_203425_a((Block)this))) {
            boolean isMoving;
            Random random = level.func_201674_k();
            boolean bl = isMoving = entity2.field_70142_S != entity2.func_226277_ct_() || entity2.field_70136_U != entity2.func_226281_cx_();
            if (isMoving && random.nextInt(10) == 0) {
                double dy = 0.04;
                level.func_195594_a((IParticleData)ModRegistry.FEATHER_PARTICLE.get(), entity2.func_226277_ct_() + this.r(random, 0.15), entity2.func_226278_cu_(), entity2.func_226281_cx_() + this.r(random, 0.15), 0.0, dy, 0.0);
            }
        }
    }

    private double r(Random random, double a) {
        return a * (double)(random.nextFloat() + random.nextFloat() - 1.0f);
    }

    public ActionResultType func_225533_a_(BlockState p_225533_1_, World world, BlockPos pos, PlayerEntity p_225533_4_, Hand p_225533_5_, BlockRayTraceResult p_225533_6_) {
        return ActionResultType.PASS;
    }

    public VoxelShape func_220071_b(BlockState blockState, IBlockReader blockGetter, BlockPos blockPos, ISelectionContext collisionContext) {
        Float key;
        float dy;
        EntitySelectionContext entityCollisionContext;
        Entity entity2;
        if (collisionContext instanceof EntitySelectionContext && (entity2 = (entityCollisionContext = (EntitySelectionContext)collisionContext).getEntity()) instanceof LivingEntity && (dy = (float)(entity2.func_226278_cu_() - (double)blockPos.func_177956_o())) > 0.0f && (key = COLLISIONS.lowerKey(Float.valueOf(dy))) != null) {
            return COLLISIONS.getOrDefault(key, COLLISION_SHAPE);
        }
        return VoxelShapes.func_197868_b();
    }
}

