/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.block.blocks.LightUpBlock;
import net.mehvahdjukaar.supplementaries.block.util.ILightable;
import net.mehvahdjukaar.supplementaries.compat.CompatHandler;
import net.mehvahdjukaar.supplementaries.compat.decorativeblocks.DecoBlocksCompatRegistry;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.mehvahdjukaar.supplementaries.world.explosion.GunpowderExplosion;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.block.MagmaBlock;
import net.minecraft.block.TNTBlock;
import net.minecraft.block.TorchBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RedstoneSide;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class GunpowderBlock
extends LightUpBlock {
    public static final EnumProperty<RedstoneSide> NORTH = BlockStateProperties.field_208160_M;
    public static final EnumProperty<RedstoneSide> EAST = BlockStateProperties.field_208159_L;
    public static final EnumProperty<RedstoneSide> SOUTH = BlockStateProperties.field_208161_N;
    public static final EnumProperty<RedstoneSide> WEST = BlockStateProperties.field_208162_O;
    public static final IntegerProperty BURNING = BlockProperties.BURNING;
    public static final Map<Direction, EnumProperty<RedstoneSide>> PROPERTY_BY_DIRECTION = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, NORTH, (Object)Direction.EAST, EAST, (Object)Direction.SOUTH, SOUTH, (Object)Direction.WEST, WEST));
    private static final VoxelShape SHAPE_DOT = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    private static final Map<Direction, VoxelShape> SHAPES_FLOOR = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.func_208617_a((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)13.0), (Object)Direction.SOUTH, (Object)Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)16.0), (Object)Direction.EAST, (Object)Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)13.0), (Object)Direction.WEST, (Object)Block.func_208617_a((double)0.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0)));
    private static final Map<Direction, VoxelShape> SHAPES_UP = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)VoxelShapes.func_197872_a((VoxelShape)SHAPES_FLOOR.get(Direction.NORTH), (VoxelShape)Block.func_208617_a((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)1.0)), (Object)Direction.SOUTH, (Object)VoxelShapes.func_197872_a((VoxelShape)SHAPES_FLOOR.get(Direction.SOUTH), (VoxelShape)Block.func_208617_a((double)3.0, (double)0.0, (double)15.0, (double)13.0, (double)16.0, (double)16.0)), (Object)Direction.EAST, (Object)VoxelShapes.func_197872_a((VoxelShape)SHAPES_FLOOR.get(Direction.EAST), (VoxelShape)Block.func_208617_a((double)15.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0)), (Object)Direction.WEST, (Object)VoxelShapes.func_197872_a((VoxelShape)SHAPES_FLOOR.get(Direction.WEST), (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)3.0, (double)1.0, (double)16.0, (double)13.0))));
    private final Map<BlockState, VoxelShape> SHAPES_CACHE = Maps.newHashMap();
    private final BlockState crossState;

    private static final int getDelay() {
        return ServerConfigs.cached.GUNPOWDER_BURN_SPEED;
    }

    private static final int getSpreadAge() {
        return ServerConfigs.cached.GUNPOWDER_SPREAD_AGE;
    }

    public GunpowderBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(NORTH, (Comparable)RedstoneSide.NONE)).func_206870_a(EAST, (Comparable)RedstoneSide.NONE)).func_206870_a(SOUTH, (Comparable)RedstoneSide.NONE)).func_206870_a(WEST, (Comparable)RedstoneSide.NONE)).func_206870_a((Property)BURNING, (Comparable)Integer.valueOf(0)));
        this.crossState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(NORTH, (Comparable)RedstoneSide.SIDE)).func_206870_a(EAST, (Comparable)RedstoneSide.SIDE)).func_206870_a(SOUTH, (Comparable)RedstoneSide.SIDE)).func_206870_a(WEST, (Comparable)RedstoneSide.SIDE)).func_206870_a((Property)BURNING, (Comparable)Integer.valueOf(0));
        for (BlockState blockstate : this.func_176194_O().func_177619_a()) {
            if ((Integer)blockstate.func_177229_b((Property)BURNING) != 0) continue;
            this.SHAPES_CACHE.put(blockstate, this.calculateVoxelShape(blockstate));
        }
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{NORTH, EAST, SOUTH, WEST, BURNING});
    }

    private VoxelShape calculateVoxelShape(BlockState state) {
        VoxelShape voxelshape = SHAPE_DOT;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            RedstoneSide redstoneside = (RedstoneSide)state.func_177229_b((Property)PROPERTY_BY_DIRECTION.get(direction));
            if (redstoneside == RedstoneSide.SIDE) {
                voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)SHAPES_FLOOR.get(direction));
                continue;
            }
            if (redstoneside != RedstoneSide.UP) continue;
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)SHAPES_UP.get(direction));
        }
        return voxelshape;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.SHAPES_CACHE.get(state.func_206870_a((Property)BURNING, (Comparable)Integer.valueOf(0)));
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.getConnectionState((IBlockReader)context.func_195991_k(), this.crossState, context.func_195995_a());
    }

    @Override
    @Deprecated
    public boolean func_225541_a_(BlockState p_225541_1_, Fluid p_225541_2_) {
        return this.field_149764_J.func_76222_j() || !this.field_149764_J.func_76220_a();
    }

    private BlockState getConnectionState(IBlockReader world, BlockState state, BlockPos pos) {
        boolean flag = GunpowderBlock.isDot(state);
        state = this.getMissingConnections(world, (BlockState)this.func_176223_P().func_206870_a((Property)BURNING, state.func_177229_b((Property)BURNING)), pos);
        if (!flag || !GunpowderBlock.isDot(state)) {
            boolean flag6;
            boolean flag1 = ((RedstoneSide)state.func_177229_b(NORTH)).func_235921_b_();
            boolean flag2 = ((RedstoneSide)state.func_177229_b(SOUTH)).func_235921_b_();
            boolean flag3 = ((RedstoneSide)state.func_177229_b(EAST)).func_235921_b_();
            boolean flag4 = ((RedstoneSide)state.func_177229_b(WEST)).func_235921_b_();
            boolean flag5 = !flag1 && !flag2;
            boolean bl = flag6 = !flag3 && !flag4;
            if (!flag4 && flag5) {
                state = (BlockState)state.func_206870_a(WEST, (Comparable)RedstoneSide.SIDE);
            }
            if (!flag3 && flag5) {
                state = (BlockState)state.func_206870_a(EAST, (Comparable)RedstoneSide.SIDE);
            }
            if (!flag1 && flag6) {
                state = (BlockState)state.func_206870_a(NORTH, (Comparable)RedstoneSide.SIDE);
            }
            if (!flag2 && flag6) {
                state = (BlockState)state.func_206870_a(SOUTH, (Comparable)RedstoneSide.SIDE);
            }
        }
        return state;
    }

    private BlockState getMissingConnections(IBlockReader world, BlockState state, BlockPos pos) {
        boolean flag = !world.func_180495_p(pos.func_177984_a()).func_215686_e(world, pos);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (((RedstoneSide)state.func_177229_b((Property)PROPERTY_BY_DIRECTION.get(direction))).func_235921_b_()) continue;
            RedstoneSide redstoneside = this.getConnectingSide(world, pos, direction, flag);
            state = (BlockState)state.func_206870_a((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)redstoneside);
        }
        return state;
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState otherState, IWorld world, BlockPos pos, BlockPos otherPos) {
        RedstoneSide redstoneside;
        BlockState newState = direction == Direction.DOWN ? (this.func_196260_a(state, (IWorldReader)world, pos) ? state : Blocks.field_150350_a.func_176223_P()) : (direction == Direction.UP ? this.getConnectionState((IBlockReader)world, state, pos) : ((redstoneside = this.getConnectingSide((IBlockReader)world, pos, direction)).func_235921_b_() == ((RedstoneSide)state.func_177229_b((Property)PROPERTY_BY_DIRECTION.get(direction))).func_235921_b_() && !GunpowderBlock.isCross(state) ? (BlockState)state.func_206870_a((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)redstoneside) : this.getConnectionState((IBlockReader)world, (BlockState)((BlockState)this.crossState.func_206870_a((Property)BURNING, state.func_177229_b((Property)BURNING))).func_206870_a((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)redstoneside), pos)));
        return newState;
    }

    private static boolean isCross(BlockState state) {
        return ((RedstoneSide)state.func_177229_b(NORTH)).func_235921_b_() && ((RedstoneSide)state.func_177229_b(SOUTH)).func_235921_b_() && ((RedstoneSide)state.func_177229_b(EAST)).func_235921_b_() && ((RedstoneSide)state.func_177229_b(WEST)).func_235921_b_();
    }

    private static boolean isDot(BlockState state) {
        return !((RedstoneSide)state.func_177229_b(NORTH)).func_235921_b_() && !((RedstoneSide)state.func_177229_b(SOUTH)).func_235921_b_() && !((RedstoneSide)state.func_177229_b(EAST)).func_235921_b_() && !((RedstoneSide)state.func_177229_b(WEST)).func_235921_b_();
    }

    public void func_196248_b(BlockState state, IWorld world, BlockPos pos, int var1, int var2) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            RedstoneSide redstoneside = (RedstoneSide)state.func_177229_b((Property)PROPERTY_BY_DIRECTION.get(direction));
            if (redstoneside == RedstoneSide.NONE || world.func_180495_p((BlockPos)mutable.func_239622_a_((Vector3i)pos, direction)).func_203425_a((Block)this)) continue;
            mutable.func_189536_c(Direction.DOWN);
            BlockState blockstate = world.func_180495_p((BlockPos)mutable);
            if (!blockstate.func_203425_a(Blocks.field_190976_dk)) {
                BlockPos blockpos = mutable.func_177972_a(direction.func_176734_d());
                BlockState blockstate1 = blockstate.func_196956_a(direction.func_176734_d(), world.func_180495_p(blockpos), world, (BlockPos)mutable, blockpos);
                GunpowderBlock.func_241468_a_((BlockState)blockstate, (BlockState)blockstate1, (IWorld)world, (BlockPos)mutable, (int)var1, (int)var2);
            }
            mutable.func_239622_a_((Vector3i)pos, direction).func_189536_c(Direction.UP);
            BlockState blockstate3 = world.func_180495_p((BlockPos)mutable);
            if (blockstate3.func_203425_a(Blocks.field_190976_dk)) continue;
            BlockPos blockpos1 = mutable.func_177972_a(direction.func_176734_d());
            BlockState blockstate2 = blockstate3.func_196956_a(direction.func_176734_d(), world.func_180495_p(blockpos1), world, (BlockPos)mutable, blockpos1);
            GunpowderBlock.func_241468_a_((BlockState)blockstate3, (BlockState)blockstate2, (IWorld)world, (BlockPos)mutable, (int)var1, (int)var2);
        }
    }

    private RedstoneSide getConnectingSide(IBlockReader world, BlockPos pos, Direction dir) {
        return this.getConnectingSide(world, pos, dir, !world.func_180495_p(pos.func_177984_a()).func_215686_e(world, pos));
    }

    private RedstoneSide getConnectingSide(IBlockReader world, BlockPos pos, Direction dir, boolean canClimbUp) {
        boolean flag;
        BlockPos blockpos = pos.func_177972_a(dir);
        BlockState blockstate = world.func_180495_p(blockpos);
        if (canClimbUp && (flag = this.canSurviveOn(world, blockpos, blockstate)) && this.canConnectTo(world.func_180495_p(blockpos.func_177984_a()), world, blockpos.func_177984_a(), null)) {
            if (blockstate.func_224755_d(world, blockpos, dir.func_176734_d())) {
                return RedstoneSide.UP;
            }
            return RedstoneSide.SIDE;
        }
        return !this.canConnectTo(blockstate, world, blockpos, dir) && (blockstate.func_215686_e(world, blockpos) || !this.canConnectTo(world.func_180495_p(blockpos.func_177977_b()), world, blockpos.func_177977_b(), null)) ? RedstoneSide.NONE : RedstoneSide.SIDE;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        BlockState blockstate = world.func_180495_p(blockpos);
        return this.canSurviveOn((IBlockReader)world, blockpos, blockstate);
    }

    private boolean canSurviveOn(IBlockReader world, BlockPos pos, BlockState state) {
        return state.func_224755_d(world, pos, Direction.UP) || state.func_203425_a(Blocks.field_150438_bZ);
    }

    protected boolean canConnectTo(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction dir) {
        Block b = state.func_177230_c();
        return b instanceof ILightable || b instanceof TNTBlock || b instanceof CampfireBlock || CompatHandler.deco_blocks && DecoBlocksCompatRegistry.isBrazier(b);
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a(NORTH, state.func_177229_b(SOUTH))).func_206870_a(EAST, state.func_177229_b(WEST))).func_206870_a(SOUTH, state.func_177229_b(NORTH))).func_206870_a(WEST, state.func_177229_b(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a(NORTH, state.func_177229_b(EAST))).func_206870_a(EAST, state.func_177229_b(SOUTH))).func_206870_a(SOUTH, state.func_177229_b(WEST))).func_206870_a(WEST, state.func_177229_b(NORTH));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a(NORTH, state.func_177229_b(WEST))).func_206870_a(EAST, state.func_177229_b(NORTH))).func_206870_a(SOUTH, state.func_177229_b(EAST))).func_206870_a(WEST, state.func_177229_b(SOUTH));
            }
        }
        return state;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.func_206870_a(NORTH, state.func_177229_b(SOUTH))).func_206870_a(SOUTH, state.func_177229_b(NORTH));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.func_206870_a(EAST, state.func_177229_b(WEST))).func_206870_a(WEST, state.func_177229_b(EAST));
            }
        }
        return super.func_185471_a(state, mirror);
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean moving) {
        if (!oldState.func_203425_a(state.func_177230_c()) && !world.field_72995_K) {
            world.func_205220_G_().func_205360_a(pos, (Object)this, GunpowderBlock.getDelay());
            for (Direction direction : Direction.Plane.VERTICAL) {
                world.func_195593_d(pos.func_177972_a(direction), (Block)this);
            }
            this.updateNeighborsOfNeighboringWires(world, pos);
        }
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && !state.func_203425_a(newState.func_177230_c())) {
            super.func_196243_a(state, world, pos, newState, isMoving);
            if (!world.field_72995_K) {
                for (Direction direction : Direction.values()) {
                    world.func_195593_d(pos.func_177972_a(direction), (Block)this);
                }
                this.updateNeighborsOfNeighboringWires(world, pos);
            }
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean moving) {
        super.func_220069_a(state, world, pos, neighborBlock, neighborPos, moving);
        if (!world.field_72995_K) {
            world.func_205220_G_().func_205360_a(pos, (Object)this, GunpowderBlock.getDelay());
        }
    }

    private void updateNeighborsOfNeighboringWires(World world, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            this.checkCornerChangeAt(world, pos.func_177972_a(direction));
        }
        for (Direction direction1 : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = pos.func_177972_a(direction1);
            if (world.func_180495_p(blockpos).func_215686_e((IBlockReader)world, blockpos)) {
                this.checkCornerChangeAt(world, blockpos.func_177984_a());
                continue;
            }
            this.checkCornerChangeAt(world, blockpos.func_177977_b());
        }
    }

    private void checkCornerChangeAt(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_203425_a((Block)this)) {
            world.func_195593_d(pos, (Block)this);
            for (Direction direction : Direction.values()) {
                world.func_195593_d(pos.func_177972_a(direction), (Block)this);
            }
        }
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ActionResultType lightUp = super.func_225533_a_(state, world, pos, player, hand, hit);
        if (lightUp.func_226246_a_()) {
            return lightUp;
        }
        if (player.field_71075_bZ.field_75099_e && (GunpowderBlock.isCross(state) || GunpowderBlock.isDot(state))) {
            BlockState blockstate = GunpowderBlock.isCross(state) ? this.func_176223_P() : this.crossState;
            blockstate = (BlockState)blockstate.func_206870_a((Property)BURNING, state.func_177229_b((Property)BURNING));
            if ((blockstate = this.getConnectionState((IBlockReader)world, blockstate, pos)) != state) {
                world.func_180501_a(pos, blockstate, 3);
                this.updatesOnShapeChange(world, pos, state, blockstate);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    private void updatesOnShapeChange(World world, BlockPos pos, BlockState state, BlockState newState) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = pos.func_177972_a(direction);
            if (((RedstoneSide)state.func_177229_b((Property)PROPERTY_BY_DIRECTION.get(direction))).func_235921_b_() == ((RedstoneSide)newState.func_177229_b((Property)PROPERTY_BY_DIRECTION.get(direction))).func_235921_b_() || !world.func_180495_p(blockpos).func_215686_e((IBlockReader)world, blockpos)) continue;
            world.func_175695_a(blockpos, newState.func_177230_c(), direction.func_176734_d());
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        int burning = (Integer)state.func_177229_b((Property)BURNING);
        if (!world.field_72995_K) {
            if (burning == 8) {
                world.func_217377_a(pos, false);
                this.explode((World)world, pos);
            } else if (burning > 0) {
                if (burning >= GunpowderBlock.getSpreadAge()) {
                    this.lightUpNeighbouringWires(pos, state, (World)world);
                }
                world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)BURNING, (Comparable)Integer.valueOf(burning + 1)));
                world.func_205220_G_().func_205360_a(pos, (Object)this, GunpowderBlock.getDelay());
            } else {
                for (Direction dir : Direction.values()) {
                    BlockPos p = pos.func_177972_a(dir);
                    if (!this.isFireSource((IWorld)world, p)) continue;
                    this.lightUp(state, pos, (IWorld)world, ILightable.FireSound.FLAMING_ARROW);
                    world.func_205220_G_().func_205360_a(pos, (Object)this, GunpowderBlock.getDelay());
                    break;
                }
            }
        }
    }

    public void explode(World world, BlockPos pos) {
        GunpowderExplosion explosion = new GunpowderExplosion(world, null, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 0.5f);
        if (ForgeEventFactory.onExplosionStart((World)world, (Explosion)explosion)) {
            return;
        }
        explosion.func_77278_a();
        explosion.func_77279_a(false);
    }

    @Override
    public boolean lightUp(BlockState state, BlockPos pos, IWorld world, ILightable.FireSound sound) {
        boolean ret = super.lightUp(state, pos, world, sound);
        if (ret) {
            if (!world.func_201670_d()) {
                ((World)world).func_175641_c(pos, (Block)this, 0, 0);
            }
            world.func_205220_G_().func_205360_a(pos, (Object)this, GunpowderBlock.getDelay());
        }
        return ret;
    }

    private void lightUpByWire(BlockState state, BlockPos pos, IWorld world) {
        if (!this.isLit(state)) {
            if (!world.func_201670_d()) {
                ((World)world).func_175641_c(pos, (Block)this, 0, 0);
            }
            world.func_180501_a(pos, this.toggleLitState(state, true), 11);
            world.func_184133_a(null, pos, (SoundEvent)ModRegistry.GUNPOWDER_IGNITE.get(), SoundCategory.BLOCKS, 2.0f, 1.9f + world.func_201674_k().nextFloat() * 0.1f);
        }
    }

    protected void lightUpNeighbouringWires(BlockPos pos, BlockState state, World world) {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockState neighbourState;
            BlockPos p;
            RedstoneSide side = (RedstoneSide)state.func_177229_b((Property)PROPERTY_BY_DIRECTION.get(dir));
            if (side == RedstoneSide.UP) {
                p = pos.func_177972_a(dir).func_177984_a();
                neighbourState = world.func_180495_p(p);
            } else {
                if (side != RedstoneSide.SIDE) continue;
                p = pos.func_177972_a(dir);
                neighbourState = world.func_180495_p(p);
                if (!neighbourState.func_203425_a((Block)this) && !neighbourState.func_215686_e((IBlockReader)world, pos)) {
                    p = p.func_177977_b();
                    neighbourState = world.func_180495_p(p);
                }
            }
            if (!neighbourState.func_203425_a((Block)this)) continue;
            world.func_205220_G_().func_205360_a(p, (Object)this, Math.max(GunpowderBlock.getDelay() - 1, 1));
            this.lightUpByWire(neighbourState, p, (IWorld)world);
        }
    }

    private boolean isFireSource(IWorld world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        Block b = state.func_177230_c();
        if (b instanceof FireBlock || b instanceof MagmaBlock || b instanceof TorchBlock || b == ModRegistry.BLAZE_ROD_BLOCK.get() || b == ModRegistry.MAGMA_CREAM_BLOCK.get()) {
            return true;
        }
        if (b instanceof CampfireBlock || CompatHandler.deco_blocks && DecoBlocksCompatRegistry.isBrazier(b)) {
            return (Boolean)state.func_177229_b((Property)CampfireBlock.field_220101_b);
        }
        return world.func_204610_c(pos).func_206886_c() == Fluids.field_204547_b;
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
        if (!world.field_72995_K && this.func_196260_a(state, (IWorldReader)world, pos)) {
            this.lightUp(state, pos, (IWorld)world, ILightable.FireSound.FLAMING_ARROW);
        } else {
            super.onBlockExploded(state, world, pos, explosion);
        }
    }

    public void func_176199_a(World p_176199_1_, BlockPos p_176199_2_, Entity p_176199_3_) {
        super.func_176199_a(p_176199_1_, p_176199_2_, p_176199_3_);
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity2, float height) {
        super.func_180658_a(world, pos, entity2, height);
        if (height > 1.0f) {
            this.extinguish(world.func_180495_p(pos), pos, (IWorld)world);
        }
    }

    public int getFireSpreadSpeed(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return 60;
    }

    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return 300;
    }

    public void catchFire(BlockState state, World world, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
    }

    @Override
    public boolean isLit(BlockState state) {
        return (Integer)state.func_177229_b((Property)BURNING) != 0;
    }

    @Override
    public BlockState toggleLitState(BlockState state, boolean lit) {
        return (BlockState)state.func_206870_a((Property)BURNING, (Comparable)Integer.valueOf(lit ? 1 : 0));
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)Items.field_151016_H);
    }

    public boolean func_189539_a(BlockState state, World world, BlockPos pos, int eventID, int eventParam) {
        if (eventID == 0) {
            this.func_180655_c((BlockState)state.func_206870_a((Property)BURNING, (Comparable)Integer.valueOf(1)), world, pos, world.field_73012_v);
            return true;
        }
        return super.func_189539_a(state, world, pos, eventID, eventParam);
    }

    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        int i = (Integer)state.func_177229_b((Property)BURNING);
        if (i != 0) {
            block4: for (Direction direction : Direction.Plane.HORIZONTAL) {
                RedstoneSide redstoneside = (RedstoneSide)state.func_177229_b((Property)PROPERTY_BY_DIRECTION.get(direction));
                switch (redstoneside) {
                    case UP: {
                        this.spawnParticlesAlongLine(world, random, pos, i, direction, Direction.UP, -0.5f, 0.5f);
                    }
                    case SIDE: {
                        this.spawnParticlesAlongLine(world, random, pos, i, Direction.DOWN, direction, 0.0f, 0.5f);
                        continue block4;
                    }
                }
                this.spawnParticlesAlongLine(world, random, pos, i, Direction.DOWN, direction, 0.0f, 0.3f);
            }
        }
    }

    private void spawnParticlesAlongLine(World world, Random rand, BlockPos pos, int burning, Direction dir1, Direction dir2, float from, float to) {
        float f = to - from;
        float in = (7.5f - (float)(burning - 1)) / 7.5f;
        if (rand.nextFloat() < 1.0f * f * in) {
            float f2 = from + f * rand.nextFloat();
            double x = (double)pos.func_177958_n() + 0.5 + (double)(0.4375f * (float)dir1.func_82601_c()) + (double)(f2 * (float)dir2.func_82601_c());
            double y = (double)pos.func_177956_o() + 0.5 + (double)(0.4375f * (float)dir1.func_96559_d()) + (double)(f2 * (float)dir2.func_96559_d());
            double z = (double)pos.func_177952_p() + 0.5 + (double)(0.4375f * (float)dir1.func_82599_e()) + (double)(f2 * (float)dir2.func_82599_e());
            float velY = (float)burning / 15.0f * 0.03f;
            float velX = rand.nextFloat() * 0.02f - 0.01f;
            float velZ = rand.nextFloat() * 0.02f - 0.01f;
            world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x, y, z, (double)velX, (double)velY, (double)velZ);
            world.func_195594_a((IParticleData)ParticleTypes.field_197594_E, x, y, z, (double)velX, (double)velY, (double)velZ);
        }
    }
}

