/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.mehvahdjukaar.supplementaries.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.block.blocks.MimicBlock;
import net.mehvahdjukaar.supplementaries.block.tiles.RopeKnotBlockTile;
import net.mehvahdjukaar.supplementaries.block.util.IBlockHolder;
import net.mehvahdjukaar.supplementaries.common.ModTags;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SixWayBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.WallHeight;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class RopeKnotBlock
extends MimicBlock
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.field_208148_A;
    public static final EnumProperty<BlockProperties.PostType> POST_TYPE = BlockProperties.POST_TYPE;
    protected static final Map<Direction, BooleanProperty> FENCE_PROPERTY = (Map)SixWayBlock.field_196491_B.entrySet().stream().filter(d -> ((Direction)d.getKey()).func_176740_k().func_176722_c()).collect(Util.func_199749_a());
    protected static final Map<Direction, EnumProperty<WallHeight>> WALL_PROPERTY = ImmutableMap.of((Object)Direction.NORTH, (Object)WallBlock.field_235613_c_, (Object)Direction.SOUTH, (Object)WallBlock.field_235614_d_, (Object)Direction.WEST, (Object)WallBlock.field_235615_e_, (Object)Direction.EAST, (Object)WallBlock.field_235612_b_);
    protected static final VoxelShape SHAPE_Y = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public RopeKnotBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(AXIS, (Comparable)Direction.Axis.Y)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a(POST_TYPE, (Comparable)((Object)BlockProperties.PostType.POST)));
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        TileEntity te;
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        if ((te = world.func_175625_s(currentPos)) instanceof RopeKnotBlockTile) {
            IBlockHolder tile = (IBlockHolder)te;
            BlockState oldHeld = tile.getHeldBlock();
            BlockState newHeld = oldHeld.func_196956_a(facing, facingState, world, currentPos, facingPos);
            BlockState newFacing = facingState.func_196956_a(facing.func_176734_d(), newHeld, world, facingPos, currentPos);
            if (newFacing != facingState) {
                world.func_180501_a(facingPos, newFacing, 2);
            }
            if (newHeld != oldHeld) {
                tile.setHeldBlock(newHeld);
                te.func_70296_d();
            }
        }
        return state;
    }

    public BlockState func_185499_a(BlockState p_185499_1_, Rotation p_185499_2_) {
        switch (p_185499_2_) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)p_185499_1_.func_177229_b(AXIS)) {
                    case X: {
                        return (BlockState)p_185499_1_.func_206870_a(AXIS, (Comparable)Direction.Axis.Z);
                    }
                    case Z: {
                        return (BlockState)p_185499_1_.func_206870_a(AXIS, (Comparable)Direction.Axis.X);
                    }
                }
                return p_185499_1_;
            }
        }
        return p_185499_1_;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        boolean flag = context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a;
        return (BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof RopeKnotBlockTile) {
            return ((IBlockHolder)te).getHeldBlock().func_215700_a(world, pos, context);
        }
        return SHAPE_Y;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof RopeKnotBlockTile) {
            return ((IBlockHolder)te).getHeldBlock().func_215700_a(world, pos, context);
        }
        return SHAPE_Y;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED, POST_TYPE, AXIS});
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new RopeKnotBlockTile();
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof RopeKnotBlockTile) {
            return new ItemStack((IItemProvider)((IBlockHolder)te).getHeldBlock().func_177230_c().func_199767_j());
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public ActionResultType func_225533_a_(BlockState p_225533_1_, World world, BlockPos pos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult p_225533_6_) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof RopeKnotBlockTile) {
            ItemStack stack = playerEntity.func_184586_b(hand);
            if (stack.func_77973_b() instanceof BlockItem) {
                ((IBlockHolder)te).setHeldBlock(((BlockItem)stack.func_77973_b()).func_179223_d().func_176223_P());
            }
            te.func_70296_d();
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    public static boolean convertBlock(BlockState state, World world, BlockPos pos) {
        BlockProperties.PostType type = BlockProperties.PostType.POST;
        boolean flag = false;
        if (state.func_235714_a_(ModTags.BEAMS)) {
            type = BlockProperties.PostType.BEAM;
            flag = true;
        } else if (state.func_235714_a_(ModTags.PALISADES)) {
            type = BlockProperties.PostType.PALISADE;
            flag = true;
        } else if (state.func_235714_a_(ModTags.POSTS)) {
            type = BlockProperties.PostType.POST;
            flag = true;
        } else if (state.func_235714_a_((ITag)BlockTags.field_219757_z)) {
            type = state.func_235901_b_((Property)WallBlock.field_176256_a) && (Boolean)state.func_177229_b((Property)WallBlock.field_176256_a) != false ? BlockProperties.PostType.WALL : BlockProperties.PostType.PALISADE;
            flag = true;
        }
        if (flag) {
            Direction.Axis axis = Direction.Axis.Y;
            if (state.func_235901_b_((Property)BlockStateProperties.field_208148_A)) {
                axis = (Direction.Axis)state.func_177229_b((Property)BlockStateProperties.field_208148_A);
            }
            BlockState newState = (BlockState)((BlockState)((Block)ModRegistry.ROPE_KNOT.get()).func_176223_P().func_206870_a(AXIS, (Comparable)axis)).func_206870_a(POST_TYPE, (Comparable)((Object)type));
            world.func_175656_a(pos, newState);
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof RopeKnotBlockTile) {
                ((IBlockHolder)te).setHeldBlock(state);
                te.func_70296_d();
            }
            return true;
        }
        return false;
    }
}

