/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import net.mehvahdjukaar.supplementaries.block.blocks.NoticeBoardBlock;
import net.mehvahdjukaar.supplementaries.client.renderers.BlackboardTextureManager;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;

public class BlackboardBlockTile
extends TileEntity {
    public byte[][] pixels = new byte[16][16];
    public BlackboardTextureManager.BlackboardKey textureKey = null;

    public BlackboardBlockTile() {
        super((TileEntityType)ModRegistry.BLACKBOARD_TILE.get());
        for (int x = 0; x < this.pixels.length; ++x) {
            for (int y = 0; y < this.pixels[x].length; ++y) {
                this.pixels[x][y] = 0;
            }
        }
    }

    public boolean isEmpty() {
        boolean flag = false;
        byte[][] byArray = this.pixels;
        int n = byArray.length;
        block0: for (int i = 0; i < n; ++i) {
            byte[] pixel;
            for (byte b : pixel = byArray[i]) {
                if (b == 0) continue;
                flag = true;
                continue block0;
            }
        }
        return !flag;
    }

    public void func_70296_d() {
        if (this.field_145850_b == null) {
            return;
        }
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
        super.func_70296_d();
    }

    public void updateModelData() {
        this.textureKey = null;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.loadFromTag(compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        this.saveToTag(compound);
        return compound;
    }

    public CompoundNBT saveToTag(CompoundNBT compound) {
        compound.func_197644_a("Pixels", BlackboardBlockTile.packPixels(this.pixels));
        return compound;
    }

    public void loadFromTag(CompoundNBT compound) {
        this.pixels = new byte[16][16];
        if (compound.func_74764_b("Pixels")) {
            this.pixels = BlackboardBlockTile.unpackPixels(compound.func_197645_o("Pixels"));
        }
        if (compound.func_74764_b("pixels_0")) {
            for (int i = 0; i < 16; ++i) {
                byte[] b = compound.func_74770_j("pixels_" + i);
                if (b.length != 16) continue;
                this.pixels[i] = b;
            }
        }
    }

    public static long[] packPixels(byte[][] pixels) {
        long[] packed = new long[pixels.length];
        for (int i = 0; i < pixels.length; ++i) {
            long l = 0L;
            for (int j = 0; j < pixels[i].length; ++j) {
                l |= (long)(pixels[i][j] & 0xF) << j * 4;
            }
            packed[i] = l;
        }
        return packed;
    }

    public static byte[][] unpackPixels(long[] packed) {
        byte[][] bytes = new byte[16][16];
        for (int i = 0; i < packed.length; ++i) {
            for (int j = 0; j < 16; ++j) {
                bytes[i][j] = (byte)(packed[i] >> j * 4 & 0xFL);
            }
        }
        return bytes;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
        this.updateModelData();
    }

    public Direction getDirection() {
        return (Direction)this.func_195044_w().func_177229_b((Property)NoticeBoardBlock.FACING);
    }

    public float getYaw() {
        return -this.getDirection().func_185119_l();
    }

    public double func_145833_n() {
        return 96.0;
    }
}

