/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import java.util.Random;
import java.util.stream.IntStream;
import net.mehvahdjukaar.selene.fluids.ISoftFluidConsumer;
import net.mehvahdjukaar.selene.fluids.ISoftFluidHolder;
import net.mehvahdjukaar.selene.fluids.ISoftFluidProvider;
import net.mehvahdjukaar.selene.fluids.SoftFluid;
import net.mehvahdjukaar.selene.fluids.SoftFluidHolder;
import net.mehvahdjukaar.selene.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.supplementaries.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.block.blocks.FaucetBlock;
import net.mehvahdjukaar.supplementaries.compat.CompatHandler;
import net.mehvahdjukaar.supplementaries.compat.CompatObjects;
import net.mehvahdjukaar.supplementaries.compat.inspirations.CauldronPlugin;
import net.mehvahdjukaar.supplementaries.fluids.ModSoftFluids;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CauldronBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class FaucetBlockTile
extends TileEntity
implements ITickableTileEntity {
    private int transferCooldown = 0;
    protected final Random rand = new Random();
    public final SoftFluidHolder fluidHolder = new SoftFluidHolder(2);

    public FaucetBlockTile() {
        super((TileEntityType)ModRegistry.FAUCET_TILE.get());
    }

    public void func_70296_d() {
        if (this.field_145850_b == null) {
            return;
        }
        int light = this.fluidHolder.getFluid().getLuminosity();
        if (light != (Integer)this.func_195044_w().func_177229_b((Property)BlockProperties.LIGHT_LEVEL_0_15)) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)BlockProperties.LIGHT_LEVEL_0_15, (Comparable)Integer.valueOf(light)), 2);
        }
        super.func_70296_d();
    }

    public double func_145833_n() {
        return 80.0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v().func_177982_a(0, -1, 0), this.func_174877_v().func_177982_a(1, 1, 1));
    }

    private boolean isOnTransferCooldown() {
        return this.transferCooldown > 0;
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            boolean flag;
            if (this.isOnTransferCooldown()) {
                --this.transferCooldown;
            } else if (this.isOpen() && (flag = this.tryExtract(true))) {
                this.transferCooldown = 20;
            }
        }
    }

    public boolean updateContainedFluidVisuals(BlockState state) {
        FluidState fluidState = this.field_145850_b.func_204610_c(this.field_174879_c.func_177972_a(((Direction)state.func_177229_b((Property)FaucetBlock.FACING)).func_176734_d()));
        if (!fluidState.func_206888_e()) {
            this.fluidHolder.fill(SoftFluidRegistry.fromForgeFluid((Fluid)fluidState.func_206886_c()));
            return true;
        }
        return this.tryExtract(false);
    }

    private boolean tryExtract(boolean doTransfer) {
        Direction dir = (Direction)this.func_195044_w().func_177229_b((Property)FaucetBlock.FACING);
        BlockPos behind = this.field_174879_c.func_177972_a(dir.func_176734_d());
        BlockState backState = this.field_145850_b.func_180495_p(behind);
        Block backBlock = backState.func_177230_c();
        if (backBlock instanceof ISoftFluidProvider) {
            ISoftFluidProvider provider = (ISoftFluidProvider)backBlock;
            Pair stack = provider.getProvidedFluid(this.field_145850_b, backState, behind);
            this.fluidHolder.fill((SoftFluid)stack.getLeft(), (CompoundNBT)stack.getRight());
            if (doTransfer && this.tryFillingBlockBelow()) {
                provider.consumeProvidedFluid(this.field_145850_b, backState, behind, this.fluidHolder.getFluid(), this.fluidHolder.getNbt(), 1);
                return true;
            }
        } else {
            if (backState.func_235901_b_((Property)BlockStateProperties.field_227036_ao_)) {
                if ((Integer)backState.func_177229_b((Property)BlockStateProperties.field_227036_ao_) == 5) {
                    this.fluidHolder.fill(SoftFluidRegistry.HONEY);
                    if (doTransfer && this.tryFillingBlockBelow()) {
                        this.field_145850_b.func_180501_a(behind, (BlockState)backState.func_206870_a((Property)BlockStateProperties.field_227036_ao_, (Comparable)Integer.valueOf((Integer)backState.func_177229_b((Property)BlockStateProperties.field_227036_ao_) - 1)), 3);
                        return true;
                    }
                }
                return false;
            }
            if (CompatHandler.buzzier_bees && backState.func_235901_b_((Property)BlockProperties.HONEY_LEVEL_POT)) {
                if ((Integer)backState.func_177229_b((Property)BlockProperties.HONEY_LEVEL_POT) > 0) {
                    this.fluidHolder.fill(SoftFluidRegistry.HONEY);
                    if (doTransfer && this.tryFillingBlockBelow()) {
                        this.field_145850_b.func_180501_a(behind, (BlockState)backState.func_206870_a((Property)BlockProperties.HONEY_LEVEL_POT, (Comparable)Integer.valueOf((Integer)backState.func_177229_b((Property)BlockProperties.HONEY_LEVEL_POT) - 1)), 3);
                        return true;
                    }
                }
                return false;
            }
            if (CompatHandler.autumnity && (backBlock == CompatObjects.SAPPY_MAPLE_LOG.get() || backBlock == CompatObjects.SAPPY_MAPLE_WOOD.get())) {
                this.fluidHolder.fill(ModSoftFluids.SAP);
                if (doTransfer && this.tryFillingBlockBelow()) {
                    Block log = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(backBlock.getRegistryName().toString().replace("sappy", "stripped")));
                    if (log != null) {
                        this.field_145850_b.func_180501_a(behind, (BlockState)log.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208148_A, backState.func_177229_b((Property)BlockStateProperties.field_208148_A)), 3);
                    }
                    return true;
                }
            } else {
                if (backBlock instanceof CauldronBlock) {
                    if ((Integer)backState.func_177229_b((Property)BlockStateProperties.field_208130_ae) > 0) {
                        TileEntity cauldronTile = this.field_145850_b.func_175625_s(behind);
                        if (cauldronTile == null) {
                            this.fluidHolder.fill(SoftFluidRegistry.WATER);
                            if (doTransfer && this.tryFillingBlockBelow()) {
                                this.field_145850_b.func_180501_a(behind, (BlockState)backState.func_206870_a((Property)BlockStateProperties.field_208130_ae, (Comparable)Integer.valueOf((Integer)backState.func_177229_b((Property)BlockStateProperties.field_208130_ae) - 1)), 3);
                                return true;
                            }
                        } else if (CompatHandler.inspirations) {
                            return CauldronPlugin.doStuff(cauldronTile, this.fluidHolder, doTransfer, this::tryFillingBlockBelow);
                        }
                    }
                    return false;
                }
                TileEntity tileBack = this.field_145850_b.func_175625_s(behind);
                if (tileBack instanceof ISoftFluidHolder && ((ISoftFluidHolder)tileBack).canInteractWithFluidHolder()) {
                    SoftFluidHolder fluidHolder = ((ISoftFluidHolder)tileBack).getSoftFluidHolder();
                    this.fluidHolder.copy(fluidHolder);
                    if (doTransfer && this.tryFillingBlockBelow()) {
                        fluidHolder.shrink(1);
                        tileBack.func_70296_d();
                        return true;
                    }
                } else {
                    IFluidHandler handlerBack = (IFluidHandler)FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)behind, (Direction)dir).orElse(null);
                    if (handlerBack != null) {
                        this.fluidHolder.copy(handlerBack);
                        if (doTransfer && this.tryFillingBlockBelow()) {
                            handlerBack.drain(250, IFluidHandler.FluidAction.EXECUTE);
                            tileBack.func_70296_d();
                            return true;
                        }
                    } else if (this.field_145850_b.func_204610_c(behind).func_206886_c() == Fluids.field_204546_a) {
                        this.fluidHolder.fill(SoftFluidRegistry.WATER);
                        return true;
                    }
                }
            }
        }
        if (!doTransfer) {
            return !this.fluidHolder.isEmpty();
        }
        return this.pullItems();
    }

    private boolean tryFillingBlockBelow() {
        TileEntity tileBelow;
        BlockPos below = this.field_174879_c.func_177977_b();
        BlockState belowState = this.field_145850_b.func_180495_p(below);
        Block belowBlock = belowState.func_177230_c();
        SoftFluid softFluid = this.fluidHolder.getFluid();
        if (belowBlock instanceof ISoftFluidConsumer) {
            ISoftFluidConsumer consumer = (ISoftFluidConsumer)belowBlock;
            return consumer.tryAcceptingFluid(this.field_145850_b, belowState, below, softFluid, this.fluidHolder.getNbt(), 1);
        }
        if (softFluid == SoftFluidRegistry.HONEY) {
            if (belowState.func_235901_b_((Property)BlockStateProperties.field_227036_ao_)) {
                int h = (Integer)belowState.func_177229_b((Property)BlockStateProperties.field_227036_ao_);
                if (h == 0) {
                    this.field_145850_b.func_180501_a(below, (BlockState)belowState.func_206870_a((Property)BlockStateProperties.field_227036_ao_, (Comparable)Integer.valueOf(5)), 3);
                    return true;
                }
                return false;
            }
            if (CompatHandler.buzzier_bees && belowState.func_235901_b_((Property)BlockProperties.HONEY_LEVEL_POT)) {
                int h = (Integer)belowState.func_177229_b((Property)BlockProperties.HONEY_LEVEL_POT);
                if (h < 4) {
                    this.field_145850_b.func_180501_a(below, (BlockState)belowState.func_206870_a((Property)BlockProperties.HONEY_LEVEL_POT, (Comparable)Integer.valueOf(h + 1)), 3);
                    return true;
                }
                return false;
            }
        } else {
            if (softFluid == SoftFluidRegistry.XP && belowState.func_196958_f()) {
                this.dropXP();
                return true;
            }
            if (belowState.func_177230_c() instanceof CauldronBlock) {
                int levels = (Integer)belowState.func_177229_b((Property)BlockStateProperties.field_208130_ae);
                if (levels < 3) {
                    TileEntity cauldronTile = this.field_145850_b.func_175625_s(below);
                    if (cauldronTile == null) {
                        this.field_145850_b.func_180501_a(below, (BlockState)belowState.func_206870_a((Property)BlockStateProperties.field_208130_ae, (Comparable)Integer.valueOf(levels + 1)), 3);
                        return true;
                    }
                    if (CompatHandler.inspirations) {
                        return CauldronPlugin.tryAddFluid(cauldronTile, this.fluidHolder);
                    }
                }
                return false;
            }
        }
        if ((tileBelow = this.field_145850_b.func_175625_s(below)) instanceof ISoftFluidHolder) {
            SoftFluidHolder fluidHolder = ((ISoftFluidHolder)tileBelow).getSoftFluidHolder();
            boolean result = this.fluidHolder.tryTransferFluid(fluidHolder);
            if (result) {
                tileBelow.func_70296_d();
                this.fluidHolder.fillCount();
            }
            return result;
        }
        IFluidHandler handlerDown = (IFluidHandler)FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)below, (Direction)Direction.UP).orElse(null);
        if (handlerDown != null) {
            boolean result = this.fluidHolder.tryTransferToFluidTank(handlerDown);
            if (result) {
                tileBelow.func_70296_d();
                this.fluidHolder.fillCount();
            }
            return result;
        }
        return false;
    }

    private void dropXP() {
        int xp;
        for (int i = 3 + this.field_145850_b.field_73012_v.nextInt(5) + this.field_145850_b.field_73012_v.nextInt(5); i > 0; i -= xp) {
            xp = ExperienceOrbEntity.func_70527_a((int)i);
            ExperienceOrbEntity orb = new ExperienceOrbEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)((float)this.field_174879_c.func_177956_o() - 0.125f), (double)this.field_174879_c.func_177952_p() + 0.5, xp);
            orb.func_213317_d(new Vector3d(0.0, 0.0, 0.0));
            this.field_145850_b.func_217376_c((Entity)orb);
        }
        float f = (this.rand.nextFloat() - 0.5f) / 4.0f;
        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187665_Y, SoundCategory.BLOCKS, 0.3f, 0.5f + f);
    }

    public boolean isOpen() {
        return (Boolean)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208194_u) ^ (Boolean)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208180_g);
    }

    public boolean hasWater() {
        return (Boolean)this.func_195044_w().func_177229_b((Property)FaucetBlock.HAS_WATER);
    }

    public boolean isConnectedBelow() {
        return (Boolean)this.func_195044_w().func_177229_b((Property)FaucetBlock.HAS_JAR);
    }

    private static boolean canExtractItemFromSlot(IInventory inventoryIn, ItemStack stack, int index, Direction side) {
        return !(inventoryIn instanceof ISidedInventory) || ((ISidedInventory)inventoryIn).func_180461_b(index, stack, side);
    }

    private boolean pullItemFromSlot(IInventory inventoryIn, int index, Direction direction) {
        ItemStack itemstack = inventoryIn.func_70301_a(index);
        if (this.isConnectedBelow()) {
            return false;
        }
        if (!itemstack.func_190926_b() && FaucetBlockTile.canExtractItemFromSlot(inventoryIn, itemstack, index, direction)) {
            ItemStack it = itemstack.func_77946_l();
            itemstack.func_190918_g(1);
            inventoryIn.func_70296_d();
            it.func_190920_e(1);
            ItemEntity drop = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, it);
            drop.func_213317_d(new Vector3d(0.0, 0.0, 0.0));
            this.field_145850_b.func_217376_c((Entity)drop);
            float f = (this.rand.nextFloat() - 0.5f) / 4.0f;
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187665_Y, SoundCategory.BLOCKS, 0.3f, 0.5f + f);
            return true;
        }
        return false;
    }

    public boolean pullItems() {
        IInventory iinventory = this.getSourceInventory();
        if (iinventory != null) {
            Direction direction = (Direction)this.func_195044_w().func_177229_b((Property)HorizontalBlock.field_185512_D);
            return FaucetBlockTile.getSlots(iinventory, direction).anyMatch(p_213971_3_ -> this.pullItemFromSlot(iinventory, p_213971_3_, direction));
        }
        return false;
    }

    public IInventory getSourceInventory() {
        BlockPos behind = this.field_174879_c.func_177967_a((Direction)this.func_195044_w().func_177229_b((Property)HorizontalBlock.field_185512_D), -1);
        IInventory firstinv = HopperTileEntity.func_195484_a((World)this.func_145831_w(), (BlockPos)behind);
        if (firstinv != null) {
            return firstinv;
        }
        if (this.field_145850_b.func_180495_p(behind).func_215686_e((IBlockReader)this.field_145850_b, this.field_174879_c)) {
            return HopperTileEntity.func_195484_a((World)this.func_145831_w(), (BlockPos)this.field_174879_c.func_177967_a((Direction)this.func_195044_w().func_177229_b((Property)HorizontalBlock.field_185512_D), -2));
        }
        return null;
    }

    private static IntStream getSlots(IInventory inv, Direction dir) {
        return inv instanceof ISidedInventory ? IntStream.of(((ISidedInventory)inv).func_180463_a(dir)) : IntStream.range(0, inv.func_70302_i_());
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.transferCooldown = compound.func_74762_e("TransferCooldown");
        this.fluidHolder.load(compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("TransferCooldown", this.transferCooldown);
        this.fluidHolder.save(compound);
        return compound;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }
}

