/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.blocks.ItemDisplayTile;
import net.mehvahdjukaar.supplementaries.block.blocks.HourGlassBlock;
import net.mehvahdjukaar.supplementaries.common.ModTags;
import net.mehvahdjukaar.supplementaries.common.Textures;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;

public class HourGlassBlockTile
extends ItemDisplayTile
implements ITickableTileEntity {
    public HourGlassSandType sandType = HourGlassSandType.DEFAULT;
    public float progress = 0.0f;
    public float prevProgress = 0.0f;
    public int power = 0;
    private TextureAtlasSprite cachedTexture = null;

    public HourGlassBlockTile() {
        super((TileEntityType)ModRegistry.HOURGLASS_TILE.get());
    }

    public void func_70296_d() {
        if (this.field_145850_b == null) {
            return;
        }
        this.updateTile();
        super.func_70296_d();
    }

    public void updateTile() {
        this.sandType = HourGlassSandType.getHourGlassSandType(this.getDisplayedItem().func_77973_b());
        boolean p = this.getDirection() == Direction.DOWN;
        int l = this.sandType.getLight();
        if (l != (Integer)this.func_195044_w().func_177229_b((Property)HourGlassBlock.LIGHT_LEVEL)) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)HourGlassBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(l)), 20);
        }
        this.prevProgress = (float)p;
        this.progress = (float)p;
    }

    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getOrCreateSprite() {
        if (this.cachedTexture == null) {
            this.cachedTexture = this.sandType.getSprite(this.getDisplayedItem(), this.field_145850_b);
        }
        return this.cachedTexture;
    }

    public double func_145833_n() {
        return 48.0;
    }

    public void func_73660_a() {
        int p;
        Direction dir = this.getDirection();
        if (!this.sandType.isEmpty()) {
            this.prevProgress = this.progress;
            if (dir == Direction.UP && this.progress != 1.0f) {
                this.progress = Math.min(this.progress + this.sandType.increment, 1.0f);
            } else if (dir == Direction.DOWN && this.progress != 0.0f) {
                this.progress = Math.max(this.progress - this.sandType.increment, 0.0f);
            }
        }
        if (!this.field_145850_b.field_72995_K && (p = dir == Direction.DOWN ? (int)((1.0f - this.progress) * 15.0f) : (int)(this.progress * 15.0f)) != this.power) {
            this.power = p;
            this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        int i = compound.func_74762_e("SandType");
        this.sandType = HourGlassSandType.values()[Math.min(i, HourGlassSandType.values().length)];
        this.progress = compound.func_74760_g("Progress");
        this.prevProgress = compound.func_74760_g("PrevProgress");
        this.cachedTexture = null;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("SandType", this.sandType.ordinal());
        compound.func_74776_a("Progress", this.progress);
        compound.func_74776_a("PrevProgress", this.prevProgress);
        return compound;
    }

    public ITextComponent func_213907_g() {
        return new TranslationTextComponent("block.supplementaries.hourglass");
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.func_191420_l() && !HourGlassSandType.getHourGlassSandType(stack.func_77973_b()).isEmpty();
    }

    public int[] func_180463_a(Direction side) {
        return IntStream.range(0, this.func_70302_i_()).toArray();
    }

    public boolean func_180462_a(int index, ItemStack stack, @Nullable Direction direction) {
        if (direction == Direction.UP) {
            return this.func_94041_b(0, stack);
        }
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        Direction dir = (Direction)this.func_195044_w().func_177229_b((Property)HourGlassBlock.FACING);
        return dir == Direction.UP && this.progress == 1.0f || dir == Direction.DOWN && this.progress == 0.0f;
    }

    public Direction getDirection() {
        return (Direction)this.func_195044_w().func_177229_b((Property)HourGlassBlock.FACING);
    }

    public static enum HourGlassSandType {
        DEFAULT(null, null, 0),
        SAND(Textures.SAND_TEXTURE, null, (Integer)ServerConfigs.block.HOURGLASS_SAND.get()),
        CONCRETE(Textures.WHITE_CONCRETE_TEXTURE, null, (Integer)ServerConfigs.block.HOURGLASS_CONCRETE.get()),
        GUNPOWDER(Textures.HOURGLASS_GUNPOWDER, Items.field_151016_H, (Integer)ServerConfigs.block.HOURGLASS_DUST.get()),
        SUGAR(Textures.HOURGLASS_SUGAR, Items.field_151102_aT, (Integer)ServerConfigs.block.HOURGLASS_SUGAR.get()),
        GLOWSTONE_DUST(Textures.HOURGLASS_GLOWSTONE, Items.field_151114_aO, (Integer)ServerConfigs.block.HOURGLASS_GLOWSTONE.get()),
        REDSTONE_DUST(Textures.HOURGLASS_REDSTONE, Items.field_151137_ax, (Integer)ServerConfigs.block.HOURGLASS_REDSTONE.get()),
        BLAZE_POWDER(Textures.HOURGLASS_BLAZE, Items.field_151065_br, (Integer)ServerConfigs.block.HOURGLASS_BLAZE_POWDER.get()),
        FORGE_DUST(Textures.HOURGLASS_GUNPOWDER, null, (Integer)ServerConfigs.block.HOURGLASS_DUST.get()),
        HONEY(Textures.HONEY_TEXTURE, Items.field_226638_pX_, (Integer)ServerConfigs.block.HOURGLASS_HONEY.get()),
        SLIME(Textures.SLIME_TEXTURE, Items.field_151123_aH, (Integer)ServerConfigs.block.HOURGLASS_SLIME.get());

        @Nullable
        public final ResourceLocation texture;
        @Nullable
        public final Item item;
        public final float increment;

        private HourGlassSandType(ResourceLocation texture, Item item2, int t) {
            this.texture = texture;
            this.item = item2;
            this.increment = 1.0f / (float)t;
        }

        public boolean isEmpty() {
            return this == DEFAULT;
        }

        public int getLight() {
            if (this == GLOWSTONE_DUST) {
                return 9;
            }
            if (this == BLAZE_POWDER) {
                return 6;
            }
            return 0;
        }

        public TextureAtlasSprite getSprite(ItemStack i, World world) {
            Minecraft mc = Minecraft.func_71410_x();
            if (this == FORGE_DUST || this == SAND || this == CONCRETE) {
                ItemRenderer itemRenderer = mc.func_175599_af();
                IBakedModel ibakedmodel = itemRenderer.func_184393_a(i, world, null);
                TextureAtlasSprite sprite = ibakedmodel.func_177554_e();
                if (sprite instanceof MissingTextureSprite) {
                    sprite = (TextureAtlasSprite)mc.func_228015_a_(AtlasTexture.field_110575_b).apply(this.texture);
                }
                return sprite;
            }
            return (TextureAtlasSprite)mc.func_228015_a_(AtlasTexture.field_110575_b).apply(this.texture);
        }

        public static HourGlassSandType getHourGlassSandType(Item i) {
            if (i instanceof BlockItem) {
                Block b = ((BlockItem)i).func_179223_d();
                if (b.func_203417_a((ITag)Tags.Blocks.SAND)) {
                    return SAND;
                }
                if (b.func_203417_a(ModTags.CONCRETE_POWDERS)) {
                    return CONCRETE;
                }
            }
            for (HourGlassSandType n : HourGlassSandType.values()) {
                if (n.item != i) continue;
                return n;
            }
            if (i.func_206844_a((ITag)Tags.Items.DUSTS)) {
                return FORGE_DUST;
            }
            return DEFAULT;
        }
    }
}

