/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.blocks.ItemDisplayTile;
import net.mehvahdjukaar.supplementaries.block.blocks.NoticeBoardBlock;
import net.mehvahdjukaar.supplementaries.block.tiles.FlagBlockTile;
import net.mehvahdjukaar.supplementaries.block.util.IMapDisplay;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.inventories.NoticeBoardContainer;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BannerPatternItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.WritableBookItem;
import net.minecraft.item.WrittenBookItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.INameable;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class NoticeBoardBlockTile
extends ItemDisplayTile
implements INameable,
IMapDisplay {
    private String text = null;
    private int fontScale = 1;
    private List<IReorderingProcessor> cachedPageLines = Collections.emptyList();
    private boolean inventoryChanged = true;
    private ResourceLocation cachedPattern = null;
    private int pageNumber = 0;
    private DyeColor textColor = DyeColor.BLACK;
    private boolean textVisible = true;

    public NoticeBoardBlockTile() {
        super((TileEntityType)ModRegistry.NOTICE_BOARD_TILE.get());
    }

    public ITextComponent func_213907_g() {
        return new TranslationTextComponent("block.supplementaries.notice_board");
    }

    public void updateOnChangedBeforePacket() {
        super.updateOnChangedBeforePacket();
        boolean b = !this.getDisplayedItem().func_190926_b();
        BlockState state = this.func_195044_w();
        if ((Boolean)state.func_177229_b((Property)BlockStateProperties.field_222515_o) != b) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_222515_o, (Comparable)Boolean.valueOf(b)), 2);
            if (b) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_219617_ah, SoundCategory.BLOCKS, 1.0f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.85f);
            } else {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_219617_ah, SoundCategory.BLOCKS, 1.0f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.5f);
            }
        }
    }

    @Override
    public ItemStack getMapStack() {
        return this.getDisplayedItem();
    }

    public void updateClientVisualsOnLoad() {
        CompoundNBT com;
        ItemStack itemstack = this.getDisplayedItem();
        Item item2 = itemstack.func_77973_b();
        this.cachedPattern = null;
        if (item2 instanceof BannerPatternItem) {
            this.cachedPattern = FlagBlockTile.getFlagLocation(((BannerPatternItem)item2).func_219980_b());
        }
        this.inventoryChanged = true;
        this.cachedPageLines = Collections.emptyList();
        this.text = null;
        if (item2 instanceof WrittenBookItem) {
            CompoundNBT com2 = itemstack.func_77978_p();
            if (WrittenBookItem.func_77828_a((CompoundNBT)com2)) {
                ListNBT listnbt = com2.func_150295_c("pages", 8).func_74737_b();
                this.text = listnbt.func_150307_f(0);
            }
        } else if (item2 instanceof WritableBookItem && WritableBookItem.func_150930_a((CompoundNBT)(com = itemstack.func_77978_p()))) {
            ListNBT listnbt = com.func_150295_c("pages", 8).func_74737_b();
            this.text = listnbt.func_150307_f(0);
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.textColor = DyeColor.func_204271_a((String)compound.func_74779_i("Color"), (DyeColor)DyeColor.BLACK);
        this.textVisible = compound.func_74767_n("TextVisible");
        super.func_230337_a_(state, compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74778_a("Color", this.textColor.func_176762_d());
        compound.func_74757_a("TextVisible", this.textVisible);
        return compound;
    }

    public Container func_213906_a(int id, PlayerInventory player) {
        return new NoticeBoardContainer(id, player, (IInventory)this);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.func_191420_l() && (ServerConfigs.cached.NOTICE_BOARDS_UNRESTRICTED || NoticeBoardBlockTile.isPageItem(stack.func_77973_b()));
    }

    public static boolean isPageItem(Item item2) {
        return ItemTags.field_226160_P_ != null && item2.func_206844_a((ITag)ItemTags.field_226160_P_) || item2 instanceof FilledMapItem || item2 instanceof BannerPatternItem;
    }

    public boolean func_180462_a(int index, ItemStack stack, @Nullable Direction direction) {
        return this.func_94041_b(index, stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public DyeColor getTextColor() {
        return this.textColor;
    }

    public boolean setTextColor(DyeColor newColor) {
        if (newColor != this.getTextColor()) {
            this.textColor = newColor;
            return true;
        }
        return false;
    }

    public boolean isTextVisible() {
        return this.textVisible;
    }

    public void setTextVisible(boolean textVisible) {
        this.textVisible = textVisible;
    }

    public ResourceLocation getCachedPattern() {
        return this.cachedPattern;
    }

    public String getText() {
        return this.text;
    }

    public int getFontScale() {
        return this.fontScale;
    }

    public void setFontScale(int s) {
        this.fontScale = s;
    }

    public void setChachedPageLines(List<IReorderingProcessor> l) {
        this.cachedPageLines = l;
    }

    public List<IReorderingProcessor> getCachedPageLines() {
        return this.cachedPageLines;
    }

    public boolean getFlag() {
        if (this.inventoryChanged) {
            this.inventoryChanged = false;
            return true;
        }
        return false;
    }

    public Direction getDirection() {
        return (Direction)this.func_195044_w().func_177229_b((Property)NoticeBoardBlock.FACING);
    }
}

