/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.block.blocks.PresentBlock;
import net.mehvahdjukaar.supplementaries.common.CommonUtil;
import net.mehvahdjukaar.supplementaries.inventories.PresentContainer;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class PresentBlockTile
extends LockableLootTileEntity
implements ISidedInventory,
ICapabilityProvider {
    private NonNullList<ItemStack> items = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
    private int numPlayersUsing;
    private String recipient = null;
    private String sender = null;
    private boolean packed = false;
    private final LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])Direction.values());

    public PresentBlockTile() {
        super((TileEntityType)ModRegistry.PRESENT_TILE.get());
    }

    public boolean isUnused() {
        return this.numPlayersUsing <= 0;
    }

    public static boolean isPacked(ItemStack stack) {
        CompoundNBT nbt;
        CompoundNBT com = stack.func_77978_p();
        if (com != null && (nbt = com.func_74775_l("BlockEntityTag")) != null) {
            return nbt.func_74767_n("Packed");
        }
        return false;
    }

    public boolean isPacked() {
        return this.packed;
    }

    public void unpack() {
        this.recipient = null;
        this.sender = null;
        this.packed = false;
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)PresentBlock.OPEN, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public void pack(String recipient, String sender, boolean doPack) {
        this.recipient = recipient;
        this.sender = sender;
        this.packed = doPack;
        if (doPack && !this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)PresentBlock.OPEN, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public void pack(String recipient, String sender) {
        this.pack(recipient, sender, true);
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public ITextComponent func_213907_g() {
        return new TranslationTextComponent("block.supplementaries.present");
    }

    public void func_174889_b(PlayerEntity player) {
        if (!player.func_175149_v()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
        }
    }

    public void func_174886_c(PlayerEntity player) {
        if (!player.func_175149_v()) {
            --this.numPlayersUsing;
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.loadFromTag(nbt);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        return this.saveToTag(compound);
    }

    public void loadFromTag(CompoundNBT tag) {
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (!this.func_184283_b(tag) && tag.func_150297_b("Items", 9)) {
            ItemStackHelper.func_191283_b((CompoundNBT)tag, this.items);
        }
        if (tag.func_74764_b("Recipient")) {
            this.recipient = tag.func_74779_i("Recipient");
        }
        if (tag.func_74764_b("Sender")) {
            this.sender = tag.func_74779_i("Sender");
        }
        this.packed = tag.func_74767_n("Packed");
    }

    public CompoundNBT saveToTag(CompoundNBT tag) {
        if (!this.func_184282_c(tag)) {
            ItemStackHelper.func_191281_a((CompoundNBT)tag, this.items, (boolean)false);
        }
        if (this.recipient != null) {
            tag.func_74778_a("Recipient", this.recipient);
        }
        if (this.sender != null) {
            tag.func_74778_a("Sender", this.sender);
        }
        tag.func_74757_a("Packed", this.packed);
        return tag;
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.items;
    }

    protected void func_199721_a(NonNullList<ItemStack> itemsIn) {
        this.items = itemsIn;
    }

    public Container func_213906_a(int id, PlayerInventory player) {
        return new PresentContainer(id, player, (IInventory)this, this.field_174879_c);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return CommonUtil.isAllowedInShulker(stack);
    }

    public int[] func_180463_a(Direction side) {
        return IntStream.range(0, this.func_70302_i_()).toArray();
    }

    public boolean func_180462_a(int index, ItemStack stack, @Nullable Direction direction) {
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return false;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handlers[facing.ordinal()].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }
}

