/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.blocks.ItemDisplayTile;
import net.mehvahdjukaar.supplementaries.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.block.blocks.PulleyBlock;
import net.mehvahdjukaar.supplementaries.block.blocks.RopeBlock;
import net.mehvahdjukaar.supplementaries.common.ModTags;
import net.mehvahdjukaar.supplementaries.inventories.PulleyBlockContainer;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChainBlock;
import net.minecraft.block.SoundType;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class PulleyBlockTile
extends ItemDisplayTile {
    public PulleyBlockTile() {
        super((TileEntityType)ModRegistry.PULLEY_BLOCK_TILE.get());
    }

    public void updateOnChangedBeforePacket() {
    }

    public void func_70296_d() {
        if (this.field_145850_b == null) {
            return;
        }
        this.updateTile();
        super.func_70296_d();
    }

    public void updateTile() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        BlockProperties.Winding type = PulleyBlockTile.getContentType(this.getDisplayedItem().func_77973_b());
        BlockState state = this.func_195044_w();
        if (state.func_177229_b(PulleyBlock.TYPE) != type) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a(PulleyBlock.TYPE, (Comparable)((Object)type)));
        }
    }

    public static BlockProperties.Winding getContentType(Item item2) {
        BlockProperties.Winding type = BlockProperties.Winding.NONE;
        if (item2 instanceof BlockItem && ((BlockItem)item2).func_179223_d() instanceof ChainBlock || item2.func_206844_a(ModTags.CHAINS)) {
            type = BlockProperties.Winding.CHAIN;
        } else if (item2.func_206844_a(ModTags.ROPES)) {
            type = BlockProperties.Winding.ROPE;
        }
        return type;
    }

    public ITextComponent func_213907_g() {
        return new TranslationTextComponent("block.supplementaries.pulley_block");
    }

    public Container func_213906_a(int id, PlayerInventory player) {
        return new PulleyBlockContainer(id, player, (IInventory)this);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return PulleyBlockTile.getContentType(stack.func_77973_b()) != BlockProperties.Winding.NONE;
    }

    public boolean func_180462_a(int index, ItemStack stack, @Nullable Direction direction) {
        return this.func_94041_b(index, stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean handleRotation(Rotation rot) {
        if (rot == Rotation.CLOCKWISE_90) {
            return this.pullUp(this.field_174879_c, (IWorld)this.field_145850_b, 1);
        }
        return this.pullDown(this.field_174879_c, (IWorld)this.field_145850_b, 1);
    }

    public boolean pullUp(BlockPos pos, IWorld world, int rot) {
        if (!(world instanceof World)) {
            return false;
        }
        ItemStack stack = this.getDisplayedItem();
        boolean addNewItem = false;
        if (stack.func_190926_b()) {
            Item i = world.func_180495_p(pos.func_177977_b()).func_177230_c().func_199767_j();
            if (PulleyBlockTile.getContentType(i) == BlockProperties.Winding.NONE) {
                return false;
            }
            stack = new ItemStack((IItemProvider)i);
            addNewItem = true;
        }
        if (stack.func_190916_E() + rot > stack.func_77976_d() || !(stack.func_77973_b() instanceof BlockItem)) {
            return false;
        }
        Block ropeBlock = ((BlockItem)stack.func_77973_b()).func_179223_d();
        boolean success = RopeBlock.removeRope(pos.func_177977_b(), (World)world, ropeBlock);
        if (success) {
            SoundType soundtype = ropeBlock.func_176223_P().getSoundType((IWorldReader)world, pos, null);
            world.func_184133_a(null, pos, soundtype.func_185845_c(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            if (addNewItem) {
                this.setDisplayedItem(stack);
            } else {
                stack.func_190917_f(1);
            }
            this.func_70296_d();
        }
        return success;
    }

    public boolean pullDown(BlockPos pos, IWorld world, int rot) {
        if (!(world instanceof World)) {
            return false;
        }
        ItemStack stack = this.getDisplayedItem();
        if (stack.func_190916_E() < rot || !(stack.func_77973_b() instanceof BlockItem)) {
            return false;
        }
        Block ropeBlock = ((BlockItem)stack.func_77973_b()).func_179223_d();
        boolean success = RopeBlock.addRope(pos.func_177977_b(), (World)world, null, Hand.MAIN_HAND, ropeBlock);
        if (success) {
            SoundType soundtype = ropeBlock.func_176223_P().getSoundType((IWorldReader)world, pos, null);
            world.func_184133_a(null, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            stack.func_190918_g(1);
            this.func_70296_d();
        }
        return success;
    }
}

