/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import java.util.UUID;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.blocks.ItemDisplayTile;
import net.mehvahdjukaar.supplementaries.block.blocks.NoticeBoardBlock;
import net.mehvahdjukaar.supplementaries.block.blocks.StatueBlock;
import net.mehvahdjukaar.supplementaries.common.ModTags;
import net.mehvahdjukaar.supplementaries.common.SpecialPlayers;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.item.TridentItem;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class StatueBlockTile
extends ItemDisplayTile {
    private static PlayerProfileCache profileCache;
    private static MinecraftSessionService sessionService;
    public GameProfile playerProfile = null;
    public StatuePose pose = StatuePose.STANDING;
    public boolean isWaving = false;
    public BlockState candle = null;

    public StatueBlockTile() {
        super((TileEntityType)ModRegistry.STATUE_TILE.get());
    }

    public static void initializeSessionData(MinecraftServer server) {
        profileCache = server.func_152358_ax();
        sessionService = server.func_147130_as();
    }

    public double func_145833_n() {
        return 60.0;
    }

    public void func_70296_d() {
        super.func_70296_d();
    }

    public void func_213903_a(ITextComponent name) {
        super.func_213903_a(name);
        this.updateName();
    }

    private void updateName() {
        if (this.func_145818_k_()) {
            String name = this.func_200201_e().getString().toLowerCase();
            UUID id = SpecialPlayers.STATUES.get(name);
            if (id != null) {
                this.playerProfile = this.updateGameProfile(new GameProfile(id, name));
            }
        } else {
            this.playerProfile = null;
        }
    }

    @Nullable
    public GameProfile updateGameProfile(@Nullable GameProfile input) {
        if (input != null) {
            GameProfile gameprofile;
            if (input.isComplete() && input.getProperties().containsKey((Object)"textures")) {
                return input;
            }
            if (profileCache != null && sessionService != null && (gameprofile = profileCache.func_152655_a(input.getName())) != null) {
                Property property = (Property)Iterables.getFirst((Iterable)gameprofile.getProperties().get((Object)"textures"), null);
                if (property == null) {
                    gameprofile = sessionService.fillProfileProperties(gameprofile, true);
                }
                return gameprofile;
            }
        }
        return input;
    }

    public void updateClientVisualsOnLoad() {
        super.updateClientVisualsOnLoad();
        this.updateName();
        ItemStack stack = this.getDisplayedItem();
        this.pose = StatuePose.getPose(stack);
        this.isWaving = (Boolean)this.func_195044_w().func_177229_b((net.minecraft.state.Property)StatueBlock.POWERED);
        if (this.pose == StatuePose.CANDLE) {
            this.candle = ((BlockItem)stack.func_77973_b()).func_179223_d().func_176223_P();
        }
    }

    public void updateOnChangedBeforePacket() {
        boolean flag;
        super.updateOnChangedBeforePacket();
        boolean bl = flag = StatuePose.getPose(this.getDisplayedItem()) == StatuePose.CANDLE;
        if (flag != (Boolean)this.func_195044_w().func_177229_b((net.minecraft.state.Property)StatueBlock.LIT)) {
            this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((net.minecraft.state.Property)StatueBlock.LIT, (Comparable)Boolean.valueOf(flag)));
        }
    }

    public ITextComponent func_213907_g() {
        return new TranslationTextComponent("block.supplementaries.statuette");
    }

    public Direction getDirection() {
        return (Direction)this.func_195044_w().func_177229_b((net.minecraft.state.Property)NoticeBoardBlock.FACING);
    }

    public static enum StatuePose {
        STANDING,
        HOLDING,
        CANDLE,
        SWORD,
        TOOL;


        public static StatuePose getPose(ItemStack stack) {
            if (stack.func_190926_b()) {
                return STANDING;
            }
            Item i = stack.func_77973_b();
            if (i instanceof SwordItem) {
                return SWORD;
            }
            if (i instanceof ToolItem || i instanceof TridentItem) {
                return TOOL;
            }
            return i.func_206844_a(ModTags.CANDLES) || i == ModRegistry.CANDLE_HOLDER_ITEM.get() ? CANDLE : HOLDING;
        }
    }
}

