/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.api.ICatchableMob;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.ConfigHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class CapturedMobsHelper {
    public static final List<String> COMMAND_MOBS = new ArrayList<String>();
    public static final List<List<String>> DEFAULT_CONFIG = new ArrayList<List<String>>();
    public static final List<String> CATCHABLE_FISHES = new ArrayList<String>();
    public static final Map<String, CapturedMobProperties> TYPES = new HashMap<String, CapturedMobProperties>();
    public static final Map<Item, String> VALID_BUCKETS = new HashMap<Item, String>();
    public static final CapturedMobProperties DEFAULT = new CapturedMobProperties("69", 0.0f, 0.0f, 0, 0, ICatchableMob.AnimationCategory.DEFAULT);
    public static final CapturedMobProperties MODDED_FISH = new CapturedMobProperties("420", 0.0f, 0.0f, 0, 1, ICatchableMob.AnimationCategory.DEFAULT);
    private static int fishIndex = 0;

    private static List<String> addFish(String id) {
        return CapturedMobsHelper.addDef(id, 0.0f, 0.125f, 0, ++fishIndex);
    }

    private static List<String> addFish(String id, int fishIndex) {
        return CapturedMobsHelper.addDef(id, 0.0f, 0.125f, 0, fishIndex);
    }

    private static List<String> addDef(String id, float h, float w, int l, int f) {
        return Arrays.asList(id, "" + h, "" + w, "" + l, "" + f);
    }

    private static List<String> addDef(String id, float h, float w, int l, ICatchableMob.AnimationCategory c) {
        return Arrays.asList(id, "" + h, "" + w, "" + l, c.toString());
    }

    private static List<String> addDef(String id, float h, float w, int l) {
        return Arrays.asList(id, "" + h, "" + w, "" + l);
    }

    private static List<String> addDef(String id, float h, float w) {
        return Arrays.asList(id, "" + h, "" + w);
    }

    public static String getDefaultNameFromBucket(Item bucket) {
        String def = "Mob";
        String mobId = VALID_BUCKETS.getOrDefault(bucket, def);
        if (mobId.equals(def)) {
            return def;
        }
        EntityType en = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(mobId));
        if (en == null) {
            return def;
        }
        return en.func_212546_e().getString();
    }

    public static CapturedMobProperties getTypeFromBucket(Item bucket) {
        return CapturedMobsHelper.getType(VALID_BUCKETS.getOrDefault(bucket, "minecraft:fish"));
    }

    public static CapturedMobProperties getType(Entity mob) {
        return CapturedMobsHelper.getType(mob.func_200600_R().getRegistryName().toString());
    }

    public static CapturedMobProperties getType(String mobId) {
        return TYPES.getOrDefault(mobId, DEFAULT);
    }

    public static List<String> getFishes() {
        ArrayList<String> l = new ArrayList<String>();
        for (List<String> d : DEFAULT_CONFIG) {
            int f;
            if (d.size() != 5 || (f = CapturedMobsHelper.strToInt(d.get(4))) <= 0 || d.get(0).equals("")) continue;
            l.add(d.get(0));
        }
        return l;
    }

    public static boolean isFishBucket(Item item2) {
        return VALID_BUCKETS.containsKey(item2);
    }

    private static float strToFloat(String s) {
        if (s != null && s.matches("[0-9.]+")) {
            return Float.parseFloat(s);
        }
        return 0.0f;
    }

    private static int strToInt(String s) {
        if (s != null && s.matches("[0-9.]+")) {
            return Integer.parseInt(s);
        }
        return 0;
    }

    public static void refresh() {
        TYPES.clear();
        List<? extends List<String>> config = ConfigHandler.safeGetListString(ClientConfigs.CLIENT_SPEC, ClientConfigs.block.CAPTURED_MOBS_PROPERTIES);
        for (List<String> list : config) {
            try {
                Object type;
                int size = list.size();
                if (size < 2) continue;
                String id = list.get(0);
                float h = CapturedMobsHelper.strToFloat(list.get(1));
                float w = 0.0f;
                int light = 0;
                int fish = 0;
                ICatchableMob.AnimationCategory cat = ICatchableMob.AnimationCategory.DEFAULT;
                if (size > 2) {
                    w = CapturedMobsHelper.strToFloat(list.get(2));
                }
                if (size > 3) {
                    light = CapturedMobsHelper.strToInt(list.get(3));
                }
                if (size > 4) {
                    type = list.get(4).toLowerCase();
                    switch (type) {
                        case "air": {
                            cat = ICatchableMob.AnimationCategory.AIR;
                            break;
                        }
                        case "land": {
                            cat = ICatchableMob.AnimationCategory.LAND;
                            break;
                        }
                        case "floating": {
                            cat = ICatchableMob.AnimationCategory.FLOATING;
                            break;
                        }
                        default: {
                            fish = CapturedMobsHelper.strToInt((String)type);
                            if (fish <= 0) break;
                            cat = ICatchableMob.AnimationCategory.FISH;
                        }
                    }
                }
                type = new CapturedMobProperties(id, h, w, light, fish, cat);
                TYPES.put(id, (CapturedMobProperties)type);
            }
            catch (Exception e) {
                Supplementaries.LOGGER.warn("failed to load captured mob configs");
            }
        }
        for (String string : CATCHABLE_FISHES) {
            CapturedMobsHelper.tryAddingValidBucket(string);
        }
    }

    public static void tryAddingValidBucket(String mobId) {
        ResourceLocation res = new ResourceLocation(mobId);
        Item bucket = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(res.func_110624_b(), res.func_110623_a() + "_bucket"));
        if (bucket != null && bucket != Items.field_190931_a) {
            VALID_BUCKETS.put(bucket, mobId);
        } else {
            bucket = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(res.func_110624_b(), "bucket_" + res.func_110623_a()));
            if (bucket != null && bucket != Items.field_190931_a) {
                VALID_BUCKETS.put(bucket, mobId);
            } else {
                bucket = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(res.func_110624_b(), "bucket_of_" + res.func_110623_a()));
                if (bucket != null && bucket != Items.field_190931_a) {
                    VALID_BUCKETS.put(bucket, mobId);
                }
            }
        }
    }

    static {
        boolean fishIndex = false;
        DEFAULT_CONFIG.add(CapturedMobsHelper.addDef("minecraft:bee", 0.3125f, 0.0f));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addDef("minecraft:vex", 0.0f, 0.125f, 0, ICatchableMob.AnimationCategory.FLOATING));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addDef("minecraft:silverfish", 0.0f, 0.25f));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addDef("minecraft:chicken", 0.25f, 0.3125f));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addDef("minecraft:endermite", 0.0f, 0.0f, 5));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addDef("minecraft:fox", 0.0f, 0.2f));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addDef("supplementaries:firefly", 0.0f, 0.0f, 9, ICatchableMob.AnimationCategory.FLOATING));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addDef("druidcraft:lunar_moth", 0.375f, 0.1375f, 10, ICatchableMob.AnimationCategory.FLOATING));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addDef("iceandfire:pixie", 0.0f, 0.0f, 10));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("minecraft:fish"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("minecraft:tropical_fish"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("minecraft:salmon"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("minecraft:cod"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("minecraft:pufferfish"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("minecraft:axolotl"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("fins:pea_wee"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("fins:wee_wee"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("fins:vibra_wee"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("fins:blu_wee"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("fins:ornate_bugfish"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("fins:spindly_gem_crab"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("fins:phantom_nudibranch"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("fins:high_finned_blue"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("fins:teal_arrowfish"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("fins:midnight_squid"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("fins:banded_redback_shrimp"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("fins:flatback_sucker"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("fins:swamp_mucker"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("upgrade_aquatic:lionfish"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("upgrade_aquatic:nautilus"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("upgrade_aquatic:pike"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("alexsmobs:stradpole"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("alexsmobs:blobfish"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("unnamedanimalmod:flashlight_fish"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("unnamedanimalmod:elephantnose_fish"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("unnamedanimalmod:black_diamond_stingray"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("unnamedanimalmod:humphead_parrotfish"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("unnamedanimalmod:tomato_frog"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("unnamedanimalmod:pacman_frog"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("bettas:betta_fish"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("pogfish:pogfish"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("undergarden:gwibling"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("environmental:koi"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("betterendforge:end_fish"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("betteranimalsplus:flying_fish"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("betteranimalsplus:nautilus"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("betteranimalsplus:eel_freshwater"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("betteranimalsplus:eel_saltwater"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("betteranimalsplus:lamprey"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("betteranimalsplus:piranha"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("betteranimalsplus:barracuda"));
        DEFAULT_CONFIG.add(CapturedMobsHelper.addFish("rediscovered:fish", 1));
        for (List<String> d : DEFAULT_CONFIG) {
            int f;
            if (d.size() != 5 || (f = CapturedMobsHelper.strToInt(d.get(4))) <= 0 || d.get(0).equals("")) continue;
            CATCHABLE_FISHES.add(d.get(0));
        }
    }

    public static class CapturedMobProperties {
        private final String id;
        private final float extraWidth;
        private final float extraHeight;
        private final int lightLevel;
        private final int fishTexture;
        private final ICatchableMob.AnimationCategory category;

        private CapturedMobProperties(String id, float h, float w, int light, int fish, ICatchableMob.AnimationCategory c) {
            this.id = id;
            this.extraWidth = w;
            this.extraHeight = h;
            this.lightLevel = light;
            this.fishTexture = fish - 1;
            this.category = c;
        }

        public ICatchableMob.AnimationCategory getCategory() {
            return this.category;
        }

        public boolean canHaveWater() {
            return this.isFlying() || this.isFish();
        }

        public String getId() {
            return this.id;
        }

        public float getHeight() {
            return this.extraHeight;
        }

        public float getWidth() {
            return this.extraWidth;
        }

        public int getFishTexture() {
            return this.fishTexture;
        }

        public int getLightLevel() {
            return this.lightLevel;
        }

        public boolean isFish() {
            return this.category.isFish();
        }

        public boolean isFlying() {
            return this.category.isFlying();
        }

        public boolean isLand() {
            return this.category.isLand();
        }

        public boolean isFloating() {
            return this.category.isFloating();
        }

        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

