/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.util;

import java.lang.reflect.Method;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.util.Utils;
import net.mehvahdjukaar.supplementaries.api.ICatchableMob;
import net.mehvahdjukaar.supplementaries.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.block.util.CapturedMobsHelper;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class MobHolder {
    private final Random rand = new Random();
    private World world;
    private BlockPos pos;
    private ItemStack bucketHolder = ItemStack.field_190927_a;
    public SpecialBehaviorType specialBehaviorType = SpecialBehaviorType.NONE;
    public CapturedMobsHelper.CapturedMobProperties capturedMobProperties = CapturedMobsHelper.DEFAULT;
    private boolean firstTick = true;
    public CompoundNBT entityData = null;
    public UUID uuid = null;
    public float yOffset = 1.0f;
    public float scale = 1.0f;
    public String name;
    public Entity mob = null;
    public float jumpY = 0.0f;
    public float prevJumpY = 0.0f;
    public float yVel = 0.0f;

    public MobHolder(World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
    }

    public void setWorldAndPos(World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
    }

    public void setPartying(BlockPos pos, boolean isPartying) {
        if (this.mob != null && this.mob instanceof LivingEntity) {
            ((LivingEntity)this.mob).func_191987_a(pos, isPartying);
        }
    }

    public void read(CompoundNBT compound) {
        if (compound.func_74764_b("MobHolder")) {
            CompoundNBT cmp = compound.func_74775_l("MobHolder");
            this.entityData = cmp.func_74775_l("EntityData");
            this.scale = cmp.func_74760_g("Scale");
            this.yOffset = cmp.func_74760_g("YOffset");
            if (cmp.func_74764_b("UUID")) {
                this.uuid = cmp.func_186857_a("UUID");
            }
            this.name = cmp.func_74779_i("Name");
        }
        if (compound.func_74764_b("BucketHolder")) {
            this.bucketHolder = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("BucketHolder"));
        }
    }

    public CompoundNBT write(CompoundNBT compound) {
        int fishTexture;
        if (this.entityData != null) {
            fishTexture = this.mob instanceof WaterMobEntity ? -69 : this.capturedMobProperties.getFishTexture();
            MobHolder.saveMobToNBT(compound, this.entityData, this.scale, this.yOffset, this.name, this.uuid, fishTexture);
        }
        if (!this.bucketHolder.func_190926_b()) {
            fishTexture = this.mob instanceof WaterMobEntity ? -69 : this.capturedMobProperties.getFishTexture();
            MobHolder.saveBucketToNBT(compound, this.bucketHolder, this.name, fishTexture);
        }
        return compound;
    }

    public static void saveBucketToNBT(CompoundNBT compound, ItemStack bucket, String name, int fishTexture) {
        CompoundNBT cmp = new CompoundNBT();
        bucket.func_77955_b(cmp);
        if (fishTexture >= 0 || fishTexture == -69) {
            cmp.func_74768_a("FishTexture", fishTexture);
        }
        if (name != null) {
            cmp.func_74778_a("Name", name);
        }
        compound.func_218657_a("BucketHolder", (INBT)cmp);
    }

    public static void saveMobToNBT(CompoundNBT compound, CompoundNBT entityData, float scale, float yOffset, String name, UUID id, int fishTexture) {
        CompoundNBT cmp = new CompoundNBT();
        cmp.func_218657_a("EntityData", (INBT)entityData);
        cmp.func_74776_a("Scale", scale);
        cmp.func_74776_a("YOffset", yOffset);
        if (id != null) {
            cmp.func_186854_a("UUID", id);
        }
        cmp.func_74778_a("Name", name);
        if (fishTexture >= 0 || fishTexture == -69) {
            cmp.func_74768_a("FishTexture", fishTexture);
        }
        compound.func_218657_a("MobHolder", (INBT)cmp);
    }

    public boolean acceptFishBucket(ItemStack stack) {
        Item item2 = stack.func_77973_b();
        return false;
    }

    public boolean interactWithBucketItem(ItemStack stack, @Nullable PlayerEntity player, Hand hand) {
        Item item2 = stack.func_77973_b();
        ItemStack returnStack = ItemStack.field_190927_a;
        if (CapturedMobsHelper.isFishBucket(item2) && this.isEmpty()) {
            this.bucketHolder = stack.func_77946_l();
            this.world.func_184133_a(null, this.pos, SoundEvents.field_203819_X, SoundCategory.BLOCKS, 1.0f, 1.0f);
            returnStack = new ItemStack((IItemProvider)Items.field_151133_ar);
        } else if (!this.bucketHolder.func_190926_b() && item2 == Items.field_151133_ar) {
            this.world.func_184133_a(null, this.pos, SoundEvents.field_203814_aa, SoundCategory.BLOCKS, 1.0f, 1.0f);
            returnStack = this.bucketHolder.func_77946_l();
            this.clear();
        }
        if (!returnStack.func_190926_b()) {
            if (player != null) {
                player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)item2));
                if (!player.func_184812_l_()) {
                    Utils.swapItem((PlayerEntity)player, (Hand)hand, (ItemStack)returnStack);
                }
            }
            return true;
        }
        return false;
    }

    public void clear() {
        this.bucketHolder = ItemStack.field_190927_a;
        this.firstTick = true;
        this.mob = null;
        this.entityData = null;
    }

    public void tick() {
        if (this.firstTick && !this.isEmpty()) {
            this.init();
            this.firstTick = false;
        }
        if (this.mob == null) {
            return;
        }
        ++this.mob.field_70173_aa;
        boolean hasCustomMethods = this.mob instanceof ICatchableMob;
        if (hasCustomMethods) {
            ((ICatchableMob)this.mob).tickInsideCageOrJar();
        }
        if (!this.world.field_72995_K) {
            if (this.specialBehaviorType == SpecialBehaviorType.CHICKEN) {
                ChickenEntity ch = (ChickenEntity)this.mob;
                if (--ch.field_70887_j <= 0) {
                    ch.func_199703_a((IItemProvider)Items.field_151110_aK);
                    ch.field_70887_j = this.rand.nextInt(6000) + 6000;
                }
            } else if (this.specialBehaviorType == SpecialBehaviorType.SQUID) {
                ((LivingEntity)this.mob).func_70636_d();
            }
        } else {
            this.prevJumpY = this.jumpY;
            switch (this.specialBehaviorType) {
                default: {
                    break;
                }
                case SLIME: {
                    SlimeEntity slime = (SlimeEntity)this.mob;
                    slime.field_70811_b += (slime.field_70813_a - slime.field_70811_b) * 0.5f;
                    slime.field_70812_c = slime.field_70811_b;
                    if (this.yVel != 0.0f) {
                        this.jumpY = Math.max(0.0f, this.jumpY + this.yVel);
                    }
                    if (this.jumpY != 0.0f) {
                        this.yVel -= 0.01f;
                    } else {
                        if (this.yVel != 0.0f) {
                            this.yVel = 0.0f;
                            slime.field_70813_a = -0.5f;
                        }
                        if ((double)this.rand.nextFloat() > 0.985) {
                            this.yVel = 0.08f;
                            slime.field_70813_a = 1.0f;
                        }
                    }
                    slime.field_70813_a *= 0.6f;
                    break;
                }
                case ENDERMITE: {
                    if (!(this.rand.nextFloat() > 0.7f)) break;
                    this.world.func_195594_a((IParticleData)ParticleTypes.field_197599_J, (double)((float)this.pos.func_177958_n() + 0.5f), (double)((float)this.pos.func_177956_o() + 0.2f), (double)((float)this.pos.func_177952_p() + 0.5f), (this.rand.nextDouble() - 0.5) * 2.0, -this.rand.nextDouble(), (this.rand.nextDouble() - 0.5) * 2.0);
                    break;
                }
                case PARROT: {
                    ((LivingEntity)this.mob).func_70636_d();
                    boolean p = ((ParrotEntity)this.mob).func_192004_dr();
                    this.mob.func_230245_c_(p);
                    this.jumpY = p ? 0.0f : 0.0625f;
                    break;
                }
                case TICKABLE: {
                    ((LivingEntity)this.mob).func_70636_d();
                    break;
                }
                case RABBIT: {
                    RabbitEntity rabbit = (RabbitEntity)this.mob;
                    if (this.yVel != 0.0f) {
                        this.jumpY = Math.max(0.0f, this.jumpY + this.yVel);
                    }
                    if (this.jumpY != 0.0f) {
                        this.yVel -= 0.017f;
                    } else {
                        if (this.yVel != 0.0f) {
                            this.yVel = 0.0f;
                        }
                        if ((double)this.rand.nextFloat() > 0.985) {
                            this.yVel = 0.093f;
                            rabbit.func_184770_cZ();
                        }
                    }
                    rabbit.func_70636_d();
                    break;
                }
                case CAT: {
                    CatEntity cat = (CatEntity)this.mob;
                    cat.func_233686_v_(true);
                    break;
                }
                case SQUID: {
                    SquidEntity squid = (SquidEntity)this.mob;
                    squid.func_70636_d();
                    break;
                }
                case CHICKEN: {
                    ChickenEntity ch = (ChickenEntity)this.mob;
                    ch.func_70636_d();
                    double d = this.rand.nextFloat();
                    double d2 = ch.func_233570_aj_() ? 0.99 : 0.88;
                    if (!(d > d2)) break;
                    ch.func_230245_c_(!ch.func_233570_aj_());
                }
            }
            if (this.capturedMobProperties.isFloating() || hasCustomMethods && ((ICatchableMob)this.mob).getAnimationCategory().isFloating()) {
                this.jumpY = 0.04f * MathHelper.func_76126_a((float)((float)this.mob.field_70173_aa / 10.0f)) - 0.03f;
            }
        }
    }

    public void setWaterMobInWater(boolean w) {
        if (this.mob != null && this.mob instanceof WaterMobEntity && this.mob.func_70090_H() != w) {
            this.mob.field_70171_ac = w;
        }
    }

    @Nullable
    public static Entity createEntityFromNBT(CompoundNBT com, UUID id, World world) {
        if (com != null && com.func_74764_b("id")) {
            Entity entity2;
            String name;
            switch (name = com.func_74781_a("id").func_150285_a_()) {
                case "minecraft:bee": {
                    entity2 = new BeeEntity(EntityType.field_226289_e_, world);
                    break;
                }
                case "minecraft:iron_golem": {
                    entity2 = new IronGolemEntity(EntityType.field_200757_aw, world);
                    break;
                }
                case "minecraft:enderman": {
                    entity2 = new EndermanEntity(EntityType.field_200803_q, world);
                    break;
                }
                case "minecraft:wolf": {
                    entity2 = new WolfEntity(EntityType.field_200724_aC, world);
                    break;
                }
                default: {
                    entity2 = EntityType.func_220335_a((CompoundNBT)com, (World)world, o -> o);
                }
            }
            if (id != null && entity2 != null) {
                entity2.func_184221_a(id);
            }
            return entity2;
        }
        return null;
    }

    public void init() {
        if (!this.bucketHolder.func_190926_b()) {
            this.capturedMobProperties = CapturedMobsHelper.getTypeFromBucket(this.bucketHolder.func_77973_b());
            if (this.name == null || this.name.isEmpty()) {
                this.name = CapturedMobsHelper.getDefaultNameFromBucket(this.bucketHolder.func_77973_b());
            }
        } else if (this.world != null && this.entityData != null) {
            Entity entity2 = MobHolder.createEntityFromNBT(this.entityData, this.uuid, this.world);
            if (entity2 == null) {
                return;
            }
            this.specialBehaviorType = SpecialBehaviorType.getType(entity2);
            this.capturedMobProperties = CapturedMobsHelper.getType(entity2);
            double px = (double)this.pos.func_177958_n() + 0.5;
            double py = (double)this.pos.func_177956_o() + 0.5625 + 0.5;
            double pz = (double)this.pos.func_177952_p() + 0.5;
            entity2.func_70107_b(px, py, pz);
            entity2.field_70142_S = px;
            entity2.field_70137_T = py;
            entity2.field_70136_U = pz;
            entity2.field_70169_q = px;
            entity2.field_70167_r = py;
            entity2.field_70166_s = pz;
            entity2.field_70173_aa += this.rand.nextInt(40);
            this.mob = entity2;
            this.setWaterMobInWater(true);
            if (!this.world.field_72995_K) {
                int light = this.mob instanceof ICatchableMob ? ((ICatchableMob)this.mob).getLightLevel() : this.capturedMobProperties.getLightLevel();
                BlockState state = this.world.func_180495_p(this.pos);
                if ((Integer)state.func_177229_b((Property)BlockProperties.LIGHT_LEVEL_0_15) != light) {
                    this.world.func_180501_a(this.pos, (BlockState)state.func_206870_a((Property)BlockProperties.LIGHT_LEVEL_0_15, (Comparable)Integer.valueOf(light)), 22);
                }
            }
        }
    }

    private void setBucketHolder(Entity entity2) {
        if (entity2 instanceof AbstractFishEntity) {
            try {
                Method m = ObfuscationReflectionHelper.findMethod(AbstractFishEntity.class, (String)"func_203707_dx", (Class[])new Class[0]);
                m.setAccessible(true);
                this.bucketHolder = (ItemStack)m.invoke((Object)entity2, new Object[0]);
            }
            catch (Exception exception) {
                try {
                    Method m = ObfuscationReflectionHelper.findMethod(AbstractFishEntity.class, (String)"getFishBucket", (Class[])new Class[0]);
                    m.setAccessible(true);
                    this.bucketHolder = (ItemStack)m.invoke((Object)entity2, new Object[0]);
                }
                catch (Exception m) {
                    // empty catch block
                }
            }
            try {
                Method m2 = ObfuscationReflectionHelper.findMethod(AbstractFishEntity.class, (String)"func_204211_f", (Class[])new Class[]{ItemStack.class});
                m2.setAccessible(true);
                m2.invoke((Object)entity2, this.bucketHolder);
            }
            catch (Exception exception) {
                try {
                    Method m2 = ObfuscationReflectionHelper.findMethod(AbstractFishEntity.class, (String)"setBucketData", (Class[])new Class[]{ItemStack.class});
                    m2.setAccessible(true);
                    m2.invoke((Object)entity2, this.bucketHolder);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
    }

    public boolean isEmpty() {
        return this.entityData == null && this.bucketHolder.func_190926_b();
    }

    private static boolean isInAir(Entity mob, ICatchableMob.AnimationCategory category) {
        return !category.isLand() && (category.isFlying() || mob.func_189652_ae() || mob instanceof IFlyingAnimal || mob.func_145773_az() || mob instanceof WaterMobEntity);
    }

    @Nullable
    public static CompoundNBT createMobHolderItemNBT(Entity mob, float blockW, float blockH) {
        boolean isBat;
        if (mob == null) {
            return null;
        }
        if (mob instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)mob;
            le.field_70758_at = 0.0f;
            le.field_70759_as = 0.0f;
            le.field_70721_aZ = 0.0f;
            le.field_184618_aE = 0.0f;
            le.field_184619_aG = 0.0f;
            le.field_70738_aO = 0;
            le.field_70737_aN = 0;
            le.field_70733_aJ = 0.0f;
        }
        if (isBat = mob instanceof BatEntity) {
            ((BatEntity)mob).func_82236_f(true);
        }
        boolean isFox = mob instanceof FoxEntity;
        if (mob instanceof AbstractFishEntity) {
            ((AbstractFishEntity)mob).func_203706_r(true);
        }
        mob.field_70177_z = 0.0f;
        mob.field_70126_B = 0.0f;
        mob.field_70127_C = 0.0f;
        mob.field_70125_A = 0.0f;
        mob.func_70066_B();
        mob.field_70172_ad = 0;
        UUID id = mob.func_110124_au();
        CompoundNBT mobCompound = new CompoundNBT();
        mob.func_70039_c(mobCompound);
        if (!mobCompound.isEmpty()) {
            String name;
            float y;
            float addHeight;
            float addWidth;
            mobCompound.func_82580_o("Passengers");
            mobCompound.func_82580_o("Leash");
            mobCompound.func_82580_o("UUID");
            if (isFox) {
                mobCompound.func_74757_a("Sleeping", true);
            }
            CapturedMobsHelper.CapturedMobProperties mobProperties = CapturedMobsHelper.getType(mob);
            ICatchableMob.AnimationCategory category = mobProperties.getCategory();
            boolean isAir = MobHolder.isInAir(mob, category);
            float babyScale = 1.0f;
            if (mob instanceof AgeableEntity && ((LivingEntity)mob).func_70631_g_()) {
                babyScale = 2.0f;
            }
            if (mobCompound.func_74764_b("IsBaby") && mobCompound.func_74767_n("IsBaby") || mob instanceof VillagerEntity && ((LivingEntity)mob).func_70631_g_()) {
                babyScale = 1.125f;
            }
            float s = 1.0f;
            float w = mob.func_213311_cf() * babyScale;
            float h = mob.func_213302_cg() * babyScale;
            if (mob instanceof ICatchableMob) {
                addWidth = ((ICatchableMob)mob).getHitBoxWidthIncrement();
                addHeight = ((ICatchableMob)mob).getHitBoxHeightIncrement();
            } else {
                addWidth = mobProperties.getWidth();
                addHeight = mobProperties.getHeight();
            }
            float maxh = blockH - (isAir ? 0.25f : 0.125f) - addHeight;
            float maxw = blockW - 0.25f - addWidth;
            if (w > maxw || h > maxh) {
                s = w - maxw > h - maxh ? maxw / w : maxh / h;
            }
            float f = y = isAir ? blockH / 2.0f - h * s / 2.0f : 0.0626f;
            if (isBat) {
                y = (float)((double)y * 1.5);
            }
            if ((name = mob.func_200600_R().getRegistryName().toString()).equals("iceandfire:fire_dragon") || name.equals("iceandfire:ice_dragon") || name.equals("iceandfire:lightning_dragon")) {
                s = (float)((double)s * 0.45);
            }
            CompoundNBT cmp = new CompoundNBT();
            int fishTexture = mob instanceof WaterMobEntity ? -69 : CapturedMobsHelper.getType(name).getFishTexture();
            MobHolder.saveMobToNBT(cmp, mobCompound, s, y, mob.func_200200_C_().getString(), id, fishTexture);
            return cmp;
        }
        return null;
    }

    public boolean shouldHaveWater() {
        return this.specialBehaviorType.hasWater() || this.capturedMobProperties.isFish();
    }

    public static enum SpecialBehaviorType {
        NONE,
        SLIME,
        VEX,
        ENDERMITE,
        PARROT,
        CAT,
        RABBIT,
        CHICKEN,
        TICKABLE,
        WATER_MOB,
        SQUID;


        public boolean hasWater() {
            return this == WATER_MOB || this == SQUID;
        }

        public static SpecialBehaviorType getType(Entity e) {
            if (e instanceof SquidEntity) {
                return SQUID;
            }
            if (e instanceof WaterMobEntity) {
                return WATER_MOB;
            }
            if (e instanceof SlimeEntity) {
                return SLIME;
            }
            if (e instanceof VexEntity) {
                return VEX;
            }
            if (e instanceof ParrotEntity) {
                return PARROT;
            }
            if (e instanceof CatEntity) {
                return CAT;
            }
            if (e instanceof RabbitEntity) {
                return RABBIT;
            }
            if (e instanceof ChickenEntity) {
                return CHICKEN;
            }
            if (e.func_200600_R().getRegistryName().toString().equals("iceandfire:pixe") || e.func_200600_R().getRegistryName().toString().equals("druidcraft:moth")) {
                return TICKABLE;
            }
            if (e instanceof EndermiteEntity) {
                return ENDERMITE;
            }
            return NONE;
        }
    }
}

