/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.mehvahdjukaar.selene.fluids.SoftFluid;
import net.mehvahdjukaar.selene.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.supplementaries.block.tiles.JarBlockTile;
import net.mehvahdjukaar.supplementaries.client.renderers.Const;
import net.mehvahdjukaar.supplementaries.client.renderers.RendererUtil;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.CageBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.common.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IWorldReader;

public class JarBlockTileRenderer
extends CageBlockTileRenderer<JarBlockTile> {
    private final ItemRenderer itemRenderer;
    private final Minecraft minecraft = Minecraft.func_71410_x();

    public JarBlockTileRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
        this.itemRenderer = this.minecraft.func_175599_af();
    }

    public static void renderFluid(float height, int color, int luminosity, ResourceLocation texture, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int light, int combinedOverlayIn, boolean shading) {
        matrixStackIn.func_227860_a_();
        float opacity = 1.0f;
        if (luminosity != 0) {
            light = light & 0xF00000 | luminosity << 4;
        }
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(texture);
        IVertexBuilder builder = bufferIn.getBuffer(RenderType.func_239269_g_());
        matrixStackIn.func_227861_a_(0.5, 0.0625, 0.5);
        RendererUtil.addCube(builder, matrixStackIn, 0.5f, height, sprite, light, color, opacity, combinedOverlayIn, true, true, shading, true);
        matrixStackIn.func_227865_b_();
    }

    public void render(JarBlockTile tile, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        long r = tile.func_174877_v().func_218275_a();
        Random rand = new Random(r);
        if (!tile.func_191420_l()) {
            ItemStack stack = tile.getDisplayedItem();
            int height = tile.getDisplayedItem().func_190916_E();
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.5, 0.5, 0.5);
            matrixStackIn.func_227863_a_(Const.XN90);
            matrixStackIn.func_227861_a_(0.0, 0.0, -0.5);
            float scale = 0.5714286f;
            matrixStackIn.func_227862_a_(scale, scale, scale);
            for (float i = 0.0f; i < (float)height; i += 1.0f) {
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)rand.nextInt(16) * 22.5f));
                matrixStackIn.func_227861_a_(0.0, 0.0, (double)(1.0f / (16.0f * scale)));
                IBakedModel ibakedmodel = this.itemRenderer.func_184393_a(stack, tile.func_145831_w(), null);
                this.itemRenderer.func_229111_a_(stack, ItemCameraTransforms.TransformType.FIXED, true, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, ibakedmodel);
            }
            matrixStackIn.func_227865_b_();
        }
        if (!tile.mobHolder.isEmpty()) {
            if (tile.mobHolder.capturedMobProperties.isFish()) {
                matrixStackIn.func_227860_a_();
                long time = System.currentTimeMillis() + r;
                float angle = (float)(time % 28800L) / 80.0f;
                float angle2 = (float)(time % 1080L) / 3.0f;
                float angle3 = (float)(time % 126000L) / 350.0f;
                float wo = 0.015f * MathHelper.func_76126_a((float)((float)(Math.PI * 2 * (double)angle2 / 360.0)));
                float ho = 0.1f * MathHelper.func_76126_a((float)((float)(Math.PI * 2 * (double)angle3 / 360.0)));
                IVertexBuilder builder = bufferIn.getBuffer(RenderType.func_228643_e_());
                matrixStackIn.func_227861_a_(0.5, 0.5, 0.5);
                Quaternion rotation = Vector3f.field_229181_d_.func_229187_a_(-angle);
                matrixStackIn.func_227863_a_(rotation);
                matrixStackIn.func_227862_a_(0.625f, 0.625f, 0.625f);
                matrixStackIn.func_227861_a_(0.0, -0.2, -0.335);
                int fishType = tile.mobHolder.capturedMobProperties.getFishTexture();
                RendererUtil.renderFish(builder, matrixStackIn, wo, ho, fishType, combinedLightIn, combinedOverlayIn);
                matrixStackIn.func_227865_b_();
            } else {
                super.func_225616_a_(tile, partialTicks, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
            }
            if (tile.mobHolder.shouldHaveWater()) {
                matrixStackIn.func_227860_a_();
                matrixStackIn.func_227861_a_(0.5, 0.0635, 0.5);
                IVertexBuilder builder = bufferIn.getBuffer(RenderType.func_228643_e_());
                TextureAtlasSprite sprite_s = (TextureAtlasSprite)this.minecraft.func_228015_a_(AtlasTexture.field_110575_b).apply(Textures.SAND_TEXTURE);
                RendererUtil.addCube(builder, matrixStackIn, 0.499f, 0.0625f, sprite_s, combinedLightIn, 0xFFFFFF, 1.0f, combinedOverlayIn, true, true, true, true);
                matrixStackIn.func_227865_b_();
                matrixStackIn.func_227860_a_();
                SoftFluid s = SoftFluidRegistry.WATER;
                JarBlockTileRenderer.renderFluid(0.5625f, s.getTintColor(), 0, s.getStillTexture(), matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, true);
                matrixStackIn.func_227865_b_();
            }
        }
        if (!tile.fluidHolder.isEmpty()) {
            JarBlockTileRenderer.renderFluid(tile.fluidHolder.getHeight(0.75f), tile.fluidHolder.getTintColor((IWorldReader)tile.func_145831_w(), tile.func_174877_v()), tile.fluidHolder.getFluid().getLuminosity(), tile.fluidHolder.getFluid().getStillTexture(), matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, true);
        }
    }
}

