/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;
import java.util.UUID;
import net.mehvahdjukaar.supplementaries.block.tiles.StatueBlockTile;
import net.mehvahdjukaar.supplementaries.client.models.StatueEntityModel;
import net.mehvahdjukaar.supplementaries.client.renderers.Const;
import net.mehvahdjukaar.supplementaries.common.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class StatueBlockTileRenderer
extends TileEntityRenderer<StatueBlockTile> {
    protected final ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
    private final StatueEntityModel model = new StatueEntityModel(0.0f);
    private boolean slim = false;

    public StatueBlockTileRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    private ResourceLocation getSkin(GameProfile gameProfile) {
        if (!gameProfile.isComplete()) {
            return new ResourceLocation("minecraft:textures/entity/steve.png");
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        SkinManager skinManager = minecraft.func_152342_ad();
        Map loadSkinFromCache = skinManager.func_152788_a(gameProfile);
        if (loadSkinFromCache.containsKey(MinecraftProfileTexture.Type.SKIN)) {
            MinecraftProfileTexture texture = (MinecraftProfileTexture)loadSkinFromCache.get(MinecraftProfileTexture.Type.SKIN);
            String s = texture.getMetadata("model");
            this.slim = s != null && !s.equals("default");
            return skinManager.func_152792_a(texture, MinecraftProfileTexture.Type.SKIN);
        }
        return DefaultPlayerSkin.func_177334_a((UUID)gameProfile.getId());
    }

    private boolean isSkinSlim(GameProfile gameProfile) {
        return gameProfile != null && gameProfile.getId() != null && (gameProfile.getId().hashCode() & 1) == 1;
    }

    public void render(StatueBlockTile tile, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrixStackIn.func_227860_a_();
        GameProfile playerInfo = tile.playerProfile;
        ResourceLocation resourceLocation = tile.playerProfile == null ? Textures.STATUE : this.getSkin(playerInfo);
        matrixStackIn.func_227861_a_(0.5, 0.5, 0.5);
        Direction dir = tile.getDirection();
        matrixStackIn.func_227863_a_(Const.rot(dir));
        matrixStackIn.func_227863_a_(Const.X90);
        matrixStackIn.func_227861_a_(0.0, -0.25, 0.0);
        RenderType renderType = RenderType.func_228638_b_((ResourceLocation)resourceLocation);
        if (renderType != null) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227862_a_(0.5f, 0.499f, 0.5f);
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(renderType);
            this.model.setupAnim(tile.func_145831_w().func_82737_E(), partialTicks, dir, tile.pose, tile.isWaving, this.slim);
            this.model.func_225598_a_(matrixStackIn, ivertexbuilder, combinedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStackIn.func_227865_b_();
        }
        this.slim = false;
        ItemStack stack = tile.getDisplayedItem();
        if (tile.pose == StatueBlockTile.StatuePose.CANDLE) {
            matrixStackIn.func_227862_a_(1.0f, -1.0f, -1.0f);
        } else {
            matrixStackIn.func_227862_a_(-0.5f, -0.5f, 0.5f);
            IBakedModel ibakedmodel = this.itemRenderer.func_184393_a(stack, tile.func_145831_w(), null);
            if (tile.pose == StatueBlockTile.StatuePose.SWORD) {
                matrixStackIn.func_227861_a_(-0.35, -1.0625, 0.0);
                matrixStackIn.func_227863_a_(Const.Z135);
            } else if (tile.pose == StatueBlockTile.StatuePose.TOOL) {
                matrixStackIn.func_227861_a_(-0.4, -1.25, 0.0);
                matrixStackIn.func_227863_a_(Const.Z135);
            }
            matrixStackIn.func_227861_a_(0.0, -0.5, -0.5);
            this.itemRenderer.func_229111_a_(stack, ItemCameraTransforms.TransformType.FIXED, true, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, ibakedmodel);
        }
        matrixStackIn.func_227865_b_();
    }
}

