/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common;

import java.util.Calendar;
import net.mehvahdjukaar.supplementaries.block.blocks.SignPostBlock;
import net.mehvahdjukaar.supplementaries.common.ModTags;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.LanternBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.ShulkerBoxTileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;

public class CommonUtil {
    public static DamageSource SPIKE_DAMAGE = new DamageSource("supplementaries.bamboo_spikes");
    public static DamageSource BOTTLING_DAMAGE = new DamageSource("supplementaries.xp_extracting");
    public static DamageSource AMETHYST_SHARD_DAMAGE = new DamageSource("supplementaries.amethyst_shard");
    public static Festivity FESTIVITY = Festivity.access$000();
    public static final AxisAlignedBB FENCE_SHAPE = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0).func_197752_a();
    public static final AxisAlignedBB POST_SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0).func_197752_a();
    public static final AxisAlignedBB WALL_SHAPE = Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)12.0, (double)16.0, (double)12.0).func_197752_a();
    private static final ShulkerBoxTileEntity SHULKER_TILE = new ShulkerBoxTileEntity();

    public static boolean isLantern(Item i) {
        if (i instanceof BlockItem) {
            Block b = ((BlockItem)i).func_179223_d();
            if (b.hasTileEntity(b.func_176223_P())) {
                return false;
            }
            String namespace = b.getRegistryName().func_110624_b();
            if (namespace.equals("skinnedlanterns")) {
                return true;
            }
            return b instanceof LanternBlock && !ServerConfigs.cached.WALL_LANTERN_BLACKLIST.contains(namespace);
        }
        return false;
    }

    public static boolean isCookie(Item i) {
        return i.func_206844_a(ModTags.COOKIES);
    }

    public static boolean isBrick(Item i) {
        return i.func_206844_a(ModTags.BRICKS);
    }

    public static boolean isCake(Item i) {
        return i == Items.field_222070_lD;
    }

    public static boolean isPot(Item i) {
        if (i instanceof BlockItem) {
            Block b = ((BlockItem)i).func_179223_d();
            return b instanceof FlowerPotBlock;
        }
        return false;
    }

    public static AxisAlignedBB getDirectionBB(BlockPos pos, Direction facing, int offset) {
        BlockPos endPos = pos.func_177967_a(facing, offset);
        switch (facing) {
            default: {
                endPos = endPos.func_177982_a(1, 1, 0);
                break;
            }
            case SOUTH: {
                endPos = endPos.func_177982_a(1, 1, 1);
                pos = pos.func_177982_a(0, 0, 1);
                break;
            }
            case UP: {
                endPos = endPos.func_177982_a(1, 1, 1);
                pos = pos.func_177982_a(0, 1, 0);
                break;
            }
            case EAST: {
                endPos = endPos.func_177982_a(1, 1, 1);
                pos = pos.func_177982_a(1, 0, 0);
                break;
            }
            case WEST: {
                endPos = endPos.func_177982_a(0, 1, 1);
                break;
            }
            case DOWN: {
                endPos = endPos.func_177982_a(1, 0, 1);
            }
        }
        return new AxisAlignedBB(pos, endPos);
    }

    public static boolean isShapeEqual(AxisAlignedBB s1, AxisAlignedBB s2) {
        return s1.field_72340_a == s2.field_72340_a && s1.field_72338_b == s2.field_72338_b && s1.field_72339_c == s2.field_72339_c && s1.field_72336_d == s2.field_72336_d && s1.field_72337_e == s2.field_72337_e && s1.field_72334_f == s2.field_72334_f;
    }

    public static int getPostSize(BlockState state, BlockPos pos, IWorldReader world) {
        Block block2 = state.func_177230_c();
        VoxelShape shape = state.func_196954_c((IBlockReader)world, pos);
        if (shape != VoxelShapes.func_197880_a()) {
            AxisAlignedBB s = shape.func_197752_a();
            if (block2 instanceof FenceBlock || block2 instanceof SignPostBlock || block2.func_203417_a((ITag)Tags.Blocks.FENCES) || CommonUtil.isShapeEqual(FENCE_SHAPE, s)) {
                return 1;
            }
            if (block2 instanceof WallBlock || block2.func_203417_a((ITag)BlockTags.field_219757_z) || CommonUtil.isShapeEqual(WALL_SHAPE, s)) {
                return 2;
            }
            if (CommonUtil.isShapeEqual(POST_SHAPE, s)) {
                return 1;
            }
        }
        return 0;
    }

    public static boolean isVertical(BlockState state) {
        if (state.func_235901_b_((Property)BlockStateProperties.field_208148_A)) {
            return state.func_177229_b((Property)BlockStateProperties.field_208148_A) == Direction.Axis.Y;
        }
        return true;
    }

    public static boolean isNotExtended(BlockState state) {
        if (state.func_235901_b_((Property)BlockStateProperties.field_208181_h)) {
            return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208181_h) == false;
        }
        return true;
    }

    public static boolean isPost(BlockState state) {
        return CommonUtil.isVertical(state) && CommonUtil.isNotExtended(state) && state.func_235714_a_(ModTags.POSTS);
    }

    public static boolean isAllowedInShulker(ItemStack stack) {
        return SHULKER_TILE.func_180462_a(0, stack, null);
    }

    public static boolean withinDistanceDown(BlockPos pos, Vector3d vector, double distW, double distDown) {
        double dx = vector.func_82615_a() - ((double)pos.func_177958_n() + 0.5);
        double dy = vector.func_82617_b() - ((double)pos.func_177956_o() + 0.5);
        double dz = vector.func_82616_c() - ((double)pos.func_177952_p() + 0.5);
        double mydistW = dx * dx + dz * dz;
        return mydistW < distW * distW && dy < distW && dy > -distDown;
    }

    public static boolean canPlace(BlockItemUseContext context, BlockState state) {
        PlayerEntity playerentity = context.func_195999_j();
        ISelectionContext iselectioncontext = playerentity == null ? ISelectionContext.func_216377_a() : ISelectionContext.func_216374_a((Entity)playerentity);
        return state.func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a()) && context.func_195991_k().func_226663_a_(state, context.func_195995_a(), iselectioncontext);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static PlayerEntity getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public static enum Festivity {
        NONE,
        HALLOWEEN,
        APRILS_FOOL,
        CHRISTMAS,
        EARTH_DAY,
        ST_VALENTINE;


        public boolean isHalloween() {
            return this == HALLOWEEN;
        }

        public boolean isAprilsFool() {
            return this == APRILS_FOOL;
        }

        public boolean isStValentine() {
            return this == ST_VALENTINE;
        }

        public boolean isChristmas() {
            return this == CHRISTMAS;
        }

        public boolean isEarthDay() {
            return this == EARTH_DAY;
        }

        private static Festivity get() {
            Calendar calendar = Calendar.getInstance();
            if (calendar.get(2) == 9 && calendar.get(5) >= 29 || calendar.get(2) == 10 && calendar.get(5) <= 1) {
                return HALLOWEEN;
            }
            if (calendar.get(2) == 3 && calendar.get(5) == 1) {
                return APRILS_FOOL;
            }
            if (calendar.get(2) == 1 && calendar.get(5) == 14) {
                return ST_VALENTINE;
            }
            if (calendar.get(2) == 3 && calendar.get(5) == 22) {
                return EARTH_DAY;
            }
            if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26) {
                return CHRISTMAS;
            }
            return NONE;
        }

        static /* synthetic */ Festivity access$000() {
            return Festivity.get();
        }
    }
}

