/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.compat.configured;

import com.electronwill.nightconfig.core.AbstractConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mrcrayfish.configured.client.screen.ConfigScreen;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import joptsimple.internal.Strings;
import net.mehvahdjukaar.supplementaries.common.Textures;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.RegistryConfigs;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.datagen.types.VanillaWoodTypes;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.commons.lang3.StringUtils;

public class ConfiguredCustomScreen
extends ConfigScreen {
    private static final Map<String, ItemStack> ICONS = new HashMap<String, ItemStack>();
    private final ItemStack MAIN_ICON = new ItemStack((IItemProvider)ModRegistry.GLOBE_ITEM.get());
    private ConfigScreen.ConfigList list = null;

    public static void openScreen() {
        ServerConfigs.loadLocal();
        ConfiguredCustomScreen.openScreen(Minecraft.func_71410_x());
    }

    private static void openScreen(Minecraft mc) {
        mc.func_147108_a((Screen)new ConfiguredCustomScreen(mc.field_71462_r));
    }

    private static void addIcon(String s, Item i) {
        ICONS.put(s, new ItemStack((IItemProvider)i));
    }

    public static void registerScreen() {
        ModContainer container = (ModContainer)ModList.get().getModContainerById("supplementaries").get();
        container.registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (mc, screen) -> new ConfiguredCustomScreen((Screen)screen));
    }

    public ConfiguredCustomScreen(Screen parent) {
        super(parent, "\u00a76Supplementaries Configured", Collections.singletonList(new ConfigScreen.ConfigFileEntry(ClientConfigs.CLIENT_SPEC, ClientConfigs.CLIENT_SPEC.getValues())), Arrays.asList(new ConfigScreen.ConfigFileEntry(ServerConfigs.SERVER_SPEC, ServerConfigs.SERVER_SPEC.getValues()), new ConfigScreen.ConfigFileEntry(RegistryConfigs.REGISTRY_CONFIG, RegistryConfigs.REGISTRY_CONFIG.getValues())), Textures.CONFIG_BACKGROUND);
    }

    public ConfiguredCustomScreen(Screen parent, String displayName, ForgeConfigSpec spec, UnmodifiableConfig values) {
        super(parent, displayName, new ConfigScreen.ConfigFileEntry(spec, values), Textures.CONFIG_BACKGROUND);
    }

    protected void func_231160_c_() {
        Field f2;
        super.func_231160_c_();
        try {
            f2 = ObfuscationReflectionHelper.findField(ConfigScreen.class, (String)"list");
            f2.setAccessible(true);
            this.list = (ConfigScreen.ConfigList)f2.get((Object)this);
        }
        catch (Exception f2) {
            // empty catch block
        }
        try {
            f2 = ObfuscationReflectionHelper.findField(ConfigScreen.SubMenu.class, (String)"button");
            f2.setAccessible(true);
        }
        catch (Exception e) {
            return;
        }
        List children = this.list.func_231039_at__();
        boolean isCommon = false;
        for (Object c : children) {
            if (!(c instanceof ConfigScreen.SubMenu)) continue;
            ConfigScreen.SubMenu subMenu = (ConfigScreen.SubMenu)c;
            if (!isCommon) {
                this.modifySubmenus(f2, subMenu, ClientConfigs.CLIENT_SPEC);
            } else {
                this.modifySubmenus(f2, subMenu, ServerConfigs.SERVER_SPEC);
            }
            if (!subMenu.getLabel().equals("Tweaks")) continue;
            isCommon = true;
        }
    }

    private void modifySubmenus(Field f, ConfigScreen.SubMenu subMenu, ForgeConfigSpec spec) {
        spec.getValues().valueMap().forEach((s, o) -> {
            if (o instanceof AbstractConfig) {
                String label = ConfiguredCustomScreen.createLabel(s);
                if (subMenu.getLabel().equals(label)) {
                    f.setAccessible(true);
                    try {
                        f.set(subMenu, new Button(10, 5, 44, 20, (ITextComponent)new StringTextComponent(label).func_240699_a_(TextFormatting.BOLD).func_240699_a_(TextFormatting.WHITE), onPress -> {
                            String newTitle = "\u00a76Supplementaries > " + label;
                            this.field_230706_i_.func_147108_a((Screen)new ConfiguredCustomScreen((Screen)this, newTitle, spec, (UnmodifiableConfig)o));
                        }));
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private static String createLabel(String input) {
        int i;
        String[] words = input.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");
        for (i = 0; i < words.length; ++i) {
            words[i] = StringUtils.capitalize((String)words[i]);
        }
        String valueName = Strings.join((String[])words, (String)" ");
        words = valueName.split("_");
        for (i = 0; i < words.length; ++i) {
            words[i] = StringUtils.capitalize((String)words[i]);
        }
        return Strings.join((String[])words, (String)" ");
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (ScreenUtil.isMouseWithin((int)(this.field_230708_k_ / 2 - 90), (int)2, (int)180, (int)16, (int)mouseX, (int)mouseY)) {
            this.func_238654_b_(matrixStack, this.field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)new TranslationTextComponent("supplementaries.gui.info"), 200), mouseX, mouseY);
        }
        Minecraft.func_71410_x().func_175599_af().func_239390_c_(this.MAIN_ICON, this.field_230708_k_ / 2 + 90 - 17, 2);
        Minecraft.func_71410_x().func_175599_af().func_239390_c_(this.MAIN_ICON, this.field_230708_k_ / 2 - 90, 2);
        if (this.list != null) {
            double scrollAmount;
            try {
                Field f = ObfuscationReflectionHelper.findField(AbstractList.class, (String)"field_230678_o_");
                f.setAccessible(true);
                scrollAmount = (Double)f.get(this.list);
            }
            catch (Exception e) {
                return;
            }
            List children = this.list.func_231039_at__();
            int y0 = 50;
            int y1 = this.field_230709_l_ - 36;
            int itemHeight = 24;
            int headerHeight = 0;
            int size = children.size();
            for (int index = 0; index < size; ++index) {
                int top = y0 + 6 - (int)scrollAmount + index * itemHeight + headerHeight;
                if (top < y0 || top + itemHeight > y1 + 8 || !(children.get(index) instanceof ConfigScreen.SubMenu)) continue;
                ConfigScreen.SubMenu button = (ConfigScreen.SubMenu)children.get(index);
                ItemStack icon = ICONS.getOrDefault(button.getLabel().toLowerCase(), this.MAIN_ICON);
                int center = this.list.func_230968_n_() + this.list.func_230949_c_() / 2;
                Minecraft.func_71410_x().func_175599_af().func_239390_c_(icon, center + 90 - 17, top);
                Minecraft.func_71410_x().func_175599_af().func_239390_c_(icon, center - 90, top);
            }
        }
    }

    public void func_230446_a_(MatrixStack p_230446_1_) {
    }

    public void func_238651_a_(MatrixStack p_238651_1_, int p_238651_2_) {
    }

    public void func_231165_f_(int vOffset) {
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        ClientConfigs.cached.refresh();
        ServerConfigs.cached.refresh();
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (ScreenUtil.isMouseWithin((int)(this.field_230708_k_ / 2 - 90), (int)2, (int)180, (int)16, (int)((int)mouseX), (int)((int)mouseY))) {
            Style style = Style.field_240709_b_.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/supplementaries"));
            this.func_230455_a_(style);
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    static {
        ConfiguredCustomScreen.addIcon("blocks", Items.field_221581_i);
        ConfiguredCustomScreen.addIcon("entities", Items.field_151116_aA);
        ConfiguredCustomScreen.addIcon("general", Items.field_151122_aG);
        ConfiguredCustomScreen.addIcon("particles", Items.field_151065_br);
        ConfiguredCustomScreen.addIcon("items", Items.field_196128_bn);
        ConfiguredCustomScreen.addIcon("spawns", Items.field_221943_hD);
        ConfiguredCustomScreen.addIcon("tweaks", Items.field_221824_dv);
        ConfiguredCustomScreen.addIcon("captured mobs", Items.field_196161_cu);
        ConfiguredCustomScreen.addIcon("clock block", (Item)ModRegistry.CLOCK_BLOCK_ITEM.get());
        ConfiguredCustomScreen.addIcon("firefly jar", (Item)ModRegistry.FIREFLY_JAR_ITEM.get());
        ConfiguredCustomScreen.addIcon("flag", (Item)ModRegistry.FLAGS_ITEMS.get(DyeColor.WHITE).get());
        ConfiguredCustomScreen.addIcon("globe", (Item)ModRegistry.GLOBE_ITEM.get());
        ConfiguredCustomScreen.addIcon("item shelf", (Item)ModRegistry.ITEM_SHELF_ITEM.get());
        ConfiguredCustomScreen.addIcon("pedestal", (Item)ModRegistry.PEDESTAL_ITEM.get());
        ConfiguredCustomScreen.addIcon("wind vane", (Item)ModRegistry.WIND_VANE_ITEM.get());
        ConfiguredCustomScreen.addIcon("pedestal", (Item)ModRegistry.PEDESTAL_ITEM.get());
        ConfiguredCustomScreen.addIcon("firefly", (Item)ModRegistry.FIREFLY_SPAWN_EGG_ITEM.get());
        ConfiguredCustomScreen.addIcon("firefly glow", (Item)ModRegistry.FIREFLY_JAR_ITEM.get());
        ConfiguredCustomScreen.addIcon("bellows", (Item)ModRegistry.BELLOWS_ITEM.get());
        ConfiguredCustomScreen.addIcon("blackboard", (Item)ModRegistry.BLACKBOARD_ITEM.get());
        ConfiguredCustomScreen.addIcon("cage", (Item)ModRegistry.CAGE_ITEM.get());
        ConfiguredCustomScreen.addIcon("candle holder", (Item)ModRegistry.CANDLE_HOLDER_ITEM.get());
        ConfiguredCustomScreen.addIcon("jar", (Item)ModRegistry.JAR_ITEM.get());
        ConfiguredCustomScreen.addIcon("notice board", (Item)ModRegistry.NOTICE_BOARD_ITEM.get());
        ConfiguredCustomScreen.addIcon("sack", (Item)ModRegistry.SACK_ITEM.get());
        ConfiguredCustomScreen.addIcon("safe", (Item)ModRegistry.SAFE_ITEM.get());
        ConfiguredCustomScreen.addIcon("speaker block", (Item)ModRegistry.SPEAKER_BLOCK_ITEM.get());
        ConfiguredCustomScreen.addIcon("spring launcher", (Item)ModRegistry.PISTON_LAUNCHER_ITEM.get());
        ConfiguredCustomScreen.addIcon("turn table", (Item)ModRegistry.TURN_TABLE_ITEM.get());
        ConfiguredCustomScreen.addIcon("flute", (Item)ModRegistry.FLUTE_ITEM.get());
        ConfiguredCustomScreen.addIcon("rope arrow", (Item)ModRegistry.ROPE_ARROW_ITEM.get());
        ConfiguredCustomScreen.addIcon("structures", (Item)ModRegistry.SIGN_POST_ITEMS.get(VanillaWoodTypes.OAK).get());
        ConfiguredCustomScreen.addIcon("bells tweaks", Items.field_222109_pP);
        ConfiguredCustomScreen.addIcon("cake tweaks", Items.field_222070_lD);
        ConfiguredCustomScreen.addIcon("hanging flower pots", Items.field_222087_nH);
        ConfiguredCustomScreen.addIcon("throwable bricks", Items.field_151118_aC);
        ConfiguredCustomScreen.addIcon("wall lantern", Items.field_222111_pQ);
        ConfiguredCustomScreen.addIcon("placeable sticks", Items.field_151055_y);
        ConfiguredCustomScreen.addIcon("brewing stand colors", Items.field_222088_mr);
        ConfiguredCustomScreen.addIcon("timber frame", (Item)ModRegistry.TIMBER_BRACE_ITEM.get());
        ConfiguredCustomScreen.addIcon("raked gravel", (Item)ModRegistry.RAKED_GRAVEL_ITEM.get());
        ConfiguredCustomScreen.addIcon("bottle xp", Items.field_151062_by);
        ConfiguredCustomScreen.addIcon("hourglass", (Item)ModRegistry.HOURGLASS_ITEM.get());
        ConfiguredCustomScreen.addIcon("map tweaks", Items.field_151098_aY);
        ConfiguredCustomScreen.addIcon("ceiling banners", Items.field_196205_eu);
        ConfiguredCustomScreen.addIcon("initialization", (Item)ModRegistry.COG_BLOCK_ITEM.get());
        ConfiguredCustomScreen.addIcon("iron gate", (Item)ModRegistry.IRON_GATE_ITEM.get());
        ConfiguredCustomScreen.addIcon("zombie horse", Items.field_151078_bh);
        ConfiguredCustomScreen.addIcon("bomb", (Item)ModRegistry.BOMB_ITEM.get());
        ConfiguredCustomScreen.addIcon("placeable gunpowder", Items.field_151016_H);
        ConfiguredCustomScreen.addIcon("slingshot", (Item)ModRegistry.SLINGSHOT_ITEM.get());
    }
}

