/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.compat.flywheel.instances;

import com.jozufozu.flywheel.backend.instancing.IDynamicInstance;
import com.jozufozu.flywheel.backend.instancing.tile.TileEntityInstance;
import com.jozufozu.flywheel.backend.material.MaterialManager;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.IFlatLight;
import com.jozufozu.flywheel.core.materials.ModelData;
import com.jozufozu.flywheel.core.model.ModelPart;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import com.jozufozu.flywheel.util.transform.MatrixTransformStack;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.mehvahdjukaar.supplementaries.block.blocks.BellowsBlock;
import net.mehvahdjukaar.supplementaries.block.tiles.BellowsBlockTile;
import net.mehvahdjukaar.supplementaries.client.renderers.Const;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3i;

public class BellowsInstance
extends TileEntityInstance<BellowsBlockTile>
implements IDynamicInstance {
    private final TextureAtlasSprite texture = net.mehvahdjukaar.supplementaries.client.Materials.BELLOWS_MATERIAL.func_229314_c_();
    private final ModelData center;
    private final ModelData top;
    private final ModelData bottom;
    private final ModelData leather;
    private MatrixTransformStack stack;
    private float lastProgress = 0.0f;

    public BellowsInstance(MaterialManager<?> materialManager, BellowsBlockTile tile) {
        super(materialManager, (TileEntity)tile);
        Quaternion rotation = this.getDirection().func_229384_a_();
        this.stack = new MatrixTransformStack();
        this.stack.translate((Vector3i)this.getInstancePosition()).scale(0.9995f).translateAll(2.5E-4).centre().multiply(rotation).multiply(Const.X90);
        this.center = this.makeCenterInstance().setTransform(this.stack.unwrap());
        this.stack.unCentre();
        this.leather = this.makeLeatherInstance().setTransform(this.stack.unwrap());
        this.top = this.makeTopInstance().setTransform(this.stack.unwrap());
        this.bottom = this.makeBottomInstance().setTransform(this.stack.unwrap());
    }

    public void beginFrame() {
        float dh = MathHelper.func_219799_g((float)AnimationTickHolder.getPartialTicks(), (float)((BellowsBlockTile)this.tile).prevHeight, (float)((BellowsBlockTile)this.tile).height);
        this.stack.push();
        this.stack.centre();
        this.stack.push();
        this.stack.translate(0.0, -0.8125 - (double)dh, 0.0);
        this.top.setTransform(this.stack.unwrap());
        this.stack.pop();
        this.stack.push();
        this.stack.translate(0.0, (double)dh, 0.0);
        this.bottom.setTransform(this.stack.unwrap());
        this.stack.pop();
        float j = 3.2f;
        MatrixTransformStack old = this.stack;
        MatrixStack s = this.stack.unwrap();
        s.func_227862_a_(1.0f, 1.0f + j * dh, 1.0f);
        this.stack = new MatrixTransformStack(s);
        this.leather.setTransform(this.stack.unwrap());
        this.stack = old;
        this.stack.pop();
    }

    public void remove() {
        this.top.delete();
        this.leather.delete();
        this.center.delete();
        this.bottom.delete();
    }

    public void updateLight() {
        this.relight(this.pos, new IFlatLight[]{this.top, this.center, this.leather, this.bottom});
    }

    private ModelData makeTopInstance() {
        return (ModelData)this.materialManager.defaultCutout().material(Materials.TRANSFORMED).model((Object)("top_" + ((BellowsBlockTile)this.tile).func_200662_C()), this::makeLidModel).createInstance();
    }

    private ModelData makeBottomInstance() {
        return (ModelData)this.materialManager.defaultCutout().material(Materials.TRANSFORMED).model((Object)("bottom_" + ((BellowsBlockTile)this.tile).func_200662_C()), this::makeLidModel).createInstance();
    }

    private ModelData makeLeatherInstance() {
        return (ModelData)this.materialManager.defaultCutout().material(Materials.TRANSFORMED).model((Object)("leather_" + ((BellowsBlockTile)this.tile).func_200662_C()), this::makeLeatherModel).createInstance();
    }

    private ModelData makeCenterInstance() {
        return (ModelData)this.materialManager.defaultCutout().material(Materials.TRANSFORMED).model((Object)("center_" + ((BellowsBlockTile)this.tile).func_200662_C()), this::makeCenterModel).createInstance();
    }

    private ModelPart makeLeatherModel() {
        return ModelPart.builder((int)64, (int)64).sprite(this.texture).cuboid().textureOffset(0, 37).start(-7.0f, -5.0f, -7.0f).size(14.0f, 10.0f, 14.0f).endCuboid().build();
    }

    private ModelPart makeLidModel() {
        return ModelPart.builder((int)64, (int)64).sprite(this.texture).cuboid().textureOffset(0, 0).start(-8.0f, 5.0f, -8.0f).size(16.0f, 3.0f, 16.0f).endCuboid().build();
    }

    private ModelPart makeCenterModel() {
        return ModelPart.builder((int)64, (int)64).sprite(this.texture).cuboid().textureOffset(0, 0).start(-2.0f, -2.0f, -8.0f).size(4.0f, 1.0f, 1.0f).endCuboid().cuboid().textureOffset(0, 2).start(-2.0f, 1.0f, -8.0f).size(4.0f, 1.0f, 1.0f).endCuboid().cuboid().textureOffset(0, 19).start(-8.0f, -1.0f, -8.0f).size(16.0f, 2.0f, 16.0f).endCuboid().build();
    }

    private Direction getDirection() {
        return (Direction)this.blockState.func_177229_b((Property)BellowsBlock.FACING);
    }
}

