/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.entities;

import java.util.Random;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.entities.ImprovedProjectileEntity;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.mehvahdjukaar.supplementaries.world.explosion.BombExplosion;
import net.minecraft.block.BlockState;
import net.minecraft.block.TNTBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.ExplosionContext;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class BombEntity
extends ImprovedProjectileEntity
implements IEntityAdditionalSpawnData {
    private boolean blue;
    private boolean active = true;
    private int changeTimer = -1;
    private boolean superCharged = false;

    public BombEntity(EntityType<? extends BombEntity> type, World world) {
        super(type, world);
    }

    public BombEntity(World worldIn, LivingEntity throwerIn, boolean blue) {
        super((EntityType<? extends ProjectileItemEntity>)((EntityType)ModRegistry.BOMB.get()), throwerIn, worldIn);
        this.blue = blue;
        this.maxAge = 200;
    }

    public BombEntity(World worldIn, double x, double y, double z, boolean blue) {
        super((EntityType<? extends ProjectileItemEntity>)((EntityType)ModRegistry.BOMB.get()), x, y, z, worldIn);
        this.blue = blue;
        this.maxAge = 200;
    }

    public BombEntity(FMLPlayMessages.SpawnEntity packet, World world) {
        super((EntityType<? extends ProjectileItemEntity>)((EntityType)ModRegistry.BOMB.get()), world);
        this.maxAge = 200;
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Active", this.active);
        compound.func_74757_a("Blue", this.blue);
        compound.func_74768_a("Timer", this.changeTimer);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.active = compound.func_74767_n("Active");
        this.blue = compound.func_74767_n("Blue");
        this.changeTimer = compound.func_74762_e("Timer");
    }

    public void readSpawnData(PacketBuffer buffer) {
        this.blue = buffer.readBoolean();
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeBoolean(this.blue);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected Item func_213885_i() {
        return (Item)ModRegistry.BOMB_ITEM_ON.get();
    }

    public ItemStack func_184543_l() {
        return this.blue ? new ItemStack(this.active ? (IItemProvider)ModRegistry.BOMB_BLUE_ITEM_ON.get() : (IItemProvider)ModRegistry.BOMB_BLUE_ITEM.get()) : new ItemStack(this.active ? (IItemProvider)ModRegistry.BOMB_ITEM_ON.get() : (IItemProvider)ModRegistry.BOMB_ITEM.get());
    }

    private void spawnBreakParticles() {
        for (int i = 0; i < 8; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)ModRegistry.BOMB_ITEM.get())), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
    }

    public void func_70103_a(byte id) {
        switch (id) {
            default: {
                super.func_70103_a(id);
                break;
            }
            case 3: {
                this.spawnBreakParticles();
                break;
            }
            case 10: {
                this.spawnBreakParticles();
                this.field_70170_p.func_195594_a((IParticleData)ModRegistry.BOMB_EXPLOSION_PARTICLE_EMITTER.get(), this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_(), this.blue ? 5.25 : (double)ServerConfigs.cached.BOMB_RADIUS, 0.0, 0.0);
                if (!this.blue) break;
                float d22 = 0.0f;
                while ((double)d22 < Math.PI * 2) {
                    Vector3d v = new Vector3d(0.55, 0.0, 0.0);
                    v = v.func_178785_b(d22 + this.field_70146_Z.nextFloat() * 0.3f);
                    v = v.func_242988_c((float)((double)this.field_70146_Z.nextFloat() * Math.PI));
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_(), v.field_72450_a, v.field_72448_b, v.field_72449_c);
                    d22 += 0.15707964f;
                }
                break;
            }
            case 68: {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218419_B, this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_(), 0.0, 0.0, 0.0);
                break;
            }
            case 67: {
                Random random = this.field_70170_p.func_201674_k();
                for (int i = 0; i < 10; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_() + 0.25 - (double)(random.nextFloat() * 0.5f), this.func_226278_cu_() + (double)0.45f - (double)(random.nextFloat() * 0.5f), this.func_226281_cx_() + 0.25 - (double)(random.nextFloat() * 0.5f), 0.0, 0.005, 0.0);
                }
                this.active = false;
            }
        }
    }

    public double r() {
        return this.field_70146_Z.nextGaussian() * 0.05;
    }

    @Override
    public boolean hasReachedEndOfLife() {
        return super.hasReachedEndOfLife() || this.changeTimer == 0;
    }

    @Override
    public void func_70071_h_() {
        if (this.changeTimer > 0) {
            --this.changeTimer;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_213303_ch().field_72450_a, this.func_213303_ch().field_72448_b + 0.5, this.func_213303_ch().field_72449_c, 0.0, 0.0, 0.0);
        }
        if (this.active && this.func_70090_H() && !this.blue) {
            this.turnOff();
        }
        super.func_70071_h_();
    }

    @Override
    public void spawnTrailParticles(Vector3d currentPos, Vector3d newPos) {
        if (this.active && !this.field_70148_d) {
            double x = currentPos.field_72450_a;
            double y = currentPos.field_72448_b;
            double z = currentPos.field_72449_c;
            double dx = newPos.field_72450_a - x;
            double dy = newPos.field_72448_b - y;
            double dz = newPos.field_72449_c - z;
            int s = 4;
            for (int i = 0; i < s; ++i) {
                double j = (double)i / (double)s;
                this.field_70170_p.func_195594_a((IParticleData)ModRegistry.BOMB_SMOKE_PARTICLE.get(), x + dx * j, 0.5 + y + dy * j, z + dz * j, 0.0, 0.02, 0.0);
            }
        }
    }

    public static boolean canBreakBlock(IBlockReader world, BlockPos pos, BlockState state, float power) {
        switch (ServerConfigs.cached.BOMB_BREAKS) {
            default: {
                return false;
            }
            case ALL: {
                return true;
            }
            case WEAK: 
        }
        return state.func_227032_a_((Fluid)Fluids.field_204546_a) || state.func_177230_c() instanceof TNTBlock;
    }

    protected void func_213868_a(EntityRayTraceResult hit) {
        super.func_213868_a(hit);
        hit.func_216348_a().func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_234616_v_()), 1.0f);
        if (hit.func_216348_a() instanceof FireballEntity) {
            this.superCharged = true;
            hit.func_216348_a().func_70106_y();
        }
    }

    public void turnOff() {
        if (!this.field_70170_p.func_201670_d()) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)67);
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187541_bC, SoundCategory.BLOCKS, 0.5f, 1.5f);
        }
        this.active = false;
    }

    public void func_70100_b_(PlayerEntity entityIn) {
        if (!this.field_70170_p.field_72995_K && !this.active && entityIn.field_71071_by.func_70441_a(this.getItemStack())) {
            entityIn.func_71001_a((Entity)this, 1);
            this.func_70106_y();
        }
    }

    private ItemStack getItemStack() {
        return new ItemStack((IItemProvider)ModRegistry.BOMB_ITEM.get());
    }

    protected void func_230299_a_(BlockRayTraceResult hit) {
        super.func_230299_a_(hit);
        Vector3d vector3d = hit.func_216347_e().func_178786_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        this.func_213317_d(vector3d);
        Vector3d vector3d1 = vector3d.func_72432_b().func_186678_a((double)this.func_70185_h());
        this.func_226288_n_(this.func_226277_ct_() - vector3d1.field_72450_a, this.func_226278_cu_() - vector3d1.field_72448_b, this.func_226281_cx_() - vector3d1.field_72449_c);
    }

    protected float func_70185_h() {
        return 0.05f;
    }

    protected void func_70227_a(RayTraceResult result) {
        super.func_70227_a(result);
        if (!this.field_70170_p.field_72995_K) {
            if (this.blue && this.changeTimer == -1) {
                this.changeTimer = 10;
                this.field_70170_p.func_72960_a((Entity)this, (byte)68);
                this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187649_bu, SoundCategory.NEUTRAL, 1.5f, 1.3f);
            }
            if (!(this.field_70128_L || this.blue && !this.superCharged)) {
                this.reachedEndOfLife();
            }
        }
    }

    protected void func_234617_x_() {
    }

    @Override
    public void reachedEndOfLife() {
        if (this.active) {
            this.createExplosion();
            this.field_70170_p.func_72960_a((Entity)this, (byte)10);
        } else {
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
        }
        this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_232775_jf_, SoundCategory.NEUTRAL, 1.5f, 1.5f);
        this.func_70106_y();
    }

    private void createExplosion() {
        boolean breaks;
        boolean bl = breaks = this.func_234616_v_() instanceof PlayerEntity || ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this.func_234616_v_());
        if (this.superCharged) {
            this.field_70170_p.func_217398_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 6.0f, breaks, breaks ? Explosion.Mode.DESTROY : Explosion.Mode.NONE);
        }
        BombExplosion explosion = new BombExplosion(this.field_70170_p, (Entity)this, null, new ExplosionContext(){

            public boolean func_230311_a_(Explosion explosion, IBlockReader reader, BlockPos pos, BlockState state, float power) {
                return BombEntity.canBreakBlock(reader, pos, state, power);
            }
        }, this.func_226277_ct_(), this.func_226278_cu_() + 0.25, this.func_226281_cx_(), this.blue ? 5.0f : ServerConfigs.cached.BOMB_RADIUS, this.blue, breaks ? Explosion.Mode.BREAK : Explosion.Mode.NONE);
        explosion.func_77278_a();
        explosion.doFinalizeExplosion();
    }

    public static enum breakingMode {
        ALL,
        WEAK,
        NONE;

    }
}

