/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.entities;

import net.mehvahdjukaar.supplementaries.block.blocks.RopeBlock;
import net.mehvahdjukaar.supplementaries.common.CommonUtil;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class RopeArrowEntity
extends AbstractArrowEntity {
    private int charges = 0;
    private BlockPos prevPlacedPos = null;

    public RopeArrowEntity(EntityType<? extends RopeArrowEntity> type, World world) {
        super(type, world);
    }

    public RopeArrowEntity(World worldIn, LivingEntity throwerIn, int charges) {
        super((EntityType)ModRegistry.ROPE_ARROW.get(), throwerIn, worldIn);
        this.charges = charges;
    }

    public RopeArrowEntity(World worldIn, double x, double y, double z, int charges) {
        super((EntityType)ModRegistry.ROPE_ARROW.get(), x, y, z, worldIn);
        this.charges = charges;
    }

    public RopeArrowEntity(World worldIn, double x, double y, double z) {
        super((EntityType)ModRegistry.ROPE_ARROW.get(), x, y, z, worldIn);
    }

    public RopeArrowEntity(FMLPlayMessages.SpawnEntity packet, World world) {
        super((EntityType)ModRegistry.ROPE_ARROW.get(), world);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Ropes", this.charges);
        if (this.prevPlacedPos != null) {
            compound.func_218657_a("PrevPlacedPos", (INBT)NBTUtil.func_186859_a((BlockPos)this.prevPlacedPos));
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.charges = compound.func_74762_e("Ropes");
        if (compound.func_74764_b("PrevPlacedPos")) {
            this.prevPlacedPos = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("PrevPlacedPos"));
        }
    }

    protected ItemStack func_184550_j() {
        if (this.charges != 0) {
            ItemStack stack = new ItemStack((IItemProvider)ModRegistry.ROPE_ARROW_ITEM.get());
            stack.func_196085_b(stack.func_77958_k() - this.charges);
            return stack;
        }
        return new ItemStack((IItemProvider)Items.field_151032_g);
    }

    protected void func_230299_a_(BlockRayTraceResult rayTraceResult) {
        super.func_230299_a_(rayTraceResult);
        Block ropeBlock = ServerConfigs.cached.ROPE_ARROW_BLOCK;
        if (this.charges <= 0) {
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.prevPlacedPos = null;
            Entity entity2 = this.func_234616_v_();
            PlayerEntity player = null;
            if (!(entity2 instanceof MobEntity) || this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b) || ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this.getEntity())) {
                BlockState state;
                BlockPos hitPos;
                Block hitBlock;
                if (entity2 instanceof PlayerEntity && ((PlayerEntity)entity2).func_175142_cm()) {
                    player = (PlayerEntity)entity2;
                }
                if ((hitBlock = this.field_70170_p.func_180495_p(hitPos = rayTraceResult.func_216350_a()).func_177230_c()) == ropeBlock && RopeBlock.addRope(hitPos, this.field_70170_p, player, Hand.MAIN_HAND, ropeBlock)) {
                    this.prevPlacedPos = hitPos;
                    this.removeCharge();
                    return;
                }
                hitBlock = this.field_70170_p.func_180495_p(hitPos = hitPos.func_177972_a(rayTraceResult.func_216354_b())).func_177230_c();
                if (hitBlock == ropeBlock && RopeBlock.addRope(hitPos, this.field_70170_p, player, Hand.MAIN_HAND, ropeBlock)) {
                    this.prevPlacedPos = hitPos;
                    this.removeCharge();
                    return;
                }
                ItemStack ropes = new ItemStack((IItemProvider)ropeBlock);
                BlockItemUseContext context = new BlockItemUseContext(this.field_70170_p, (PlayerEntity)entity2, Hand.MAIN_HAND, ropes, rayTraceResult);
                if (context.func_196011_b() && (state = ropeBlock.func_196258_a(context)) != null && CommonUtil.canPlace(context, state)) {
                    this.field_70170_p.func_180501_a(context.func_195995_a(), state, 11);
                    this.prevPlacedPos = context.func_195995_a();
                    this.removeCharge();
                }
            }
        }
    }

    private void removeCharge() {
        this.charges = Math.max(0, this.charges - 1);
        this.field_70170_p.func_184133_a(null, this.prevPlacedPos, SoundEvents.field_187748_db, SoundCategory.BLOCKS, 0.2f, 1.7f);
    }

    private void continueUnwindingRope() {
        BlockPos hitPos;
        Block hitBlock;
        Block ropeBlock = ServerConfigs.cached.ROPE_ARROW_BLOCK;
        PlayerEntity player = null;
        Entity entity2 = this.func_234616_v_();
        if (entity2 instanceof PlayerEntity && ((PlayerEntity)entity2).func_175142_cm()) {
            player = (PlayerEntity)entity2;
        }
        if ((hitBlock = this.field_70170_p.func_180495_p(hitPos = this.prevPlacedPos).func_177230_c()) == ropeBlock && RopeBlock.addRope(hitPos.func_177977_b(), this.field_70170_p, player, Hand.MAIN_HAND, ropeBlock)) {
            this.prevPlacedPos = hitPos.func_177977_b();
            this.removeCharge();
        } else {
            this.prevPlacedPos = null;
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.charges != 0 && this.prevPlacedPos != null) {
            this.continueUnwindingRope();
        }
    }
}

