/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.map.CustomDecorationHolder;
import net.mehvahdjukaar.selene.util.Utils;
import net.mehvahdjukaar.supplementaries.block.blocks.DirectionalCakeBlock;
import net.mehvahdjukaar.supplementaries.block.blocks.DoubleCakeBlock;
import net.mehvahdjukaar.supplementaries.block.blocks.JarBlock;
import net.mehvahdjukaar.supplementaries.block.tiles.JarBlockTile;
import net.mehvahdjukaar.supplementaries.common.CommonUtil;
import net.mehvahdjukaar.supplementaries.compat.CompatHandler;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.items.BlockHolderItem;
import net.mehvahdjukaar.supplementaries.items.FullJarItem;
import net.mehvahdjukaar.supplementaries.items.JarItem;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.EnchantingTableBlock;
import net.minecraft.block.SoundType;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BannerItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemsOverrideHandler {
    private static final Map<Item, ItemInteractionOverride> ON_BLOCK_OVERRIDES = new HashMap<Item, ItemInteractionOverride>();
    private static final Map<Item, ItemInteractionOverride> ITEM_OVERRIDES = new HashMap<Item, ItemInteractionOverride>();

    public static boolean hasBlockOverride(Item item2) {
        ItemInteractionOverride override = ON_BLOCK_OVERRIDES.get(item2);
        return override != null && override.getBlockOverride(item2) != null;
    }

    public static void registerOverrides() {
        ArrayList itemBehaviors = new ArrayList();
        ArrayList<ItemInteractionOverride> blockBehaviors = new ArrayList<ItemInteractionOverride>();
        blockBehaviors.add(new WallLanternBehavior());
        blockBehaviors.add(new MapMarkerBehavior());
        blockBehaviors.add(new CeilingBannersBehavior());
        blockBehaviors.add(new HangingPotBehavior());
        blockBehaviors.add(new EnhancedCakeBehavior());
        blockBehaviors.add(new PlaceableSticksBehavior());
        blockBehaviors.add(new PlaceableRodsBehavior());
        blockBehaviors.add(new XpBottlingBehavior());
        blockBehaviors.add(new PlaceableGunpowderBehavior());
        block0: for (Item i : ForgeRegistries.ITEMS) {
            for (ItemInteractionOverride b : blockBehaviors) {
                if (!b.appliesToItem(i)) continue;
                Block block2 = b.getBlockOverride(i);
                if (b != null) {
                    Item.field_179220_a.put(block2, i);
                }
                ON_BLOCK_OVERRIDES.put(i, b);
                break;
            }
            for (ItemInteractionOverride b : itemBehaviors) {
                if (!b.appliesToItem(i)) continue;
                ITEM_OVERRIDES.put(i, b);
                continue block0;
            }
        }
    }

    public static void tryPerformOverride(PlayerInteractEvent.RightClickBlock event, ItemStack stack, boolean isRanged) {
        ActionResultType result;
        Item item2 = stack.func_77973_b();
        ItemInteractionOverride override = ON_BLOCK_OVERRIDES.get(item2);
        if (override != null && override.isEnabled() && (result = override.tryPerformingAction(event.getWorld(), event.getPlayer(), event.getHand(), stack, event.getHitVec(), isRanged)) != ActionResultType.PASS) {
            event.setCanceled(true);
            event.setCancellationResult(result);
        }
    }

    public static void tryPerformOverride(PlayerInteractEvent.RightClickItem event, ItemStack stack, boolean isRanged) {
        ActionResultType result;
        Item item2 = stack.func_77973_b();
        ItemInteractionOverride override = ITEM_OVERRIDES.get(item2);
        if (override != null && override.isEnabled() && (result = override.tryPerformingAction(event.getWorld(), event.getPlayer(), event.getHand(), stack, null, isRanged)) != ActionResultType.PASS) {
            event.setCanceled(true);
            event.setCancellationResult(result);
        }
    }

    public static void addOverrideTooltips(ItemTooltipEvent event) {
        Item item2 = event.getItemStack().func_77973_b();
        ItemInteractionOverride override = ON_BLOCK_OVERRIDES.get(item2);
        if (override != null && override.isEnabled()) {
            List tooltip = event.getToolTip();
            TextComponent t = override.getTooltip();
            if (t != null) {
                tooltip.add(t.func_240699_a_(TextFormatting.GRAY).func_240699_a_(TextFormatting.ITALIC));
            }
        } else if (ServerConfigs.cached.THROWABLE_BRICKS_ENABLED && CommonUtil.isBrick(item2)) {
            event.getToolTip().add(new TranslationTextComponent("message.supplementaries.throwable_brick").func_240699_a_(TextFormatting.GRAY).func_240699_a_(TextFormatting.ITALIC));
        }
    }

    private static ActionResultType paceBlockOverride(Item itemOverride, PlayerEntity player, Hand hand, ItemStack heldStack, World world, BlockRayTraceResult raytrace, boolean isRanged) {
        if (raytrace.func_216354_b() != null) {
            BlockPos pos = raytrace.func_216350_a();
            ActionResultType result = ActionResultType.PASS;
            if (!player.func_225608_bj_() && !isRanged) {
                BlockState blockstate = world.func_180495_p(pos);
                result = blockstate.func_227031_a_(world, player, hand, raytrace);
            }
            if (!result.func_226246_a_()) {
                BlockItemUseContext ctx = new BlockItemUseContext(world, player, hand, heldStack, raytrace);
                if (itemOverride instanceof BlockHolderItem && heldStack.func_77973_b() instanceof BlockItem) {
                    result = ((BlockHolderItem)itemOverride).tryPlace(ctx, ((BlockItem)heldStack.func_77973_b()).func_179223_d());
                } else if (itemOverride instanceof BlockItem) {
                    result = ((BlockItem)itemOverride).func_195942_a(ctx);
                }
            }
            if (result.func_226246_a_() && player instanceof ServerPlayerEntity && !isRanged) {
                CriteriaTriggers.field_232607_M_.func_226695_a_((ServerPlayerEntity)player, pos, heldStack);
            }
            if (result == ActionResultType.FAIL) {
                return ActionResultType.PASS;
            }
            return result;
        }
        return ActionResultType.PASS;
    }

    private static class WallLanternBehavior
    extends ItemInteractionOverride {
        private WallLanternBehavior() {
        }

        @Override
        @Nullable
        public TextComponent getTooltip() {
            return new TranslationTextComponent("message.supplementaries.wall_lantern");
        }

        @Override
        @Nullable
        public Block getBlockOverride(Item i) {
            return (Block)ModRegistry.WALL_LANTERN.get();
        }

        @Override
        public boolean isEnabled() {
            return ServerConfigs.cached.WALL_LANTERN_PLACEMENT;
        }

        @Override
        public boolean appliesToItem(Item item2) {
            return CommonUtil.isLantern(item2);
        }

        @Override
        public ActionResultType tryPerformingAction(World world, PlayerEntity player, Hand hand, ItemStack stack, BlockRayTraceResult hit, boolean isRanged) {
            if (player.field_71075_bZ.field_75099_e) {
                double y;
                if (CompatHandler.torchslab && (y = hit.func_216347_e().func_82617_b() % 1.0) < 0.5) {
                    return ActionResultType.FAIL;
                }
                return ItemsOverrideHandler.paceBlockOverride((Item)ModRegistry.WALL_LANTERN_ITEM.get(), player, hand, stack, world, hit, isRanged);
            }
            return ActionResultType.PASS;
        }
    }

    private static class PlaceableGunpowderBehavior
    extends ItemInteractionOverride {
        private PlaceableGunpowderBehavior() {
        }

        @Override
        @Nullable
        public TextComponent getTooltip() {
            return new TranslationTextComponent("message.supplementaries.placeable");
        }

        @Override
        @Nullable
        public Block getBlockOverride(Item i) {
            return (Block)ModRegistry.GUNPOWDER_BLOCK.get();
        }

        @Override
        public boolean isEnabled() {
            return ServerConfigs.cached.PLACEABLE_GUNPOWDER;
        }

        @Override
        public boolean appliesToItem(Item item2) {
            return item2 == Items.field_151016_H;
        }

        @Override
        public ActionResultType tryPerformingAction(World world, PlayerEntity player, Hand hand, ItemStack stack, BlockRayTraceResult hit, boolean isRanged) {
            if (player.field_71075_bZ.field_75099_e) {
                return ItemsOverrideHandler.paceBlockOverride((Item)ModRegistry.GUNPOWDER_BLOCK_ITEM.get(), player, hand, stack, world, hit, isRanged);
            }
            return ActionResultType.PASS;
        }
    }

    private static class PlaceableRodsBehavior
    extends ItemInteractionOverride {
        private PlaceableRodsBehavior() {
        }

        @Override
        @Nullable
        public TextComponent getTooltip() {
            return new TranslationTextComponent("message.supplementaries.placeable");
        }

        @Override
        @Nullable
        public Block getBlockOverride(Item i) {
            return (Block)ModRegistry.BLAZE_ROD_BLOCK.get();
        }

        @Override
        public boolean isEnabled() {
            return ServerConfigs.cached.PLACEABLE_RODS;
        }

        @Override
        public boolean appliesToItem(Item item2) {
            return item2 == Items.field_151072_bj;
        }

        @Override
        public ActionResultType tryPerformingAction(World world, PlayerEntity player, Hand hand, ItemStack stack, BlockRayTraceResult hit, boolean isRanged) {
            if (player.field_71075_bZ.field_75099_e) {
                return ItemsOverrideHandler.paceBlockOverride((Item)ModRegistry.BLAZE_ROD_ITEM.get(), player, hand, stack, world, hit, isRanged);
            }
            return ActionResultType.PASS;
        }
    }

    private static class PlaceableSticksBehavior
    extends ItemInteractionOverride {
        private PlaceableSticksBehavior() {
        }

        @Override
        @Nullable
        public TextComponent getTooltip() {
            return new TranslationTextComponent("message.supplementaries.placeable");
        }

        @Override
        @Nullable
        public Block getBlockOverride(Item i) {
            return (Block)ModRegistry.STICK_BLOCK.get();
        }

        @Override
        public boolean isEnabled() {
            return ServerConfigs.cached.PLACEABLE_STICKS;
        }

        @Override
        public boolean appliesToItem(Item item2) {
            return item2 == Items.field_151055_y;
        }

        @Override
        public ActionResultType tryPerformingAction(World world, PlayerEntity player, Hand hand, ItemStack stack, BlockRayTraceResult hit, boolean isRanged) {
            if (player.field_71075_bZ.field_75099_e) {
                return ItemsOverrideHandler.paceBlockOverride((Item)ModRegistry.STICK_BLOCK_ITEM.get(), player, hand, stack, world, hit, isRanged);
            }
            return ActionResultType.PASS;
        }
    }

    private static class HangingPotBehavior
    extends ItemInteractionOverride {
        private HangingPotBehavior() {
        }

        @Override
        @Nullable
        public TextComponent getTooltip() {
            return new TranslationTextComponent("message.supplementaries.hanging_pot");
        }

        @Override
        @Nullable
        public Block getBlockOverride(Item i) {
            return (Block)ModRegistry.HANGING_FLOWER_POT.get();
        }

        @Override
        public boolean isEnabled() {
            return ServerConfigs.cached.HANGING_POT_PLACEMENT;
        }

        @Override
        public boolean appliesToItem(Item item2) {
            return CommonUtil.isPot(item2);
        }

        @Override
        public ActionResultType tryPerformingAction(World world, PlayerEntity player, Hand hand, ItemStack stack, BlockRayTraceResult hit, boolean isRanged) {
            if (player.field_71075_bZ.field_75099_e) {
                return ItemsOverrideHandler.paceBlockOverride((Item)ModRegistry.HANGING_FLOWER_POT_ITEM.get(), player, hand, stack, world, hit, isRanged);
            }
            return ActionResultType.PASS;
        }
    }

    private static class CeilingBannersBehavior
    extends ItemInteractionOverride {
        private CeilingBannersBehavior() {
        }

        @Override
        @Nullable
        public Block getBlockOverride(Item i) {
            if (i instanceof BannerItem) {
                return (Block)ModRegistry.CEILING_BANNERS.get(((BannerItem)i).func_195948_b()).get();
            }
            return null;
        }

        @Override
        public boolean isEnabled() {
            return ServerConfigs.cached.CEILING_BANNERS;
        }

        @Override
        public boolean appliesToItem(Item item2) {
            return item2 instanceof BannerItem;
        }

        @Override
        public ActionResultType tryPerformingAction(World world, PlayerEntity player, Hand hand, ItemStack stack, BlockRayTraceResult hit, boolean isRanged) {
            if (player.field_71075_bZ.field_75099_e) {
                return ItemsOverrideHandler.paceBlockOverride((Item)ModRegistry.CEILING_BANNERS_ITEMS.get(((BannerItem)stack.func_77973_b()).func_195948_b()).get(), player, hand, stack, world, hit, isRanged);
            }
            return ActionResultType.PASS;
        }
    }

    private static class EnhancedCakeBehavior
    extends ItemInteractionOverride {
        private EnhancedCakeBehavior() {
        }

        @Override
        @Nullable
        public TextComponent getTooltip() {
            return new TranslationTextComponent("message.supplementaries.double_cake");
        }

        @Override
        @Nullable
        public Block getBlockOverride(Item i) {
            return (Block)ModRegistry.DOUBLE_CAKE.get();
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public boolean appliesToItem(Item item2) {
            return CommonUtil.isCake(item2);
        }

        private ActionResultType placeDoubleCake(PlayerEntity player, ItemStack stack, BlockPos pos, World world, BlockState state, boolean isRanged) {
            boolean isDirectional;
            boolean bl = isDirectional = state.func_177230_c() == ModRegistry.DIRECTIONAL_CAKE.get();
            if (isDirectional && (Integer)state.func_177229_b((Property)DirectionalCakeBlock.field_176589_a) == 0 || state == Blocks.field_150414_aQ.func_176223_P()) {
                BlockState newState = (BlockState)((BlockState)((Block)ModRegistry.DOUBLE_CAKE.get()).func_176223_P().func_206870_a((Property)DoubleCakeBlock.FACING, (Comparable)(isDirectional ? (Direction)state.func_177229_b((Property)DoubleCakeBlock.FACING) : Direction.WEST))).func_206870_a((Property)DoubleCakeBlock.WATERLOGGED, (Comparable)Boolean.valueOf(world.func_204610_c(pos).func_206886_c() == Fluids.field_204546_a));
                if (!world.func_180501_a(pos, newState, 3)) {
                    return ActionResultType.FAIL;
                }
                if (player instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)player, pos, stack);
                }
                SoundType soundtype = newState.getSoundType((IWorldReader)world, pos, (Entity)player);
                world.func_184133_a(player, pos, newState.getSoundType((IWorldReader)world, pos, (Entity)player).func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                if (player == null || !player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                if (player instanceof ServerPlayerEntity && !isRanged) {
                    CriteriaTriggers.field_232607_M_.func_226695_a_((ServerPlayerEntity)player, pos, stack);
                }
                return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
            }
            return ActionResultType.PASS;
        }

        @Override
        public ActionResultType tryPerformingAction(World world, PlayerEntity player, Hand hand, ItemStack stack, BlockRayTraceResult hit, boolean isRanged) {
            BlockPos pos;
            BlockState state;
            Block b;
            if (player.field_71075_bZ.field_75099_e && ((b = (state = world.func_180495_p(pos = hit.func_216350_a())).func_177230_c()) == Blocks.field_150414_aQ || b == ModRegistry.DIRECTIONAL_CAKE.get())) {
                ActionResultType result = ActionResultType.FAIL;
                if (ServerConfigs.cached.DOUBLE_CAKE_PLACEMENT) {
                    result = this.placeDoubleCake(player, stack, pos, world, state, isRanged);
                }
                if (!result.func_226246_a_() && ServerConfigs.cached.DIRECTIONAL_CAKE) {
                    result = ItemsOverrideHandler.paceBlockOverride((Item)ModRegistry.DIRECTIONAL_CAKE_ITEM.get(), player, hand, stack, world, hit, isRanged);
                }
                return result;
            }
            return ActionResultType.PASS;
        }
    }

    private static class XpBottlingBehavior
    extends ItemInteractionOverride {
        private static final JarBlockTile DUMMY_JAR_TILE = new JarBlockTile();

        private XpBottlingBehavior() {
        }

        @Override
        public boolean isEnabled() {
            return ServerConfigs.cached.BOTTLE_XP;
        }

        @Override
        public boolean appliesToItem(Item item2) {
            return item2 == Items.field_151069_bo || item2 instanceof FullJarItem || item2 instanceof JarItem || item2 == Items.field_151062_by;
        }

        @Override
        public ActionResultType tryPerformingAction(World world, PlayerEntity player, Hand hand, ItemStack stack, BlockRayTraceResult hit, boolean isRanged) {
            BlockPos pos = hit.func_216350_a();
            Item i = stack.func_77973_b();
            if (world.func_180495_p(pos).func_177230_c() instanceof EnchantingTableBlock) {
                ItemStack returnStack = null;
                if (i == Items.field_151062_by) {
                    return ActionResultType.FAIL;
                }
                if (player.field_71068_ca > 0 || player.func_184812_l_()) {
                    if (i == Items.field_151069_bo) {
                        returnStack = new ItemStack((IItemProvider)Items.field_151062_by);
                    } else if (i instanceof JarItem || i instanceof FullJarItem) {
                        ItemStack tempStack;
                        ItemStack temp;
                        DUMMY_JAR_TILE.resetHolders();
                        CompoundNBT compoundnbt = stack.func_179543_a("BlockEntityTag");
                        if (compoundnbt != null) {
                            DUMMY_JAR_TILE.func_230337_a_(((BlockItem)i).func_179223_d().func_176223_P(), compoundnbt);
                        }
                        if (DUMMY_JAR_TILE.canInteractWithFluidHolder() && (temp = XpBottlingBehavior.DUMMY_JAR_TILE.fluidHolder.interactWithItem(tempStack = new ItemStack((IItemProvider)Items.field_151062_by), null, null, false)) != null && temp.func_77973_b() == Items.field_151069_bo) {
                            returnStack = ((JarBlock)((BlockItem)i).func_179223_d()).getJarItem(DUMMY_JAR_TILE);
                        }
                    }
                    if (returnStack != null) {
                        player.func_70097_a(CommonUtil.BOTTLING_DAMAGE, (float)ServerConfigs.cached.BOTTLING_COST);
                        Utils.swapItem((PlayerEntity)player, (Hand)hand, (ItemStack)returnStack);
                        if (!player.func_184812_l_()) {
                            player.func_195068_e(-Utils.getXPinaBottle((int)1, (Random)world.field_73012_v));
                        }
                        if (world.field_72995_K) {
                            Minecraft.func_71410_x().field_71452_i.func_199281_a((Entity)player, (IParticleData)ModRegistry.BOTTLING_XP_PARTICLE.get(), 1);
                        }
                        world.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187618_I, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
                    }
                }
            }
            return ActionResultType.PASS;
        }
    }

    private static class MapMarkerBehavior
    extends ItemInteractionOverride {
        private final List<Block> BLOCK_MARKERS = Arrays.asList(Blocks.field_235405_no_, Blocks.field_150427_aO, Blocks.field_150461_bJ, Blocks.field_205165_jY, Blocks.field_235400_nj_, Blocks.field_185775_db, Blocks.field_150384_bq);

        private MapMarkerBehavior() {
        }

        @Override
        public boolean isEnabled() {
            return ServerConfigs.cached.MAP_MARKERS;
        }

        @Override
        public boolean appliesToItem(Item item2) {
            return item2 instanceof FilledMapItem;
        }

        @Override
        public ActionResultType tryPerformingAction(World world, PlayerEntity player, Hand hand, ItemStack stack, BlockRayTraceResult hit, boolean isRanged) {
            BlockPos pos = hit.func_216350_a();
            Block b = world.func_180495_p(pos).func_177230_c();
            if (b instanceof BedBlock || this.BLOCK_MARKERS.contains(b)) {
                MapData data;
                if (!world.field_72995_K && (data = FilledMapItem.func_195950_a((ItemStack)stack, (World)world)) instanceof CustomDecorationHolder) {
                    ((CustomDecorationHolder)data).toggleCustomDecoration((IWorld)world, pos);
                }
                return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
            }
            return ActionResultType.PASS;
        }
    }

    private static abstract class ItemInteractionOverride {
        private ItemInteractionOverride() {
        }

        public abstract boolean isEnabled();

        public abstract boolean appliesToItem(Item var1);

        @Nullable
        public Block getBlockOverride(Item i) {
            return null;
        }

        @Nullable
        public TextComponent getTooltip() {
            return null;
        }

        public abstract ActionResultType tryPerformingAction(World var1, PlayerEntity var2, Hand var3, ItemStack var4, @Nullable BlockRayTraceResult var5, boolean var6);
    }
}

