/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.items;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.api.ICatchableMob;
import net.mehvahdjukaar.supplementaries.block.util.CapturedMobsHelper;
import net.mehvahdjukaar.supplementaries.block.util.MobHolder;
import net.mehvahdjukaar.supplementaries.common.ModTags;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class CageItem
extends BlockItem {
    private final float mobContainerHeight;
    private final float mobContainerWidth;

    public CageItem(Block blockIn, Item.Properties properties) {
        this(blockIn, properties, 0.875f, 1.0f);
    }

    public CageItem(Block blockIn, Item.Properties properties, float width, float height) {
        super(blockIn, properties);
        this.mobContainerWidth = width;
        this.mobContainerHeight = height;
    }

    public float getMobContainerHeight() {
        return this.mobContainerHeight;
    }

    public float getMobContainerWidth() {
        return this.mobContainerWidth;
    }

    protected boolean canFitEntity(Entity e) {
        float margin = 0.125f;
        float h = e.func_213302_cg() - margin;
        float w = e.func_213311_cf() - margin;
        return w < this.mobContainerWidth && h < this.mobContainerHeight;
    }

    public void playCatchSound(PlayerEntity player) {
        player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_232693_bA_, SoundCategory.BLOCKS, 1.0f, 0.7f);
    }

    public void playFailSound(PlayerEntity player) {
    }

    public void playReleaseSound(World world, Vector3d v) {
        world.func_184148_a(null, v.func_82615_a(), v.func_82617_b(), v.func_82616_c(), SoundEvents.field_187665_Y, SoundCategory.PLAYERS, 1.0f, 0.05f);
    }

    public ItemStack getFullItemStack(Entity entity2, ItemStack currentStack) {
        CompoundNBT cmp;
        ItemStack returnStack = new ItemStack((IItemProvider)this);
        if (currentStack.func_82837_s()) {
            returnStack.func_200302_a(currentStack.func_200301_q());
        }
        if ((cmp = MobHolder.createMobHolderItemNBT(entity2, this.getMobContainerWidth(), this.getMobContainerHeight())) != null) {
            returnStack.func_77983_a("BlockEntityTag", (INBT)cmp);
        }
        return returnStack;
    }

    public boolean isFull(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        return tag != null && tag.func_74764_b("BlockEntityTag");
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.isFull(stack) ? 1 : super.getItemStackLimit(stack);
    }

    public ActionResult<ItemStack> func_77659_a(World p_77659_1_, PlayerEntity p_77659_2_, Hand p_77659_3_) {
        return super.func_77659_a(p_77659_1_, p_77659_2_, p_77659_3_);
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity entity2, Hand hand) {
        if (this.isFull(stack)) {
            return ActionResultType.PASS;
        }
        return this.doInteract(stack, player, (Entity)entity2, hand);
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity2) {
        if (this.isFull(stack)) {
            return false;
        }
        Hand hand = player.func_184600_cs();
        if (hand == null || hand == Hand.OFF_HAND) {
            return false;
        }
        return this.doInteract(stack, player, entity2, player.func_184600_cs()).func_226246_a_();
    }

    protected final boolean isEntityValid(Entity e, PlayerEntity player) {
        if (!e.func_70089_S() || e instanceof LivingEntity && ((LivingEntity)e).func_233643_dh_()) {
            return false;
        }
        if (e instanceof TameableEntity) {
            TameableEntity pet = (TameableEntity)e;
            return !pet.func_70909_n() || pet.func_152114_e((LivingEntity)player);
        }
        return true;
    }

    public ActionResultType doInteract(ItemStack stack, PlayerEntity player, Entity entity2, Hand hand) {
        if (this.isEntityValid(entity2, player)) {
            if (this.canCatch(entity2)) {
                if (entity2.func_184218_aH()) {
                    entity2.func_184187_bx().func_184226_ay();
                }
                if (player.field_70170_p.field_72995_K) {
                    return ActionResultType.SUCCESS;
                }
                this.playCatchSound(player);
                this.angerNearbyEntities(entity2, player);
                Utils.swapItemNBT((PlayerEntity)player, (Hand)hand, (ItemStack)stack, (ItemStack)this.getFullItemStack(entity2, stack));
                entity2.func_70106_y();
                return ActionResultType.CONSUME;
            }
            this.playFailSound(player);
        }
        return ActionResultType.PASS;
    }

    private boolean canCatch(Entity e) {
        String name = e.func_200600_R().getRegistryName().toString();
        if (ServerConfigs.cached.CAGE_ALL_MOBS) {
            return true;
        }
        if (e instanceof ICatchableMob && ((ICatchableMob)e).canBeCaughtWithItem((Item)this)) {
            return true;
        }
        if (e instanceof SlimeEntity && ((SlimeEntity)e).func_70809_q() > 1) {
            return false;
        }
        if (CapturedMobsHelper.COMMAND_MOBS.contains(name)) {
            return true;
        }
        if (e instanceof BeeEntity) {
            return true;
        }
        return this.canItemCatch(e);
    }

    public boolean canItemCatch(Entity e) {
        if (ServerConfigs.cached.CAGE_AUTO_DETECT && this.canFitEntity(e)) {
            return true;
        }
        EntityType type = e.func_200600_R();
        boolean isBaby = e instanceof LivingEntity && ((LivingEntity)e).func_70631_g_();
        return ServerConfigs.cached.CAGE_ALL_BABIES && isBaby || type.func_220341_a(ModTags.CAGE_CATCHABLE) || type.func_220341_a(ModTags.CAGE_BABY_CATCHABLE) && isBaby;
    }

    private void angerNearbyEntities(Entity entity2, PlayerEntity player) {
        if (entity2 instanceof IAngerable && entity2 instanceof MobEntity) {
            CageItem.getEntitiesInRange((MobEntity)entity2).stream().filter(mob -> mob != entity2).map(mob -> (IAngerable)mob).forEach(mob -> {
                mob.func_241355_J__();
                mob.func_230259_a_(player.func_110124_au());
                mob.func_70604_c((LivingEntity)player);
            });
        }
        if (entity2 instanceof PiglinEntity) {
            entity2.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), 0.0f);
        }
    }

    private static List<MobEntity> getEntitiesInRange(MobEntity e) {
        double d0 = e.func_233637_b_(Attributes.field_233819_b_);
        AxisAlignedBB axisalignedbb = AxisAlignedBB.func_241549_a_((Vector3d)e.func_213303_ch()).func_72314_b(d0, 10.0, d0);
        return e.field_70170_p.func_225317_b(e.getClass(), axisalignedbb);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        CompoundNBT compoundnbt = stack.func_179543_a("BlockEntityTag");
        if (compoundnbt != null) {
            CompoundNBT com = compoundnbt.func_74775_l("MobHolder");
            if (com == null || com.isEmpty()) {
                com = compoundnbt.func_74775_l("BucketHolder");
            }
            if (com != null && com.func_74764_b("Name")) {
                tooltip.add((ITextComponent)new StringTextComponent(com.func_74779_i("Name")).func_240699_a_(TextFormatting.GRAY));
            }
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("message.supplementaries.cage").func_240699_a_(TextFormatting.ITALIC).func_240699_a_(TextFormatting.GRAY));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        CompoundNBT com = stack.func_179543_a("BlockEntityTag");
        PlayerEntity player = context.func_195999_j();
        if (!context.func_195999_j().func_225608_bj_() && com != null) {
            CompoundNBT nbt;
            Entity entity2;
            boolean success = false;
            World world = context.func_195991_k();
            Vector3d v = context.func_221532_j();
            if (com.func_74764_b("BucketHolder")) {
                ItemStack bucketStack = ItemStack.func_199557_a((CompoundNBT)com.func_74775_l("BucketHolder"));
                if (bucketStack.func_77973_b() instanceof BucketItem) {
                    ((BucketItem)bucketStack.func_77973_b()).func_203792_a(world, bucketStack, context.func_195995_a());
                    success = true;
                }
            } else if (com.func_74764_b("MobHolder") && (entity2 = EntityType.func_220335_a((CompoundNBT)(nbt = com.func_74775_l("MobHolder")).func_74775_l("EntityData"), (World)world, o -> o)) != null) {
                success = true;
                if (!world.field_72995_K) {
                    if (!player.func_184812_l_() && entity2 instanceof IAngerable) {
                        IAngerable ang = (IAngerable)entity2;
                        ang.func_241355_J__();
                        ang.func_230259_a_(player.func_110124_au());
                        ang.func_70604_c((LivingEntity)player);
                    }
                    entity2.func_70080_a(v.func_82615_a(), v.func_82617_b(), v.func_82616_c(), context.func_195990_h(), 0.0f);
                    UUID temp = entity2.func_110124_au();
                    if (nbt.func_74764_b("UUID")) {
                        UUID id = nbt.func_186857_a("UUID");
                        entity2.func_184221_a(id);
                    }
                    if (!world.func_217376_c(entity2)) {
                        entity2.func_184221_a(temp);
                        success = world.func_217376_c(entity2);
                        if (!success) {
                            Supplementaries.LOGGER.warn("Failed to release caged mob");
                        }
                    }
                }
                if (player.func_184812_l_() && nbt.func_74764_b("UUID")) {
                    nbt.func_186854_a("UUID", MathHelper.func_180182_a((Random)field_77697_d));
                }
            }
            if (success) {
                if (!world.field_72995_K) {
                    this.playReleaseSound(world, v);
                    if (!player.func_184812_l_()) {
                        ItemStack returnItem = new ItemStack((IItemProvider)this);
                        if (stack.func_82837_s()) {
                            returnItem.func_200302_a(stack.func_200301_q());
                        }
                        Utils.swapItemNBT((PlayerEntity)player, (Hand)context.func_221531_n(), (ItemStack)stack, (ItemStack)returnItem);
                    }
                }
                return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
            }
        }
        return super.func_195939_a(context);
    }

    public ActionResultType func_195942_a(BlockItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player != null && (player.func_225608_bj_() || player.func_184586_b(context.func_221531_n()).func_77973_b() == this)) {
            return super.func_195942_a(context);
        }
        return ActionResultType.PASS;
    }
}

