/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.items;

import java.util.List;
import net.mehvahdjukaar.selene.fluids.SoftFluid;
import net.mehvahdjukaar.selene.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.selene.util.PotionNBTHelper;
import net.mehvahdjukaar.selene.util.Utils;
import net.mehvahdjukaar.supplementaries.block.util.CapturedMobsHelper;
import net.mehvahdjukaar.supplementaries.block.util.MobHolder;
import net.mehvahdjukaar.supplementaries.common.ModTags;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.RegistryConfigs;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.fluids.ModSoftFluids;
import net.mehvahdjukaar.supplementaries.items.CageItem;
import net.mehvahdjukaar.supplementaries.items.tabs.JarTab;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class JarItem
extends CageItem {
    public JarItem(Block blockIn, Item.Properties properties) {
        super(blockIn, properties, 0.625f, 0.875f);
    }

    @Override
    public boolean canItemCatch(Entity e) {
        EntityType type = e.func_200600_R();
        if (e instanceof MonsterEntity) {
            return false;
        }
        if (ServerConfigs.cached.JAR_AUTO_DETECT && this.canFitEntity(e)) {
            return true;
        }
        return this.isFirefly(e) || type.func_220341_a(ModTags.JAR_CATCHABLE) || CapturedMobsHelper.CATCHABLE_FISHES.contains(type.getRegistryName().toString());
    }

    @Override
    public void playCatchSound(PlayerEntity player) {
        player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187719_p, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    @Override
    public ItemStack getFullItemStack(Entity entity2, ItemStack currentStack) {
        if (!this.isFirefly(entity2)) {
            return super.getFullItemStack(entity2, currentStack);
        }
        return new ItemStack((IItemProvider)ModRegistry.FIREFLY_JAR_ITEM.get());
    }

    public boolean isFirefly(Entity e) {
        return e.func_200600_R().getRegistryName().func_110623_a().toLowerCase().contains("firefl");
    }

    @Override
    public ActionResultType doInteract(ItemStack stack, PlayerEntity player, Entity entity2, Hand hand) {
        if (entity2 instanceof WaterMobEntity && this.isEntityValid(entity2, player)) {
            ItemStack filledBucket;
            ItemStack heldItem = player.func_184586_b(hand).func_77946_l();
            player.func_184611_a(hand, new ItemStack((IItemProvider)Items.field_151131_as));
            ActionResultType result = entity2.func_184230_a(player, hand);
            if (!result.func_226246_a_()) {
                player.func_184611_a(hand, new ItemStack((IItemProvider)Items.field_151133_ar));
                result = entity2.func_184230_a(player, hand);
            }
            if (result.func_226246_a_() && (filledBucket = player.func_184586_b(hand)) != heldItem) {
                ItemStack returnItem = new ItemStack((IItemProvider)this);
                CompoundNBT com = new CompoundNBT();
                MobHolder.saveBucketToNBT(com, filledBucket, entity2.func_200200_C_().getString(), CapturedMobsHelper.getType(entity2).getFishTexture());
                returnItem.func_77983_a("BlockEntityTag", (INBT)com);
                player.func_184598_c(hand);
                Utils.swapItem((PlayerEntity)player, (Hand)hand, (ItemStack)stack, (ItemStack)returnItem, (boolean)true);
                return ActionResultType.func_233537_a_((boolean)player.field_70170_p.field_72995_K);
            }
            player.func_184611_a(hand, heldItem);
            player.func_184598_c(hand);
        }
        return super.doInteract(stack, player, entity2, hand);
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        CompoundNBT compoundnbt = stack.func_179543_a("BlockEntityTag");
        if (compoundnbt == null) {
            if (!ClientConfigs.cached.TOOLTIP_HINTS || !Minecraft.func_71410_x().field_71474_y.field_82882_x) {
                return;
            }
            tooltip.add((ITextComponent)new TranslationTextComponent("message.supplementaries.jar").func_240699_a_(TextFormatting.ITALIC).func_240699_a_(TextFormatting.GRAY));
        } else {
            if (compoundnbt.func_150297_b("LootTable", 8)) {
                tooltip.add((ITextComponent)new StringTextComponent("???????").func_240699_a_(TextFormatting.GRAY));
            }
            if (compoundnbt.func_74764_b("FluidHolder")) {
                CompoundNBT com = compoundnbt.func_74775_l("FluidHolder");
                SoftFluid s = SoftFluidRegistry.get((String)com.func_74779_i("Fluid"));
                int count = com.func_74762_e("Count");
                if (!s.isEmpty() && count > 0) {
                    String bottle;
                    CompoundNBT nbt = null;
                    String add = "";
                    if (com.func_74764_b("NBT") && (nbt = com.func_74775_l("NBT")).func_74764_b("Bottle") && !(bottle = nbt.func_74779_i("Bottle").toLowerCase()).equals("regular")) {
                        add = "_" + bottle;
                    }
                    tooltip.add((ITextComponent)new TranslationTextComponent("message.supplementaries.fluid_tooltip", new Object[]{new TranslationTextComponent(s.getTranslationKey() + add), count}).func_240699_a_(TextFormatting.GRAY));
                    if (nbt != null) {
                        PotionNBTHelper.addPotionTooltip((CompoundNBT)nbt, tooltip, (float)1.0f);
                        return;
                    }
                }
            }
            if (compoundnbt.func_150297_b("Items", 9)) {
                NonNullList nonnulllist = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
                ItemStackHelper.func_191283_b((CompoundNBT)compoundnbt, (NonNullList)nonnulllist);
                int i = 0;
                int j = 0;
                for (ItemStack itemstack : nonnulllist) {
                    if (itemstack.func_190926_b()) continue;
                    ++j;
                    if (i > 4) continue;
                    ++i;
                    IFormattableTextComponent iformattabletextcomponent = itemstack.func_200301_q().func_230532_e_();
                    String s = iformattabletextcomponent.getString();
                    s = s.replace(" Bucket", "");
                    s = s.replace(" Bottle", "");
                    s = s.replace("Bucket of ", "");
                    StringTextComponent str = new StringTextComponent(s);
                    str.func_240702_b_(" x").func_240702_b_(String.valueOf(itemstack.func_190916_E()));
                    tooltip.add((ITextComponent)str.func_240699_a_(TextFormatting.GRAY));
                }
                if (j - i > 0) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("container.shulkerBox.more", new Object[]{j - i}).func_240699_a_(TextFormatting.ITALIC).func_240699_a_(TextFormatting.GRAY));
                }
            }
        }
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items2) {
        if (this.func_194125_a(group) && ((Boolean)RegistryConfigs.reg.JAR_TAB.get()).booleanValue() && group == ModRegistry.JAR_TAB) {
            JarTab.populateTab(items2);
        } else {
            super.func_150895_a(group, items2);
        }
    }

    public Rarity func_77613_e(ItemStack stack) {
        CompoundNBT com;
        SoftFluid s;
        CompoundNBT compoundnbt = stack.func_179543_a("BlockEntityTag");
        if (compoundnbt != null && compoundnbt.func_74764_b("FluidHolder") && (s = SoftFluidRegistry.get((String)(com = compoundnbt.func_74775_l("FluidHolder")).func_74779_i("Fluid"))) == ModSoftFluids.DIRT) {
            return Rarity.RARE;
        }
        return super.func_77613_e(stack);
    }
}

